/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bayeux;

import com.caucho.bayeux.BayeuxClient;
import java.util.ArrayList;
import java.util.HashMap;

class ChannelTree {
    private final String _segment;
    private final HashMap<String, ChannelTree> _children = new HashMap();
    private final ArrayList<BayeuxClient> _subscribers = new ArrayList();

    public ChannelTree() {
        this("");
    }

    private ChannelTree(String segment) {
        this._segment = segment;
    }

    public boolean subscribe(String channel, BayeuxClient subscriber) {
        String[] segments = channel.split("\\/");
        return this.subscribe(segments, 1, subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean subscribe(String[] segments, int i, BayeuxClient subscriber) {
        if (segments.length >= i) {
            ArrayList<BayeuxClient> arrayList = this._subscribers;
            synchronized (arrayList) {
                this._subscribers.add(subscriber);
            }
            return true;
        }
        String segment = segments[i];
        HashMap<String, ChannelTree> hashMap = this._children;
        synchronized (hashMap) {
            if ("*".equals(segments[i])) {
                if (i != segments.length - 1) {
                    return false;
                }
                for (ChannelTree child : this._children.values()) {
                    child.subscribe(segments, i + 1, subscriber);
                }
            } else if ("**".equals(segments[i])) {
                if (i != segments.length - 1) {
                    return false;
                }
                for (ChannelTree child : this._children.values()) {
                    child.subscribe(segments, i, subscriber);
                }
            } else {
                ChannelTree child = this._children.get(segment);
                if (child == null) {
                    child = new ChannelTree(segment);
                    this._children.put(segment, child);
                }
                child.subscribe(segments, i + 1, subscriber);
            }
        }
        return true;
    }

    public boolean publish(String channel, Object object) {
        String[] segments = channel.split("\\/");
        return this.publish(segments, 1, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean publish(String[] segments, int i, Object object) {
        if (segments.length >= i) {
            ArrayList<BayeuxClient> arrayList = this._subscribers;
            synchronized (arrayList) {
                for (int j = 0; j < this._subscribers.size(); ++j) {
                    this._subscribers.get(j).publish(object);
                }
            }
            return true;
        }
        String segment = segments[i];
        HashMap<String, ChannelTree> hashMap = this._children;
        synchronized (hashMap) {
            if ("*".equals(segments[i])) {
                if (i != segments.length - 1) {
                    return false;
                }
                for (ChannelTree child : this._children.values()) {
                    child.publish(segments, i + 1, object);
                }
            } else if ("**".equals(segments[i])) {
                if (i != segments.length - 1) {
                    return false;
                }
                for (ChannelTree child : this._children.values()) {
                    child.publish(segments, i, object);
                }
            } else {
                ChannelTree child = null;
                child = this._children.get(segment);
                if (child == null) {
                    return false;
                }
                child.publish(segments, i + 1, object);
            }
        }
        return true;
    }
}

