/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootManagementConfig;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;

public class BootClusterConfig {
    private static final L10N L = new L10N(BootClusterConfig.class);
    private ResinSystem _system;
    private BootResinConfig _resin;
    private String _id = "";
    private boolean _isDynamicServerEnable;
    private ArrayList<ContainerProgram> _serverDefaultList = new ArrayList();

    BootClusterConfig(ResinSystem system, BootResinConfig resin) {
        this._system = system;
        this._resin = resin;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setDynamicServerEnable(boolean isEnabled) {
        this._isDynamicServerEnable = isEnabled;
    }

    public boolean isDynamicServerEnable() {
        return this._isDynamicServerEnable;
    }

    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultList.add(program);
    }

    public void addManagement(BootManagementConfig management) {
        this._resin.setManagement(management);
    }

    public WatchdogConfig createServer() {
        WatchdogConfig config = new WatchdogConfig(this._resin.getArgs(), this._resin.getRootDirectory());
        for (int i = 0; i < this._serverDefaultList.size(); ++i) {
            this._serverDefaultList.get(i).configure(config);
        }
        return config;
    }

    public void addServer(WatchdogConfig config) throws ConfigException {
        if (this._resin.isWatchdogManagerConfig()) {
            return;
        }
        if (this._resin.findClient(config.getId()) != null) {
            throw new ConfigException(L.l("<server id='{0}'> is a duplicate server.  servers must have unique ids.", config.getId()));
        }
        this._resin.addServer(config);
        this._resin.addClient(new WatchdogClient(this._system, this._resin, config));
    }

    public void addContentProgram(ConfigProgram program) {
    }
}

