/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootManagementConfig;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogManagerConfig;
import com.caucho.cloud.security.SecurityService;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.loader.EnvironmentBean;
import com.caucho.security.AdminAuthenticator;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;

public class BootResinConfig
implements EnvironmentBean {
    private static final L10N L = new L10N(BootResinConfig.class);
    private boolean _isWatchdogManagerConfig;
    private ArrayList<ContainerProgram> _clusterDefaultList = new ArrayList();
    private ArrayList<BootClusterConfig> _clusterList = new ArrayList();
    private HashMap<String, WatchdogClient> _watchdogMap = new HashMap();
    private HashMap<String, WatchdogConfig> _serverMap = new HashMap();
    private ClassLoader _classLoader;
    private ResinSystem _system;
    private WatchdogArgs _args;
    private Path _resinHome;
    private Path _rootDirectory;
    private Path _resinDataDirectory;
    private BootManagementConfig _management;
    private String _resinSystemKey;

    BootResinConfig(ResinSystem system, WatchdogArgs args) {
        this._system = system;
        this._args = args;
        this._classLoader = this._system.getClassLoader();
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    public Path getResinHome() {
        if (this._resinHome != null) {
            return this._resinHome;
        }
        return this._args.getResinHome();
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getRootDirectory() {
        if (this._rootDirectory != null) {
            return this._rootDirectory;
        }
        return this._args.getRootDirectory();
    }

    public Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    public void setResinDataDirectory(Path path) {
        this._resinDataDirectory = path;
    }

    public Path getResinDataDirectory() {
        if (this._resinDataDirectory != null) {
            return this._resinDataDirectory;
        }
        return this.getRootDirectory().lookup("resin-data");
    }

    public void setResinSystemAuthKey(String digest) {
        SecurityService.create().setSignatureSecret(digest);
        this._resinSystemKey = digest;
    }

    public String getResinSystemAuthKey() {
        return this._resinSystemKey;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void add(AdminAuthenticator auth) {
        this.createManagement().setAdminAuthenticator(auth);
    }

    public BootManagementConfig createManagement() {
        if (this._management == null) {
            this._management = new BootManagementConfig();
        }
        return this._management;
    }

    public void setManagement(BootManagementConfig management) {
        this._management = management;
    }

    public BootManagementConfig getManagement() {
        return this._management;
    }

    public boolean isWatchdogManagerConfig() {
        return this._isWatchdogManagerConfig;
    }

    public WatchdogClient findClient(String id) {
        return this._watchdogMap.get(id);
    }

    public void addClient(WatchdogClient client) {
        this._watchdogMap.put(client.getId(), client);
    }

    public WatchdogConfig findServer(String id) {
        return this._serverMap.get(id);
    }

    public void addServer(WatchdogConfig config) {
        this._serverMap.put(config.getId(), config);
    }

    WatchdogClient addDynamicClient(WatchdogArgs args) {
        if (!args.isDynamicServer()) {
            throw new IllegalStateException();
        }
        String clusterId = args.getDynamicCluster();
        String address = args.getDynamicAddress();
        int port = args.getDynamicPort();
        BootClusterConfig cluster = this.findCluster(clusterId);
        if (cluster == null) {
            throw new ConfigException(L.l("'{0}' is an unknown cluster. -dynamic-server must specify an existing cluster", clusterId));
        }
        if (!cluster.isDynamicServerEnable()) {
            throw new ConfigException(L.l("cluster '{0}' does not have <dynamic-server-enable>. -dynamic-server requires a <dynamic-server-enable> tag.", clusterId));
        }
        WatchdogConfig config = cluster.createServer();
        config.setId(address + "-" + port);
        config.setDynamic(true);
        config.setAddress(address);
        config.setPort(port);
        cluster.addServer(config);
        this.addServer(config);
        WatchdogClient client = new WatchdogClient(this._system, this, config);
        this.addClient(client);
        return client;
    }

    public WatchdogManagerConfig createWatchdogManager() {
        this._isWatchdogManagerConfig = true;
        return new WatchdogManagerConfig(this._system, this);
    }

    public void addClusterDefault(ContainerProgram program) {
        this._clusterDefaultList.add(program);
    }

    public BootClusterConfig createCluster() {
        BootClusterConfig cluster = new BootClusterConfig(this._system, this);
        for (int i = 0; i < this._clusterDefaultList.size(); ++i) {
            this._clusterDefaultList.get(i).configure(cluster);
        }
        this._clusterList.add(cluster);
        return cluster;
    }

    BootClusterConfig findCluster(String id) {
        for (int i = 0; i < this._clusterList.size(); ++i) {
            BootClusterConfig cluster = this._clusterList.get(i);
            if (!id.equals(cluster.getId())) continue;
            return cluster;
        }
        return null;
    }

    public void addContentProgram(ConfigProgram program) {
    }
}

