/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChildTask;
import com.caucho.boot.WatchdogConfig;
import com.caucho.env.service.ResinSystem;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.WatchdogMXBean;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchdogChild {
    private static final L10N L = new L10N(WatchdogChild.class);
    private final String _id;
    private final ResinSystem _system;
    private final WatchdogConfig _config;
    private final WatchdogAdmin _admin;
    private AtomicReference<WatchdogChildTask> _taskRef = new AtomicReference();
    private boolean _isConsole;
    private Date _initialStartTime;
    private Date _lastStartTime;
    private int _startCount;

    WatchdogChild(String id, ResinSystem system, WatchdogArgs args, Path rootDirectory) {
        this._id = id;
        this._system = system;
        this._config = new WatchdogConfig(args, rootDirectory);
        this._admin = new WatchdogAdmin();
    }

    WatchdogChild(ResinSystem system, WatchdogConfig config) {
        this._id = config.getId();
        this._config = config;
        this._admin = new WatchdogAdmin();
        this._system = system;
    }

    public String getId() {
        return this._id;
    }

    WatchdogArgs getArgs() {
        return this._config.getArgs();
    }

    String[] getArgv() {
        return this._config.getArgv();
    }

    public WatchdogConfig getConfig() {
        return this._config;
    }

    public Path getJavaHome() {
        return this._config.getJavaHome();
    }

    public String getJavaExe() {
        return this._config.getJavaExe();
    }

    public ArrayList<String> getJvmArgs() {
        return this._config.getJvmArgs();
    }

    public ArrayList<String> getJvmClasspath() {
        return this._config.getJvmClasspath();
    }

    public String getSystemClassLoader() {
        return this._config.getSystemClassLoader();
    }

    public String getUserName() {
        return this._config.getUserName();
    }

    public String getGroupName() {
        return this._config.getGroupName();
    }

    public boolean isConsole() {
        return this._isConsole;
    }

    public Path getLogPath() {
        return this._config.getLogPath();
    }

    public long getShutdownWaitTime() {
        return this._config.getShutdownWaitTime();
    }

    public int getWatchdogPort() {
        return this._config.getWatchdogPort();
    }

    public String getWatchdogAddress() {
        return this._config.getWatchdogAddress();
    }

    Iterable<SocketLinkListener> getPorts() {
        return this._config.getPorts();
    }

    Path getChroot() {
        return this._config.getChroot();
    }

    Path getPwd() {
        return this._config.getPwd();
    }

    Path getResinHome() {
        return this._config.getResinHome();
    }

    Path getResinRoot() {
        return this._config.getResinRoot();
    }

    Path getResinConf() {
        return this._config.getResinConf();
    }

    boolean hasXmx() {
        return this._config.hasXmx();
    }

    boolean hasXss() {
        return this._config.hasXss();
    }

    boolean is64bit() {
        return this._config.is64bit();
    }

    public String getState() {
        WatchdogChildTask task = this._taskRef.get();
        if (task == null) {
            return "inactive";
        }
        return task.getState();
    }

    int getPid() {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.getPid();
        }
        return 0;
    }

    Serializable queryGet(Serializable payload) {
        WatchdogChildTask task = this._taskRef.get();
        if (task != null) {
            return task.queryGet(payload);
        }
        return null;
    }

    boolean isVerbose() {
        return this._config.isVerbose();
    }

    public int startConsole() {
        this._isConsole = true;
        WatchdogChildTask task = new WatchdogChildTask(this._system, this);
        if (!this._taskRef.compareAndSet(null, task)) {
            return -1;
        }
        task.start();
        return 1;
    }

    public void start() {
        WatchdogChildTask task = new WatchdogChildTask(this._system, this);
        if (!this._taskRef.compareAndSet(null, task)) {
            WatchdogChildTask oldTask = this._taskRef.get();
            if (oldTask != null && !oldTask.isActive()) {
                this._taskRef.set(task);
            } else if (!this._taskRef.compareAndSet(null, task)) {
                throw new IllegalStateException(L.l("Can't start new Resin server '{0}' because one is already running '{1}'", (Object)this._id, task));
            }
        }
        task.start();
    }

    public boolean isActive() {
        return this._taskRef.get() != null;
    }

    public void stop() {
        WatchdogChildTask task = this._taskRef.getAndSet(null);
        if (task != null) {
            task.stop();
        }
    }

    public void kill() {
        WatchdogChildTask task = this._taskRef.getAndSet(null);
        if (task != null) {
            task.kill();
        }
    }

    public void close() {
        this.kill();
        this._admin.unregister();
    }

    void notifyTaskStarted() {
        ++this._startCount;
        this._lastStartTime = new Date(Alarm.getExactTime());
        if (this._initialStartTime == null) {
            this._initialStartTime = this._lastStartTime;
        }
    }

    void completeTask(WatchdogChildTask task) {
        this._taskRef.compareAndSet(task, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    class WatchdogAdmin
    extends AbstractManagedObject
    implements WatchdogMXBean {
        WatchdogAdmin() {
            this.registerSelf();
        }

        void unregister() {
            this.unregisterSelf();
        }

        public String getId() {
            return WatchdogChild.this.getId();
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "Watchdog";
        }

        public String getResinHome() {
            return WatchdogChild.this.getResinHome().getNativePath();
        }

        public String getResinRoot() {
            return WatchdogChild.this.getResinRoot().getNativePath();
        }

        public String getResinConf() {
            return WatchdogChild.this.getResinConf().getNativePath();
        }

        public String getUserName() {
            String userName = WatchdogChild.this.getUserName();
            if (userName != null) {
                return userName;
            }
            return System.getProperty("user.name");
        }

        public String getState() {
            WatchdogChildTask task = (WatchdogChildTask)WatchdogChild.this._taskRef.get();
            if (task == null) {
                return "inactive";
            }
            return task.getState();
        }

        public Date getInitialStartTime() {
            return WatchdogChild.this._initialStartTime;
        }

        public Date getStartTime() {
            return WatchdogChild.this._lastStartTime;
        }

        public int getStartCount() {
            return WatchdogChild.this._startCount;
        }

        public void start() {
            WatchdogChild.this.start();
        }

        public void stop() {
            WatchdogChild.this.stop();
        }

        public void kill() {
            WatchdogChild.this.kill();
        }
    }
}

