/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.bam.ActorClient;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.boot.Boot;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.ResultStatus;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogKillQuery;
import com.caucho.boot.WatchdogShutdownQuery;
import com.caucho.boot.WatchdogStartQuery;
import com.caucho.boot.WatchdogStatusQuery;
import com.caucho.boot.WatchdogStopQuery;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.hmtp.HmtpClient;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchdogClient {
    private static final L10N L = new L10N(WatchdogClient.class);
    private static final Logger log = Logger.getLogger(WatchdogClient.class.getName());
    private static final long BAM_TIMEOUT = 180000L;
    public static final String WATCHDOG_JID = "watchdog@admin.resin.caucho";
    private final BootResinConfig _bootManager;
    private String _id = "";
    private ResinSystem _system;
    private WatchdogConfig _config;
    private WatchdogChild _watchdog;
    private ActorClient _conn;
    private Boot _jniBoot;

    WatchdogClient(ResinSystem system, BootResinConfig bootManager, WatchdogConfig config) {
        this._system = system;
        this._bootManager = bootManager;
        this._config = config;
        this._id = config.getId();
    }

    public WatchdogConfig getConfig() {
        return this._config;
    }

    public String getId() {
        return this._id;
    }

    public String getWatchdogAddress() {
        return this._config.getWatchdogAddress();
    }

    public int getWatchdogPort() {
        return this._config.getWatchdogPort();
    }

    String[] getArgv() {
        return this._config.getArgv();
    }

    Path getPwd() {
        return this._config.getPwd();
    }

    Path getResinHome() {
        return this._bootManager.getResinHome();
    }

    Path getRootDirectory() {
        return this._bootManager.getRootDirectory();
    }

    boolean hasXmx() {
        return this._config.hasXmx();
    }

    boolean hasXss() {
        return this._config.hasXss();
    }

    boolean is64bit() {
        return this._config.is64bit();
    }

    boolean isVerbose() {
        return this._config.isVerbose();
    }

    public String getGroupName() {
        return this._config.getGroupName();
    }

    public String getUserName() {
        return this._config.getUserName();
    }

    public Path getLogDirectory() {
        return this._config.getLogDirectory();
    }

    public Path getResinDataDirectory() {
        return this._bootManager.getResinDataDirectory();
    }

    public String getResinSystemAuthKey() {
        return this._bootManager.getResinSystemAuthKey();
    }

    public long getShutdownWaitTime() {
        return this._config.getShutdownWaitTime();
    }

    public int startConsole() throws IOException {
        if (this._watchdog == null) {
            this._watchdog = new WatchdogChild(this._system, this._config);
        }
        return this._watchdog.startConsole();
    }

    public void stopConsole() {
        this._watchdog.stop();
    }

    public String statusWatchdog() throws IOException {
        ActorClient conn = this.getConnection();
        try {
            ResultStatus status = (ResultStatus)conn.queryGet(WATCHDOG_JID, new WatchdogStatusQuery());
            if (status.isSuccess()) {
                return status.getMessage();
            }
            throw new RuntimeException(L.l("{0}: watchdog status failed because of '{1}'", (Object)this, status.getMessage()));
        }
        catch (Exception e) {
            Throwable e1 = e;
            while (e1.getCause() != null) {
                e1 = e1.getCause();
            }
            log.log(Level.FINE, e.toString(), e);
            return e1.toString();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startWatchdog(String[] argv) throws ConfigException, IOException {
        block12: {
            block13: {
                if (this.getUserName() != null && !this.hasBoot()) {
                    message = this.getTroubleshootMessage();
                    if (message == null) {
                        message = "Check the $RESIN_HOME/libexec or $RESIN_HOME/libexec64 directory for libresin_os.so.";
                    }
                    throw new ConfigException(WatchdogClient.L.l("<user-name> requires compiled JNI.\n{0}", message));
                }
                if (this.getGroupName() != null && !this.hasBoot()) {
                    message = this.getTroubleshootMessage();
                    if (message == null) {
                        message = "Check the $RESIN_HOME/libexec or $RESIN_HOME/libexec64 directory for libresin_os.so.";
                    }
                    throw new ConfigException(WatchdogClient.L.l("<group-name> requires compiled JNI.\n{0}", message));
                }
                conn = null;
                conn = this.getConnection();
                status = (ResultStatus)conn.querySet("watchdog@admin.resin.caucho", (Serializable)new WatchdogStartQuery(argv), 180000L);
                if (!status.isSuccess()) break block12;
                if (conn == null) break block13;
                conn.close();
            }
            return;
        }
        try {
            throw new ConfigException(WatchdogClient.L.l("{0}: watchdog start failed because of '{1}'", (Object)this, status.getMessage()));
        }
        catch (RemoteConnectionFailedException e) {
            WatchdogClient.log.log(Level.FINE, e.toString(), e);
            if (conn == null) ** GOTO lbl36
            conn.close();
        }
        catch (RuntimeException e) {
            try {
                throw e;
            }
            catch (Throwable var4_8) {
                if (conn != null) {
                    conn.close();
                }
                throw var4_8;
            }
        }
lbl36:
        // 2 sources

        this.launchManager(argv);
    }

    public void stopWatchdog() {
        ActorClient conn = this.getConnection();
        try {
            ResultStatus status = (ResultStatus)conn.querySet(WATCHDOG_JID, (Serializable)new WatchdogStopQuery(this.getId()), 180000L);
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog stop failed because of '{1}'", (Object)this, status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void killWatchdog() throws IOException {
        ActorClient conn = this.getConnection();
        try {
            ResultStatus status = (ResultStatus)conn.querySet(WATCHDOG_JID, (Serializable)new WatchdogKillQuery(this.getId()), 180000L);
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog kill failed because of '{1}'", (Object)this, status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void restartWatchdog(String[] argv) throws IOException {
        try {
            this.stopWatchdog();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.startWatchdog(argv);
    }

    public boolean shutdown() throws IOException {
        ActorClient conn = this.getConnection();
        try {
            ResultStatus status = (ResultStatus)conn.querySet(WATCHDOG_JID, (Serializable)new WatchdogShutdownQuery(), 180000L);
            if (!status.isSuccess()) {
                throw new RuntimeException(L.l("{0}: watchdog shutdown failed because of '{1}'", (Object)this, status.getMessage()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return true;
    }

    private ActorClient getConnection() {
        if (this._conn == null) {
            HmtpClient client = new HmtpClient("http://" + this.getWatchdogAddress() + ":" + this.getWatchdogPort() + "/hmtp");
            client.setVirtualHost("admin.resin");
            String uid = "";
            client.setEncryptPassword(true);
            client.connect(uid, this.getResinSystemAuthKey());
            this._conn = client;
        }
        return this._conn;
    }

    public void launchManager(String[] argv) throws IOException {
        int i;
        String libexecPath;
        System.out.println(L.l("Resin/{0} launching watchdog at {1}:{2}", VersionFactory.getVersion(), this.getWatchdogAddress(), this.getWatchdogPort()));
        log.fine(this + " starting ResinWatchdogManager");
        Path resinHome = this.getResinHome();
        Path resinRoot = this.getRootDirectory();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File(resinRoot.getNativePath()));
        Map<String, String> env = builder.environment();
        env.putAll(System.getenv());
        String classPath = WatchdogArgs.calculateClassPath(resinHome);
        env.put("CLASSPATH", classPath);
        if (this.is64bit()) {
            libexecPath = resinHome.lookup("libexec64").getNativePath();
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH", libexecPath);
            WatchdogClient.appendEnvPath(env, "DYLD_LIBRARY_PATH", libexecPath);
            if (CauchoSystem.isWindows()) {
                WatchdogClient.appendEnvPath(env, "Path", resinHome.lookup("win64").getNativePath());
            }
        } else {
            libexecPath = resinHome.lookup("libexec").getNativePath();
            WatchdogClient.appendEnvPath(env, "LD_LIBRARY_PATH", libexecPath);
            WatchdogClient.appendEnvPath(env, "DYLD_LIBRARY_PATH", libexecPath);
            if (CauchoSystem.isWindows()) {
                WatchdogClient.appendEnvPath(env, "Path", resinHome.lookup("win32").getNativePath());
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(this._config.getJavaExe());
        list.addAll(this._config.getWatchdogJvmArgs());
        list.add("-Dresin.watchdog=" + this._id);
        list.add("-Djava.util.logging.manager=com.caucho.log.LogManagerImpl");
        list.add("-Djavax.management.builder.initial=com.caucho.jmx.MBeanServerBuilderImpl");
        list.add("-Djava.awt.headless=true");
        list.add("-Dresin.home=" + resinHome.getFullPath());
        list.add("-Dresin.root=" + resinRoot.getFullPath());
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-Djava.class.path=") || !argv[i].startsWith("-J")) continue;
            list.add(argv[i].substring(2));
        }
        list.add("-Xrs");
        if (!this._config.hasWatchdogXss()) {
            list.add("-Xss256k");
        }
        if (!this._config.hasWatchdogXmx()) {
            list.add("-Xmx32m");
        }
        if (!list.contains("-d32") && !list.contains("-d64") && this.is64bit() && !CauchoSystem.isWindows()) {
            list.add("-d64");
        }
        if (!(list.contains("-server") || list.contains("-client") || CauchoSystem.isWindows())) {
            list.add("-server");
        }
        list.add("com.caucho.boot.WatchdogManager");
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-conf") || argv[i].equals("--conf")) {
                list.add(argv[i]);
                list.add(resinHome.lookup(argv[i + 1]).getNativePath());
                ++i;
                continue;
            }
            list.add(argv[i]);
        }
        list.add("--log-directory");
        list.add(this.getLogDirectory().getFullPath());
        builder = builder.command(list);
        Process process = null;
        try {
            process = builder.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream stdIs = process.getInputStream();
        InputStream stdErr = process.getErrorStream();
        OutputStream stdOs = process.getOutputStream();
        ProcessThreadReader reader = new ProcessThreadReader(stdIs);
        reader.setDaemon(true);
        reader.start();
        ProcessThreadReader errorReader = new ProcessThreadReader(stdErr);
        errorReader.setDaemon(true);
        errorReader.start();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        stdOs.close();
    }

    public static void appendEnvPath(Map<String, String> env, String prop, String value) {
        String winProp;
        String oldValue = env.get(prop);
        if (oldValue == null && CauchoSystem.isWindows() && (oldValue = env.get(winProp = prop.toUpperCase())) != null) {
            prop = winProp;
        }
        if (oldValue != null && !"".equals(oldValue)) {
            value = value + File.pathSeparator + oldValue;
        }
        env.put(prop, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    Boot getJniBoot() {
        if (this._jniBoot != null) {
            return this._jniBoot.isValid() ? this._jniBoot : null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.bootjni.JniBoot", false, loader);
            this._jniBoot = (Boot)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
        }
        catch (IllegalStateException e) {
            log.fine(e.toString());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return this._jniBoot != null && this._jniBoot.isValid() ? this._jniBoot : null;
    }

    private boolean hasBoot() {
        try {
            Boot boot = this.getJniBoot();
            return boot != null && boot.isValid();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    private String getTroubleshootMessage() {
        Boot boot = this.getJniBoot();
        if (this._jniBoot != null) {
            boot = this._jniBoot;
        }
        return boot != null ? boot.getValidationMessage() : null;
    }

    static class ProcessThreadReader
    extends Thread {
        private InputStream _is;

        ProcessThreadReader(InputStream is) {
            this._is = is;
        }

        public void run() {
            try {
                int ch;
                while ((ch = this._is.read()) >= 0) {
                    System.out.print((char)ch);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

