/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.admin.RemoteAdminService;
import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.BootManagementConfig;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.JniBoot;
import com.caucho.boot.ResinBoot;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogService;
import com.caucho.cloud.network.NetworkListenService;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.config.types.Period;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DependencyCheckInterval;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.LogHandlerConfig;
import com.caucho.log.RotateStream;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.security.AdminAuthenticator;
import com.caucho.security.Authenticator;
import com.caucho.server.cluster.Server;
import com.caucho.server.http.HttpProtocol;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ResinELContext;
import com.caucho.server.util.JniCauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class WatchdogManager
implements AlarmListener {
    private static L10N _L;
    private static Logger _log;
    private static WatchdogManager _watchdog;
    private Lifecycle _lifecycle = new Lifecycle();
    private WatchdogArgs _args;
    private int _watchdogPort;
    private String _adminCookie;
    private BootManagementConfig _management;
    private final ResinSystem _system;
    private Server _server;
    private SocketLinkListener _httpPort;
    private HashMap<String, WatchdogChild> _watchdogMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WatchdogManager(String[] argv) throws Exception {
        _watchdog = this;
        this._args = new WatchdogArgs(argv);
        this._system = new ResinSystem("watchdog");
        Vfs.setPwd(this._args.getRootDirectory());
        boolean isLogDirectoryExists = this.getLogDirectory().exists();
        Path logPath = this.getLogDirectory().lookup("watchdog-manager.log");
        RotateStream logStream = RotateStream.create(logPath);
        logStream.setRolloverSize(0x4000000L);
        logStream.init();
        WriteStream out = logStream.getStream();
        out.setDisableClose(true);
        EnvironmentStream.setStdout(out);
        EnvironmentStream.setStderr(out);
        LogHandlerConfig log = new LogHandlerConfig();
        log.setName("");
        log.setPath(logPath);
        log.init();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(this._system.getClassLoader());
        ThreadPool.getThreadPool().setIdleMin(4);
        ThreadPool.getThreadPool().setPriorityIdleMin(4);
        ResinELContext elContext = this._args.getELContext();
        Resin resin = Resin.createWatchdog(this._system);
        resin.preConfigureInit();
        InjectManager cdiManager = InjectManager.create();
        Config.setProperty("resinHome", elContext.getResinHome());
        Config.setProperty("resin", elContext.getResinVar());
        Config.setProperty("server", elContext.getServerVar());
        Config.setProperty("java", elContext.getJavaVar());
        Config.setProperty("system", System.getProperties());
        Config.setProperty("getenv", System.getenv());
        ResinConfigLibrary.configure(cdiManager);
        this._watchdogPort = this._args.getWatchdogPort();
        this.readConfig(this._args);
        WatchdogChild server = null;
        if (this._args.isDynamicServer()) {
            String serverId = this._args.getDynamicAddress() + "-" + this._args.getDynamicPort();
            server = this._watchdogMap.get(serverId);
        } else {
            server = this._watchdogMap.get(this._args.getServerId());
        }
        if (server == null) {
            throw new IllegalStateException(WatchdogManager.L().l("'{0}' is an unknown server", this._args.getServerId()));
        }
        JniBoot boot = new JniBoot();
        Path logDirectory = this.getLogDirectory();
        if (boot.isValid() && !isLogDirectoryExists) {
            logDirectory.mkdirs();
            boot.chown(logDirectory, server.getUserName(), server.getGroupName());
        }
        server.getConfig().logInit(logStream);
        resin.preConfigureInit();
        resin.setConfigFile(this._args.getResinConf().getNativePath());
        thread = Thread.currentThread();
        thread.setContextClassLoader(resin.getClassLoader());
        CloudSystem cloudSystem = TopologyService.getCurrent().getSystem();
        CloudCluster cluster = cloudSystem.createCluster("watchdog");
        CloudPod pod = cluster.createPod();
        pod.createStaticServer("default", "localhost", -1, false);
        this._server = resin.createServer();
        thread.setContextClassLoader(this._server.getClassLoader());
        NetworkListenService listenService = this._system.getService(NetworkListenService.class);
        this._httpPort = new SocketLinkListener();
        this._httpPort.setProtocol(new HttpProtocol());
        if (this._watchdogPort > 0) {
            this._httpPort.setPort(this._watchdogPort);
        } else {
            this._httpPort.setPort(server.getWatchdogPort());
        }
        this._httpPort.setAddress(server.getWatchdogAddress());
        this._httpPort.setAcceptThreadMin(2);
        this._httpPort.setAcceptThreadMax(3);
        this._httpPort.init();
        listenService.addListener(this._httpPort);
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._system.getClassLoader());
            cdiManager = InjectManager.create();
            AdminAuthenticator auth = null;
            if (this._management != null) {
                auth = this._management.getAdminAuthenticator();
            }
            if (auth != null) {
                BeanBuilder<Authenticator> factory = cdiManager.createBeanFactory(Authenticator.class);
                factory.type(new Type[]{Authenticator.class});
                factory.type(new Type[]{AdminAuthenticator.class});
                factory.qualifier((Annotation)DefaultLiteral.DEFAULT);
                cdiManager.addBean(factory.singleton(auth));
            }
            DependencyCheckInterval depend = new DependencyCheckInterval();
            depend.setValue(new Period(-1L));
            depend.init();
            RemoteAdminService adminService = new RemoteAdminService();
            adminService.setAuthenticationRequired(false);
            adminService.init();
            WatchdogService service = new WatchdogService(this, "watchdog@admin.resin.caucho");
            HempBroker broker = HempBroker.getCurrent();
            service.setLinkStream(broker.getBrokerStream());
            broker.addActor(service);
            ResinSystem.getCurrent().start();
            this._lifecycle.toActive();
            new Alarm(this).queue(60000L);
            Object var25_24 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    ClassLoader getClassLoader() {
        return this._system.getClassLoader();
    }

    static WatchdogManager getWatchdog() {
        return _watchdog;
    }

    public void setAdminCookie(String cookie) {
        if (this._adminCookie == null) {
            this._adminCookie = cookie;
        }
    }

    public String getAdminCookie() {
        if (this._adminCookie != null) {
            return this._adminCookie;
        }
        if (this._management != null) {
            return this._management.getAdminCookie();
        }
        return null;
    }

    boolean isActive() {
        return this._server.isActive() && this._httpPort.isActive();
    }

    Path getRootDirectory() {
        return this._args.getRootDirectory();
    }

    Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    boolean authenticate(String password) {
        String cookie = this.getAdminCookie();
        if (password == null && cookie == null) {
            return true;
        }
        return password != null && password.equals(cookie);
    }

    WatchdogChild findServer(String id) {
        return this._watchdogMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String status() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            ArrayList<String> keys = new ArrayList<String>(this._watchdogMap.keySet());
            Collections.sort(keys);
            sb.append("\nwatchdog:\n");
            sb.append("  watchdog-pid: " + this.getWatchdogPid());
            for (String key : keys) {
                WatchdogChild child = this._watchdogMap.get(key);
                sb.append("\n\n");
                sb.append("server '" + key + "' : " + child.getState() + "\n");
                if (this.getAdminCookie() == null) {
                    sb.append("  password: missing\n");
                } else {
                    sb.append("  password: ok\n");
                }
                sb.append("  user: " + System.getProperty("user.name"));
                if (child.getGroupName() != null) {
                    sb.append("(" + child.getGroupName() + ")");
                }
                sb.append("\n");
                sb.append("  root: " + child.getResinRoot() + "\n");
                sb.append("  conf: " + child.getResinConf() + "\n");
                if (child.getPid() <= 0) continue;
                sb.append("  pid: " + child.getPid());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startServer(String[] argv) throws ConfigException {
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogChild watchdog;
            WatchdogArgs args = new WatchdogArgs(argv, false);
            Vfs.setPwd(this._args.getRootDirectory());
            try {
                this.readConfig(args);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            String serverId = args.getServerId();
            if (args.isDynamicServer()) {
                serverId = args.getDynamicAddress() + "-" + args.getDynamicPort();
            }
            if ((watchdog = this._watchdogMap.get(serverId)) == null) {
                throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in '{1}'", (Object)serverId, this._args.getResinConf()));
            }
            watchdog.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopServer(String serverId) {
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogChild watchdog = this._watchdogMap.get(serverId);
            if (watchdog == null) {
                throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in {1}", (Object)serverId, this._args.getResinConf()));
            }
            watchdog.stop();
        }
    }

    void killServer(String serverId) {
        WatchdogChild watchdog = this._watchdogMap.get(serverId);
        if (watchdog == null) {
            throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in {1}", (Object)serverId, this._args.getResinConf()));
        }
        watchdog.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restartServer(String serverId, String[] argv) {
        HashMap<String, WatchdogChild> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogChild server = this._watchdogMap.get(serverId);
            if (server != null) {
                server.stop();
            }
            this.startServer(argv);
        }
    }

    boolean isValid() {
        return this._server != null && this._server.isActive();
    }

    private WatchdogChild readConfig(WatchdogArgs args) throws Exception {
        Config config = new Config();
        config.setIgnoreEnvironment(true);
        Vfs.setPwd(args.getRootDirectory());
        BootResinConfig resin = new BootResinConfig(this._system, args);
        config.configure((Object)resin, args.getResinConf(), "com/caucho/server/resin/resin.rnc");
        if (this._management == null) {
            this._management = resin.getManagement();
        }
        String serverId = args.getServerId();
        WatchdogConfig server = null;
        if (args.isDynamicServer()) {
            String clusterId = args.getDynamicCluster();
            String address = args.getDynamicAddress();
            int port = args.getDynamicPort();
            BootClusterConfig cluster = resin.findCluster(clusterId);
            if (cluster == null) {
                throw new ConfigException(WatchdogManager.L().l("'{0}' is an unknown cluster", clusterId));
            }
            server = cluster.createServer();
            serverId = address + "-" + port;
            server.setId(serverId);
            server.setAddress(address);
            server.setPort(port);
            cluster.addServer(server);
        } else {
            WatchdogClient client = resin.findClient(serverId);
            server = client != null ? client.getConfig() : resin.findServer(serverId);
        }
        WatchdogChild watchdog = this._watchdogMap.get(server.getId());
        if (watchdog != null) {
            if (watchdog.isActive()) {
                throw new ConfigException(WatchdogManager.L().l("server '{0}' cannot be started because a running instance already exists.  stop or restart the old server first.", server.getId()));
            }
            watchdog = this._watchdogMap.remove(server.getId());
            if (watchdog != null) {
                watchdog.close();
            }
        }
        watchdog = new WatchdogChild(this._system, server);
        this._watchdogMap.put(server.getId(), watchdog);
        return watchdog;
    }

    private int getWatchdogPid() {
        try {
            MBeanServer server = Jmx.getGlobalMBeanServer();
            ObjectName objName = new ObjectName("java.lang:type=Runtime");
            String runtimeName = (String)server.getAttribute(objName, "Name");
            if (runtimeName == null) {
                return 0;
            }
            int p = runtimeName.indexOf(64);
            if (p > 0) {
                int pid = Integer.parseInt(runtimeName.substring(0, p));
                return pid;
            }
            return 0;
        }
        catch (Exception e) {
            WatchdogManager.log().log(Level.FINE, e.toString(), e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        while (this._lifecycle.isActive()) {
            try {
                WatchdogManager watchdogManager = this;
                synchronized (watchdogManager) {
                    this.wait();
                }
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        try {
            if (!this._args.getResinConf().canRead()) {
                WatchdogManager.log().severe(WatchdogManager.L().l("{0} exiting because '{1}' is no longer valid", (Object)this, this._args.getResinConf()));
                System.exit(1);
            }
            Object var3_2 = null;
            alarm.queue(60000L);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            alarm.queue(60000L);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws Exception {
        boolean isValid = false;
        try {
            block4: {
                try {
                    DynamicClassLoader.setJarCacheEnabled(false);
                    JniCauchoSystem.create().initJniBackground();
                    WatchdogManager manager = new WatchdogManager(argv);
                    manager.startServer(argv);
                    boolean bl = isValid = manager.isActive() && manager.isValid();
                    if (!isValid) break block4;
                    manager.waitForExit();
                }
                catch (Exception e) {
                    WatchdogManager.log().log(Level.WARNING, e.toString(), e);
                    System.out.println(e);
                    e.printStackTrace();
                    Object var4_5 = null;
                    System.exit(1);
                    return;
                }
            }
            Object var4_4 = null;
            System.exit(1);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            System.exit(1);
            throw throwable;
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(ResinBoot.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ResinBoot.class.getName());
        }
        return _log;
    }
}

