/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.bam.QueryGet;
import com.caucho.bam.QuerySet;
import com.caucho.bam.SimpleActor;
import com.caucho.boot.ResultStatus;
import com.caucho.boot.WatchdogKillQuery;
import com.caucho.boot.WatchdogManager;
import com.caucho.boot.WatchdogShutdownQuery;
import com.caucho.boot.WatchdogStartQuery;
import com.caucho.boot.WatchdogStatusQuery;
import com.caucho.boot.WatchdogStopQuery;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

class WatchdogService
extends SimpleActor {
    private static final L10N L = new L10N(WatchdogService.class);
    private static final Logger log = Logger.getLogger(WatchdogService.class.getName());
    private final WatchdogManager _manager;
    private final String _jid;

    WatchdogService(WatchdogManager manager, String jid) {
        this._manager = manager;
        this._jid = jid;
    }

    public String getJid() {
        return this._jid;
    }

    @QuerySet
    public boolean watchdogStart(long id, String to, String from, WatchdogStartQuery start) {
        String[] argv = start.getArgv();
        try {
            this._manager.startServer(argv);
            String msg = L.l("{0}: started server", this);
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(true, msg));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = e instanceof ConfigException ? e.getMessage() : L.l("{0}: start server failed because of exception\n  {1}'", (Object)this, e.toString());
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(false, msg));
        }
        return true;
    }

    @QueryGet
    public boolean watchdogStatus(long id, String to, String from, WatchdogStatusQuery status) {
        System.out.println("STATUS: " + status + " " + to + " " + from);
        Thread.dumpStack();
        try {
            String result = this._manager.status();
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(true, result));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: status failed because of exception\n{1}'", (Object)this, e.toString());
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(false, msg));
        }
        return true;
    }

    @QuerySet
    public boolean watchdogStop(long id, String to, String from, WatchdogStopQuery stop) {
        String serverId = stop.getServerId();
        try {
            this._manager.stopServer(serverId);
            String msg = L.l("{0}: stopped server='{1}'", (Object)this, serverId);
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(true, msg));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: stop server='{1}' failed because of exception\n{2}'", this, serverId, e.toString());
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(false, msg));
        }
        return true;
    }

    @QuerySet
    public boolean watchdogKill(long id, String to, String from, WatchdogKillQuery kill) {
        String serverId = kill.getServerId();
        try {
            this._manager.killServer(serverId);
            String msg = L.l("{0}: killed server='{1}'", (Object)this, serverId);
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(true, msg));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: kill server='{1}' failed because of exception\n{2}'", this, serverId, e.toString());
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(false, msg));
        }
        return true;
    }

    @QuerySet
    public boolean watchdogShutdown(long id, String to, String from, WatchdogShutdownQuery shutdown) {
        try {
            log.info(this + " shutdown from " + from);
            String msg = L.l("{0}: shutdown", this);
            new Thread(new Shutdown()).start();
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(true, msg));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            String msg = L.l("{0}: shutdown failed because of exception\n{2}'", (Object)this, e.toString());
            this.getLinkStream().queryResult(id, from, to, new ResultStatus(false, msg));
        }
        return true;
    }

    static class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

