/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.loadbalance;

import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.cloud.loadbalance.LoadBalanceStrategy;
import com.caucho.cloud.loadbalance.SingleLoadBalanceManager;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.config.ConfigException;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.server.cluster.Server;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalanceBuilder {
    private static final L10N L = new L10N(LoadBalanceBuilder.class);
    private LoadBalanceStrategy _strategy = LoadBalanceStrategy.ADAPTIVE;
    private String _meterCategory = null;
    private ArrayList<ClientSocketFactory> _clientList = new ArrayList();

    public void setStrategy(LoadBalanceStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this._strategy = strategy;
    }

    public LoadBalanceStrategy getStrategy() {
        return this._strategy;
    }

    public void setMeterCategory(String category) {
        this._meterCategory = category;
    }

    public String getMeterCategory() {
        return this._meterCategory;
    }

    public void addAddress(String address) {
        ClientSocketFactory client = this.createClientSocketFactory(address);
        this.addClient(client);
    }

    public void addClient(ClientSocketFactory client) {
        client.init();
        client.start();
        this._clientList.add(client);
    }

    public ArrayList<ClientSocketFactory> getClientList() {
        return this._clientList;
    }

    public void setTargetCluster(String clusterId) {
        throw new IllegalStateException(L.l("{0}: setTargetCluster is invalid here", this));
    }

    public void setTargetCluster(CloudPod pod) {
        throw new IllegalStateException(L.l("{0}: setTargetCluster is invalid here", this));
    }

    public LoadBalanceManager create() {
        return new SingleLoadBalanceManager(this.getMeterCategory());
    }

    protected ClientSocketFactory createClientSocketFactory(String address) {
        int p = address.lastIndexOf(58);
        int q = address.lastIndexOf(93);
        if (p < 0 && q < p) {
            throw new ConfigException(L.l("'{0}' is an invalid address because it does not specify the port.", address));
        }
        String host = address.substring(0, p);
        int port = Integer.parseInt(address.substring(p + 1));
        Server server = Server.getCurrent();
        boolean isSecure = false;
        return new ClientSocketFactory(server.getServerId(), address, this.getMeterCategory(), address, host, port, isSecure);
    }
}

