/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.server.resin.Resin;
import java.util.ArrayList;

public class CloudClusterAdmin
extends AbstractManagedObject
implements ClusterMXBean {
    private final CloudCluster _cluster;

    public CloudClusterAdmin(CloudCluster cluster) {
        this._cluster = cluster;
    }

    public String getName() {
        return this._cluster.getId();
    }

    public HostMXBean[] getHosts() {
        return new HostMXBean[0];
    }

    public PortMXBean getPort() {
        return null;
    }

    public ResinMXBean getResin() {
        return Resin.getCurrent().getAdmin();
    }

    public PersistentStoreMXBean getPersistentStore() {
        return null;
    }

    public ClusterServerMXBean[] getServers() {
        ArrayList<ClusterServerMXBean> serverMBeansList = new ArrayList<ClusterServerMXBean>();
        for (CloudPod pod : this._cluster.getPodList()) {
            for (CloudServer server : pod.getServerList()) {
                ClusterServer clusterServer;
                if (server == null || (clusterServer = server.getData(ClusterServer.class)) == null) continue;
                serverMBeansList.add(clusterServer.getAdmin());
            }
        }
        ClusterServerMXBean[] serverMBeans = new ClusterServerMXBean[serverMBeansList.size()];
        serverMBeansList.toArray(serverMBeans);
        return serverMBeans;
    }

    public void addDynamicServer(String id, String address, int port) {
    }

    public boolean isDynamicServerEnable() {
        return false;
    }

    void register() {
        this.registerSelf();
    }

    void unregister() {
        this.unregisterSelf();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

