/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudServerListener;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TriadDispatcher;
import com.caucho.cloud.topology.TriadDispatcherDouble;
import com.caucho.cloud.topology.TriadDispatcherSingle;
import com.caucho.cloud.topology.TriadDispatcherTriple;
import com.caucho.cloud.topology.TriadServer;
import com.caucho.util.L10N;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudPod {
    private static final L10N L = new L10N(CloudPod.class);
    private final String _id;
    private final CloudCluster _cluster;
    private final int _index;
    private final CloudServer[] _servers = new CloudServer[64];
    private final CopyOnWriteArrayList<CloudServerListener> _listeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<Class<?>, Object> _dataMap = new ConcurrentHashMap();
    private TriadDispatcher<CloudServer> _serverDispatcher = new TriadDispatcher();
    private int _maxIndex = -1;

    public CloudPod(CloudCluster cluster, String id, int index) {
        this._cluster = cluster;
        this._index = index;
        if (index < 0 || index >= 4096) {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid pod index because it's not between 0 and 64.", 4096L));
        }
        if (cluster == null) {
            throw new NullPointerException();
        }
        this._id = id != null ? id : (index == 0 ? "main" : String.valueOf(index));
    }

    public final String getId() {
        return this._id;
    }

    public final int getIndex() {
        return this._index;
    }

    public final CloudCluster getCluster() {
        return this._cluster;
    }

    public final CloudSystem getSystem() {
        return this.getCluster().getSystem();
    }

    public CloudServer[] getServerList() {
        return this._servers;
    }

    public int getServerLength() {
        return this._maxIndex + 1;
    }

    public CloudServer findServer(String id) {
        for (int i = 0; i <= this._maxIndex; ++i) {
            CloudServer server = this._servers[i];
            if (server == null || !server.getId().equals(id)) continue;
            return server;
        }
        return null;
    }

    public CloudServer findServerByUniqueClusterId(String id) {
        for (int i = 0; i <= this._maxIndex; ++i) {
            CloudServer server = this._servers[i];
            if (server == null || !server.getIdWithinCluster().equals(id)) continue;
            return server;
        }
        return null;
    }

    public CloudServer findServer(int index) {
        return this._servers[index];
    }

    public CloudServer findServer(String address, int port) {
        for (int i = 0; i <= this._maxIndex; ++i) {
            CloudServer server = this._servers[i];
            if (server == null || !server.getAddress().equals(address) || server.getPort() <= 0 || server.getPort() != port) continue;
            return server;
        }
        return null;
    }

    public void putData(Object value) {
        this._dataMap.put(value.getClass(), value);
    }

    public <T> T putDataIfAbsent(T value) {
        return (T)this._dataMap.putIfAbsent(value.getClass(), value);
    }

    public <T> T getData(Class<T> cl) {
        return (T)this._dataMap.get(cl);
    }

    public void addServerListener(CloudServerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
        for (CloudServer server : this.getServerList()) {
            if (server == null) continue;
            listener.onServerAdd(server);
        }
    }

    public void removeServerListener(CloudServerListener listener) {
        this._listeners.remove(listener);
    }

    public CloudServer createStaticServer(String id, String address, int port, boolean isSecure) {
        return this.createServer(id, address, port, isSecure, true);
    }

    public CloudServer createDynamicServer(String id, String address, int port, boolean isSecure) {
        return this.createServer(id, address, port, isSecure, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloudServer createServer(String id, String address, int port, boolean isSecure, boolean isStatic) {
        CloudServer server;
        boolean isSSL = false;
        CloudPod cloudPod = this;
        synchronized (cloudPod) {
            if (this.findServer(id) != null) {
                throw new IllegalArgumentException(L.l("'{0}' is an invalid server name because that name already exists as\n  {1}.", (Object)id, this.findServer(id)));
            }
            if (this.findServer(address, port) != null) {
                throw new IllegalArgumentException(L.l("'{0}:{1}' is an invalid server address because that name already exists as\n  {2}.", address, port, this.findServer(address, port)));
            }
            int index = this.findFirstFreeIndex();
            server = index <= 2 ? new TriadServer(id, this, index, address, port, isSSL, isStatic) : new CloudServer(id, this, index, address, port, isSSL, isStatic);
            this._servers[index] = server;
            if (this._maxIndex < index) {
                this._maxIndex = index;
            }
        }
        this.updateDispatcher();
        for (CloudServerListener listener : this._listeners) {
            listener.onServerAdd(server);
            if (!(server instanceof TriadServer)) continue;
            listener.onTriadAdd((TriadServer)server);
        }
        return server;
    }

    public TriadDispatcher<CloudServer> getTriadServerDispatcher() {
        return this._serverDispatcher;
    }

    private void updateDispatcher() {
        switch (this._maxIndex) {
            case 0: {
                this._serverDispatcher = new TriadDispatcherSingle<CloudServer>(this._servers[0]);
                break;
            }
            case 1: {
                this._serverDispatcher = new TriadDispatcherDouble<CloudServer>(this._servers[0], this._servers[1]);
                break;
            }
            default: {
                this._serverDispatcher = new TriadDispatcherTriple<CloudServer>(this._servers[0], this._servers[1], this._servers[2]);
            }
        }
    }

    private int findFirstFreeIndex() {
        for (int i = 0; i <= this._maxIndex; ++i) {
            if (this._servers[i] != null) continue;
            return i;
        }
        return this._maxIndex + 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getIndex() + "," + this.getId() + ",cluster=" + this._cluster.getId() + "]";
    }
}

