/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TriadOwner;
import com.caucho.util.L10N;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudServer {
    private static final L10N L = new L10N(CloudServer.class);
    private static final int[] DECODE = new int[128];
    private final String _id;
    private final CloudPod _pod;
    private final int _index;
    private String _uniqueClusterId;
    private String _uniqueDomainId;
    private String _address;
    private int _port;
    private boolean _isSSL;
    private final ConcurrentHashMap<Class<?>, Object> _dataMap = new ConcurrentHashMap();

    public CloudServer(String id, CloudPod pod, int index, String address, int port, boolean isSSL, boolean isStatic) {
        if (id.equals("")) {
            throw new IllegalArgumentException();
        }
        this._id = id;
        this._pod = pod;
        this._index = index;
        if (index < 0 || index >= 64) {
            throw new IllegalArgumentException(L.l("'{0}' is an invalid server index because it must be between 0 and 64", index));
        }
        if (!isStatic && index == 0) {
            throw new IllegalArgumentException(L.l("The first server must be static."));
        }
        if (id == null) {
            throw new NullPointerException();
        }
        if (pod == null) {
            throw new NullPointerException();
        }
        this._address = address;
        this._port = port;
        this._isSSL = isSSL;
        StringBuilder sb = new StringBuilder();
        sb.append(CloudServer.convert(this.getIndex()));
        sb.append(CloudServer.convert(this.getPod().getIndex()));
        sb.append(CloudServer.convert(this.getPod().getIndex() / 64));
        this._uniqueClusterId = sb.toString();
        String clusterId = pod.getCluster().getId();
        if (clusterId.equals("")) {
            clusterId = "default";
        }
        this._uniqueDomainId = this._uniqueClusterId + "." + clusterId.replace('.', '_');
    }

    public final String getId() {
        return this._id;
    }

    public final String getDebugId() {
        if ("".equals(this._id)) {
            return "default";
        }
        return this._id;
    }

    public final int getIndex() {
        return this._index;
    }

    public final String getIdWithinCluster() {
        return this._uniqueClusterId;
    }

    public final String getIdWithinDomain() {
        return this._uniqueDomainId;
    }

    public boolean isTriad() {
        return false;
    }

    public boolean isStatic() {
        return true;
    }

    public CloudPod getPod() {
        return this._pod;
    }

    public CloudCluster getCluster() {
        return this.getPod().getCluster();
    }

    public CloudSystem getSystem() {
        return this.getCluster().getSystem();
    }

    public TriadOwner getTriadOwner() {
        return TriadOwner.getOwner(this.getIndex());
    }

    public final String getAddress() {
        return this._address;
    }

    public final int getPort() {
        return this._port;
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    public void putData(Object value) {
        this._dataMap.put(value.getClass(), value);
    }

    public <T> T putDataIfAbsent(T value) {
        return (T)this._dataMap.putIfAbsent(value.getClass(), value);
    }

    public <T> T getData(Class<T> cl) {
        return (T)this._dataMap.get(cl);
    }

    public <T> T removeData(Class<T> cl) {
        return (T)this._dataMap.remove(cl);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "," + this._index + "," + this._address + ":" + this._port + "]";
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    public static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    static {
        for (int i = 0; i < 64; ++i) {
            CloudServer.DECODE[CloudServer.convert((long)((long)i))] = i;
        }
    }
}

