/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.config.ConfigException;
import com.caucho.config.bytecode.ScopeProxy;
import com.caucho.config.event.AbstractObserverMethod;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.program.BeanArg;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverMethodImpl<X, T>
extends AbstractObserverMethod<T> {
    private static final L10N L = new L10N(ObserverMethodImpl.class);
    private InjectManager _cdiManager;
    private Bean<X> _bean;
    private AnnotatedMethod<X> _method;
    private Type _type;
    private Set<Annotation> _qualifiers;
    private BeanArg<X>[] _args;
    private boolean _isIfExists;
    private boolean _isStatic;
    private TransactionPhase _transactionPhase = TransactionPhase.IN_PROGRESS;

    public ObserverMethodImpl(InjectManager beanManager, Bean<X> bean, AnnotatedMethod<X> method, Type type, Set<Annotation> qualifiers) {
        this._cdiManager = beanManager;
        this._bean = bean;
        this._method = method;
        this._method.getJavaMember().setAccessible(true);
        this._isStatic = this._method.isStatic();
        this._type = type;
        this._qualifiers = qualifiers;
        this.introspect();
    }

    public AnnotatedMethod<X> getAnnotatedMethod() {
        return this._method;
    }

    public Bean<X> getParentBean() {
        return this._bean;
    }

    @Override
    public Class<X> getBeanClass() {
        return this._bean.getBeanClass();
    }

    @Override
    public Type getObservedType() {
        return this._type;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return this._qualifiers;
    }

    private void introspect() {
        List parameters = this._method.getParameters();
        Method javaMethod = this._method.getJavaMember();
        this._args = new BeanArg[parameters.size()];
        for (int i = 0; i < this._args.length; ++i) {
            AnnotatedParameter param = (AnnotatedParameter)parameters.get(i);
            Observes observes = (Observes)param.getAnnotation(Observes.class);
            if (observes != null) {
                this._isIfExists = observes.notifyObserver() == Reception.IF_EXISTS;
                this._transactionPhase = observes.during();
            } else {
                InjectionPointImpl<X> ip = new InjectionPointImpl<X>(this._cdiManager, this._bean, param);
                this._args[i] = new BeanArg(this._cdiManager, param.getBaseType(), this._cdiManager.getQualifiers(param.getAnnotations()), ip);
            }
            if (!param.isAnnotationPresent(Disposes.class)) continue;
            throw new ConfigException(L.l("{0}.{1} may not have @Observes and @Disposes on the same method", (Object)javaMethod.getDeclaringClass().getName(), javaMethod.getName()));
        }
        if (this._isIfExists && this._bean.getScope() == Dependent.class) {
            throw new ConfigException(L.l("{0}.{1} @Observer cannot use IF_EXISTS because the bean has Dependent scope", (Object)javaMethod.getDeclaringClass().getName(), javaMethod.getName()));
        }
    }

    @Override
    public void notify(T event) {
        this.notifyImpl(event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyImpl(T event) {
        Object instance;
        OwnerCreationalContext<X> env;
        block18: {
            env = null;
            OwnerCreationalContext argEnv = null;
            if (this._isIfExists) {
                instance = this.getExistsInstance();
                if (instance == null) {
                    return;
                }
            } else if (this._isStatic) {
                instance = null;
            } else if (this._bean.getScope() == Dependent.class) {
                env = new OwnerCreationalContext<X>(this.getParentBean());
                instance = this.getParentBean().create(env);
            } else {
                instance = this._cdiManager.getReference(this.getParentBean());
            }
            if (this._args != null && this._args.length > 1) {
                argEnv = new OwnerCreationalContext(null);
            }
            Method method = this._method.getJavaMember();
            try {
                try {
                    Object object = instance instanceof ScopeProxy ? ((ScopeProxy)instance).__caucho_getDelegate() : instance;
                    method.invoke(object, this.getEventArguments(event, argEnv));
                }
                catch (IllegalArgumentException e) {
                    String loc = method.getDeclaringClass().getSimpleName() + "." + method.getName() + ": ";
                    throw new ObserverException(loc + e.toString(), e.getCause());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    Throwable exn = e.getCause();
                    if (exn instanceof RuntimeException) {
                        throw (RuntimeException)exn;
                    }
                    String loc = method.getDeclaringClass().getSimpleName() + "." + method.getName() + ": ";
                    throw new ObserverException(loc + exn.toString(), exn.getCause());
                }
                catch (Exception e) {
                    String loc = method.getDeclaringClass().getSimpleName() + "." + method.getName() + ": ";
                    throw new ObserverException(loc + e.toString(), e.getCause());
                }
                Object var10_11 = null;
                if (argEnv == null) break block18;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (argEnv != null) {
                    argEnv.release();
                }
                if (env == null) throw throwable;
                this.getParentBean().destroy(instance, env);
                throw throwable;
            }
            argEnv.release();
        }
        if (env == null) return;
        this.getParentBean().destroy(instance, env);
    }

    protected X getExistsInstance() {
        Bean<X> bean = this.getParentBean();
        Class scopeType = bean.getScope();
        Context context = this._cdiManager.getContext(scopeType);
        if (context != null) {
            return (X)context.get(bean);
        }
        return null;
    }

    protected Object[] getEventArguments(Object event, CreationalContextImpl<?> parentEnv) {
        if (this._args == null) {
            return new Object[]{event};
        }
        Object[] args = new Object[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            BeanArg<X> arg = this._args[i];
            args[i] = arg != null ? arg.eval(parentEnv) : event;
        }
        return args;
    }

    @Override
    public Reception getReception() {
        if (this._isIfExists) {
            return Reception.IF_EXISTS;
        }
        return Reception.ALWAYS;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this._transactionPhase;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

