/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.DecoratorBean;
import com.caucho.config.inject.DelegateProxyBean;
import com.caucho.config.inject.DependentCreationalContext;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InterceptorRuntimeBean;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandiUtil {
    private static final L10N L = new L10N(CandiUtil.class);
    private static final Logger log = Logger.getLogger(CandiUtil.class.getName());
    public static final Object[] NULL_OBJECT_ARRAY = new Object[0];

    private CandiUtil() {
    }

    public static Object invoke(Method method, Object bean, Object ... args) {
        try {
            return method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(method.getName() + ": " + e, e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(method.getName() + ": " + e, e);
        }
    }

    public static int[] createInterceptors(InjectManager manager, ArrayList<InterceptorRuntimeBean<?>> staticBeans, ArrayList<Interceptor<?>> beans, int[] staticIndexList, InterceptionType type, Annotation ... bindings) {
        int i;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        List<Object> interceptors = bindings != null && bindings.length > 0 ? manager.resolveInterceptors(type, bindings) : new ArrayList();
        if (staticIndexList != null) {
            for (i = 0; i < staticIndexList.length; ++i) {
                int staticIndex = staticIndexList[i];
                InterceptorRuntimeBean<?> staticBean = staticBeans.get(staticIndex);
                CandiUtil.addStaticBean(staticBean, indexList, beans, type);
            }
        }
        for (i = 0; i < interceptors.size(); ++i) {
            Interceptor interceptor = (Interceptor)interceptors.get(i);
            int index = beans.indexOf(interceptor);
            if (index >= 0) {
                indexList.add(index);
                continue;
            }
            indexList.add(beans.size());
            beans.add(interceptor);
        }
        int[] indexArray = new int[indexList.size()];
        for (int i2 = 0; i2 < indexList.size(); ++i2) {
            indexArray[i2] = indexList.get(i2);
        }
        return indexArray;
    }

    private static void addStaticBean(InterceptorRuntimeBean<?> staticBean, ArrayList<Integer> indexList, ArrayList<Interceptor<?>> beans, InterceptionType type) {
        if (staticBean == null) {
            return;
        }
        if (!beans.contains(staticBean)) {
            beans.add(staticBean);
        }
        CandiUtil.addStaticBean(staticBean.getParent(), indexList, beans, type);
        if (staticBean.intercepts(type)) {
            int index = beans.indexOf(staticBean);
            indexList.add(index);
        }
    }

    public static void createInterceptors(InjectManager manager, ArrayList<Interceptor<?>> beans, Annotation ... bindings) {
        if (bindings == null || bindings.length == 0) {
            return;
        }
        CandiUtil.createInterceptors(manager, beans, InterceptionType.AROUND_INVOKE, bindings);
        CandiUtil.createInterceptors(manager, beans, InterceptionType.POST_CONSTRUCT, bindings);
        CandiUtil.createInterceptors(manager, beans, InterceptionType.PRE_DESTROY, bindings);
    }

    public static void createInterceptors(InjectManager manager, ArrayList<Interceptor<?>> beans, InterceptionType type, Annotation ... bindings) {
        List<Interceptor<?>> interceptors = manager.resolveInterceptors(type, bindings);
        for (Interceptor<?> bean : interceptors) {
            int index = beans.indexOf(bean);
            if (index >= 0) continue;
            beans.add(bean);
        }
    }

    public static void validatePassivating(Class<?> cl, ArrayList<Interceptor<?>> beans) {
        for (Interceptor<?> interceptor : beans) {
            CandiUtil.validatePassivating(cl, interceptor, "interceptor");
        }
    }

    public static void validatePassivatingDecorators(Class<?> cl, List<Decorator<?>> beans) {
        for (Decorator<?> decorator : beans) {
            CandiUtil.validatePassivating(cl, decorator, "decorator");
        }
    }

    public static void validatePassivating(Class<?> cl, Bean<?> bean, String typeName) {
        Class beanClass = bean.getBeanClass();
        if (!Serializable.class.isAssignableFrom(beanClass)) {
            // empty if block
        }
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            Class<?> type;
            if (ip.isTransient() || ip.isDelegate() || (type = CandiUtil.getRawClass(ip.getType())).isInterface() || Serializable.class.isAssignableFrom(type)) continue;
            ConfigException exn = new ConfigException(L.l("{0}: {1} is an invalid {4} because its injection point '{2}' of type {3} is not serializable.", cl.getName(), bean, ip.getMember().getName(), ip.getType(), typeName));
            throw exn;
        }
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }

    public static Interceptor<?>[] createMethods(ArrayList<Interceptor<?>> beans, InterceptionType type, int[] indexChain) {
        Interceptor[] methods = new Interceptor[indexChain.length];
        for (int i = 0; i < indexChain.length; ++i) {
            int index = indexChain[i];
            methods[i] = beans.get(index);
        }
        return methods;
    }

    public static Method[] createDecoratorMethods(List<Decorator<?>> decorators, String methodName, Class<?> ... paramTypes) {
        Method[] methods = new Method[decorators.size()];
        for (int i = 0; i < decorators.size(); ++i) {
            Decorator<?> decorator = decorators.get(i);
            Class beanClass = decorator.getBeanClass();
            try {
                methods[decorators.size() - i - 1] = beanClass.getMethod(methodName, paramTypes);
                methods[decorators.size() - i - 1].setAccessible(true);
                continue;
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        return methods;
    }

    public static Method getMethod(Class<?> cl, String methodName, Class<?> ... paramTypes) throws Exception {
        Method method = null;
        Exception firstException = null;
        do {
            try {
                method = cl.getDeclaredMethod(methodName, paramTypes);
            }
            catch (Exception e) {
                if (firstException == null) {
                    firstException = e;
                }
                cl = cl.getSuperclass();
            }
        } while (method == null && cl != null);
        if (method == null) {
            throw firstException;
        }
        method.setAccessible(true);
        return method;
    }

    public static Method findMethod(Class<?> cl, String methodName, Class<?> ... paramTypes) {
        for (Class<?> ptr = cl; ptr != null; ptr = ptr.getSuperclass()) {
            for (Method method : ptr.getDeclaredMethods()) {
                if (!AnnotatedTypeUtil.isMatch(method, methodName, paramTypes)) continue;
                return method;
            }
        }
        log.warning(L.l("'{0}' is an unknown method in {1}", (Object)methodName, cl.getName()));
        return null;
    }

    public static Object[] generateProxyDelegate(InjectManager manager, List<Decorator<?>> beans, Object delegateProxy, CreationalContextImpl<?> parentEnv) {
        Object[] instances = new Object[beans.size()];
        DependentCreationalContext<Object> proxyEnv = new DependentCreationalContext<Object>((Contextual<Object>)DelegateProxyBean.BEAN, parentEnv, null);
        proxyEnv.push(delegateProxy);
        for (int i = 0; i < beans.size(); ++i) {
            Decorator<?> bean = beans.get(i);
            DependentCreationalContext env = new DependentCreationalContext((Contextual<?>)bean, (CreationalContextImpl<?>)proxyEnv, null);
            Object instance = manager.getReference((Bean<?>)bean, bean.getBeanClass(), env);
            InjectionPoint ip = CandiUtil.getDelegate(bean);
            if (ip.getMember() instanceof Field) {
                Field field = (Field)ip.getMember();
                field.setAccessible(true);
                try {
                    field.set(instance, delegateProxy);
                }
                catch (Exception e) {
                    throw new InjectionException((Throwable)e);
                }
            }
            if (ip.getMember() instanceof Method) {
                Method method = (Method)ip.getMember();
                method.setAccessible(true);
                try {
                    method.invoke(instance, delegateProxy);
                }
                catch (Exception e) {
                    throw new InjectionException((Throwable)e);
                }
            }
            instances[beans.size() - i - 1] = instance;
            if (!(parentEnv instanceof CreationalContextImpl)) continue;
            parentEnv.setInjectionPoint(ip);
        }
        return instances;
    }

    private static InjectionPoint getDelegate(Decorator<?> bean) {
        if (bean instanceof DecoratorBean) {
            return ((DecoratorBean)bean).getDelegateInjectionPoint();
        }
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            if (!ip.isDelegate()) continue;
            return ip;
        }
        throw new IllegalStateException(String.valueOf(bean));
    }

    public static int nextDelegate(Object[] beans, Method[] methods, int index) {
        --index;
        while (index >= 0) {
            if (methods[index] != null) {
                return index;
            }
            --index;
        }
        return index;
    }

    public static int nextDelegate(Object[] beans, Class<?>[] apis, int index) {
        --index;
        while (index >= 0) {
            for (Class<?> api : apis) {
                if (!api.isAssignableFrom(beans[index].getClass())) continue;
                return index;
            }
            --index;
        }
        return index;
    }
}

