/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AspectGeneratorUtil;
import com.caucho.config.gen.MethodHeadFactory;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class MethodHeadGenerator<X>
extends AbstractAspectGenerator<X> {
    public MethodHeadGenerator(MethodHeadFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        super(factory, method, next);
    }

    protected boolean isOverride() {
        return true;
    }

    @Override
    public final void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        this.generateMethodPrologue(out, prologueMap);
        String prefix = "";
        String suffix = "";
        int modifiers = this.getJavaMethod().getModifiers();
        String accessModifier = null;
        if (Modifier.isPublic(modifiers)) {
            accessModifier = "public";
        } else if (Modifier.isProtected(modifiers)) {
            accessModifier = "protected";
        }
        AspectGeneratorUtil.generateHeader(out, this.isOverride(), accessModifier, prefix, this.getJavaMethod(), suffix, this.getThrowsExceptions());
        out.println("{");
        out.pushDepth();
        this.generateContent(out, prologueMap);
        out.popDepth();
        out.println("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodHeadGenerator)) {
            return false;
        }
        MethodHeadGenerator bizMethod = (MethodHeadGenerator)o;
        return AnnotatedTypeUtil.isMatch(this.getJavaMethod(), bizMethod.getJavaMethod());
    }
}

