/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ProducesCreationalContext;
import com.caucho.config.program.Arg;
import com.caucho.inject.Module;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class DisposesProducer<T, X>
implements Producer<T> {
    private final Bean<X> _producerBean;
    private final InjectManager.ReferenceFactory<X> _referenceFactory;
    private final AnnotatedMethod<? super X> _disposesMethod;
    private Arg<?>[] _disposesArgs;

    DisposesProducer(InjectManager manager, Bean<X> producerBean, AnnotatedMethod<? super X> disposesMethod, Arg<?>[] disposesArgs) {
        this._producerBean = producerBean;
        this._referenceFactory = manager.getReferenceFactory(producerBean);
        this._disposesMethod = disposesMethod;
        this._disposesArgs = disposesArgs;
        disposesMethod.getJavaMember().setAccessible(true);
    }

    public T produce(CreationalContext<T> cxt) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void dispose(T instance) {
        this.destroy(instance, null);
    }

    public void destroy(T instance, CreationalContextImpl<T> cxt) {
        if (this._disposesMethod != null) {
            try {
                ProducesCreationalContext<X> env = new ProducesCreationalContext<X>(this._producerBean, cxt);
                X producer = this._referenceFactory.create(env, null, null);
                Object[] args = new Object[this._disposesArgs.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this._disposesArgs[i] == null ? instance : this._disposesArgs[i].eval(env);
                }
                this._disposesMethod.getJavaMember().invoke(producer, args);
                if (this._producerBean.getScope() == Dependent.class) {
                    this._producerBean.destroy(producer, env);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(this._disposesMethod.getJavaMember() + ":" + e, e);
            }
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

