/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.SerializeHandle;
import com.caucho.config.bytecode.SerializationAdapter;
import com.caucho.config.gen.CandiBeanGenerator;
import com.caucho.config.inject.CandiProducer;
import com.caucho.config.inject.CdiStatefulBean;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.CurrentLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointHandler;
import com.caucho.config.inject.InjectionPointImpl;
import com.caucho.config.inject.SingletonHandle;
import com.caucho.config.j2ee.PostConstructProgram;
import com.caucho.config.j2ee.PreDestroyInject;
import com.caucho.config.program.Arg;
import com.caucho.config.program.BeanArg;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ResourceProgramManager;
import com.caucho.config.reflect.AnnotatedConstructorImpl;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.ejb.Stateful;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class InjectionTargetBuilder<X>
implements InjectionTarget<X> {
    private static final L10N L = new L10N(InjectionTargetBuilder.class);
    private static final Logger log = Logger.getLogger(InjectionTargetBuilder.class.getName());
    private InjectManager _cdiManager;
    private Class<X> _instanceClass;
    private Bean<X> _bean;
    private final AnnotatedType<X> _annotatedType;
    private AnnotatedConstructor<X> _beanCtor;
    private CandiProducer<X> _producer;
    private Constructor<X> _javaCtor;
    private boolean _isGenerateInterception = true;
    private ConfigProgram[] _newArgs;
    private Set<InjectionPoint> _injectionPointSet;

    public InjectionTargetBuilder(InjectManager cdiManager, AnnotatedType<X> beanType, Bean<X> bean) {
        this._cdiManager = cdiManager;
        this._annotatedType = beanType;
        this._bean = bean;
    }

    public InjectionTargetBuilder(InjectManager cdiManager, AnnotatedType<X> beanType) {
        this(cdiManager, beanType, null);
    }

    protected InjectManager getBeanManager() {
        return this._cdiManager;
    }

    public AnnotatedType<X> getAnnotatedType() {
        return this._annotatedType;
    }

    void setBean(Bean<X> bean) {
        this._bean = bean;
    }

    Bean<X> getBean() {
        return this._bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InjectionPoint> getInjectionPoints() {
        InjectionTargetBuilder injectionTargetBuilder = this;
        synchronized (injectionTargetBuilder) {
            if (this._producer == null) {
                this._producer = this.build();
                this.validate(this.getBean());
            }
        }
        return this._producer.getInjectionPoints();
    }

    public void setGenerateInterception(boolean isEnable) {
        this._isGenerateInterception = isEnable;
    }

    public X produce(CreationalContext<X> env) {
        if (this._producer == null) {
            this.getInjectionPoints();
        }
        return this._producer.produce(env);
    }

    public void inject(X instance, CreationalContext<X> env) {
        if (this._producer == null) {
            this.getInjectionPoints();
        }
        this._producer.inject(instance, env);
    }

    public void postConstruct(X instance) {
        if (this._producer == null) {
            this.getInjectionPoints();
        }
        this._producer.postConstruct(instance);
    }

    public ConfigProgram[] getPostConstructProgram() {
        if (this._producer == null) {
            this.getInjectionPoints();
        }
        return this._producer.getPostConstructProgram();
    }

    public void setPostConstructProgram(ConfigProgram[] program) {
        this._producer.setPostConstructProgram(program);
    }

    public void preDestroy(X instance) {
        if (this._producer == null) {
            this.getInjectionPoints();
        }
        this._producer.preDestroy(instance);
    }

    public void dispose(X instance) {
        if (this._producer == null) {
            this.getInjectionPoints();
        }
        this._producer.dispose(instance);
    }

    protected Object getHandle() {
        return new SingletonHandle(null);
    }

    public String getPassivationId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CandiProducer<X> build() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            CandiProducer<X> producer;
            thread.setContextClassLoader(this.getBeanManager().getClassLoader());
            this.introspect();
            Class cl = (Class)this._annotatedType.getBaseType();
            if (this._beanCtor == null) {
                AnnotatedType<X> beanType = this._annotatedType;
                if (beanType == null) {
                    beanType = ReflectionAnnotatedFactory.introspectType(cl);
                }
                this.introspectConstructor(beanType);
            }
            Class<Object> instanceClass = null;
            if (this._isGenerateInterception) {
                if (!this._annotatedType.isAnnotationPresent(Interceptor.class) && !this._annotatedType.isAnnotationPresent(Decorator.class)) {
                    CandiBeanGenerator<X> bean = new CandiBeanGenerator<X>(this.getBeanManager(), this._annotatedType);
                    bean.introspect();
                    instanceClass = bean.generateClass();
                }
                if (instanceClass == cl && this.isSerializeHandle()) {
                    instanceClass = SerializationAdapter.gen(instanceClass);
                }
            }
            if (instanceClass != null && instanceClass != this._instanceClass) {
                try {
                    if (this._javaCtor != null) {
                        this._javaCtor = InjectionTargetBuilder.getConstructor(instanceClass, this._javaCtor.getParameterTypes());
                        this._javaCtor.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            ConfigProgram[] injectProgram = this.introspectInject(this._annotatedType);
            ConfigProgram[] initProgram = this.introspectPostConstruct(this._annotatedType);
            ArrayList<ConfigProgram> destroyList = new ArrayList<ConfigProgram>();
            this.introspectDestroy(destroyList, this._annotatedType);
            ConfigProgram[] destroyProgram = new ConfigProgram[destroyList.size()];
            destroyList.toArray(destroyProgram);
            Arg[] args = null;
            if (this._beanCtor != null) {
                args = this.introspectArguments((Annotated)this._beanCtor, this._beanCtor.getParameters());
            }
            CandiProducer<X> candiProducer = producer = new CandiProducer<X>(this._bean, instanceClass, this._javaCtor, args, injectProgram, initProgram, destroyProgram, this._injectionPointSet);
            Object var13_13 = null;
            thread.setContextClassLoader(oldLoader);
            return candiProducer;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private static Constructor<?> getConstructor(Class<?> cl, Class<?>[] paramTypes) {
        for (Constructor<?> ctor : cl.getDeclaredConstructors()) {
            if (!InjectionTargetBuilder.isMatch(ctor.getParameterTypes(), paramTypes)) continue;
            return ctor;
        }
        throw new IllegalStateException("No matching constructor found for " + cl);
    }

    private static boolean isMatch(Class<?>[] paramTypesA, Class<?>[] paramTypesB) {
        if (paramTypesA.length != paramTypesB.length) {
            return false;
        }
        for (int i = paramTypesA.length - 1; i >= 0; --i) {
            if (paramTypesA[i].equals(paramTypesB[i])) continue;
            return false;
        }
        return true;
    }

    private ConfigProgram[] introspectPostConstruct(AnnotatedType<X> annType) {
        if (annType.isAnnotationPresent(Interceptor.class)) {
            return new ConfigProgram[0];
        }
        ArrayList<ConfigProgram> initList = new ArrayList<ConfigProgram>();
        InjectionTargetBuilder.introspectInit(initList, annType);
        Object[] initProgram = new ConfigProgram[initList.size()];
        initList.toArray(initProgram);
        Arrays.sort(initProgram);
        return initProgram;
    }

    public static void introspectInit(ArrayList<ConfigProgram> initList, AnnotatedType<?> type) throws ConfigException {
        for (AnnotatedMethod annMethod : type.getMethods()) {
            Method method = annMethod.getJavaMember();
            if (!annMethod.isAnnotationPresent(PostConstruct.class) || method.getParameterTypes().length == 1 && InvocationContext.class.equals(method.getParameterTypes()[0])) continue;
            if (method.isAnnotationPresent(PostConstruct.class) && method.getParameterTypes().length != 0) {
                throw new ConfigException(InjectionTargetBuilder.location(method) + L.l("{0}: @PostConstruct is requires zero arguments"));
            }
            PostConstructProgram initProgram = new PostConstructProgram(annMethod, method);
            if (initList.contains(initProgram)) continue;
            initList.add(initProgram);
        }
    }

    private void introspectDestroy(ArrayList<ConfigProgram> destroyList, AnnotatedType<?> type) throws ConfigException {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        if (type.isAnnotationPresent(Interceptor.class)) {
            return;
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            Method javaMethod = method.getJavaMember();
            Class<?>[] types = javaMethod.getParameterTypes();
            if (types.length != 0) {
                if (types.length == 1 && types[0].equals(InvocationContext.class)) continue;
                throw new ConfigException(InjectionTargetBuilder.location(javaMethod) + L.l("@PreDestroy is requires zero arguments"));
            }
            PreDestroyInject destroyProgram = new PreDestroyInject(javaMethod);
            if (destroyList.contains(destroyProgram)) continue;
            destroyList.add(destroyProgram);
        }
    }

    private void introspect() {
        this.introspect(this._annotatedType);
    }

    private void introspect(AnnotatedType<X> beanType) {
        this.introspectConstructor(beanType);
    }

    private void introspectConstructor(AnnotatedType<X> beanType) {
        if (this._beanCtor != null) {
            return;
        }
        if (beanType.getJavaClass().isInterface()) {
            return;
        }
        try {
            AnnotatedConstructorImpl<X> best = null;
            AnnotatedConstructorImpl<X> second = null;
            for (AnnotatedConstructorImpl<X> ctor : beanType.getConstructors()) {
                if (this._newArgs != null && ctor.getParameters().size() != this._newArgs.length) continue;
                if (best == null) {
                    best = ctor;
                    continue;
                }
                if (ctor.isAnnotationPresent(Inject.class)) {
                    if (best != null && best.isAnnotationPresent(Inject.class)) {
                        throw new ConfigException(L.l("'{0}' can't have two constructors marked by @Inject or by a @Qualifier, because the Java Injection BeanManager can't tell which one to use.", beanType.getJavaClass().getName()));
                    }
                    best = ctor;
                    second = null;
                    continue;
                }
                if (best.isAnnotationPresent(Inject.class)) continue;
                if (ctor.getParameters().size() == 0) {
                    best = ctor;
                    continue;
                }
                if (best.getParameters().size() == 0 || ctor.getParameters().size() != 1 || !((AnnotatedParameter)ctor.getParameters().get(0)).equals(String.class)) continue;
                second = best;
                best = ctor;
            }
            if (best == null) {
                best = new AnnotatedConstructorImpl<X>(beanType, beanType.getJavaClass().getConstructor(new Class[0]));
            }
            if (best == null) {
                throw new ConfigException(L.l("{0}: no constructor found while introspecting bean for Java Injection", beanType.getJavaClass().getName()));
            }
            if (second != null) {
                if (beanType.getJavaClass().getName().startsWith("java.lang") && best.getParameters().size() == 1 && ((AnnotatedParameter)best.getParameters().get(0)).equals(String.class)) {
                    log.fine(L.l("{0}: WebBean does not have a unique constructor, choosing String-arg constructor", beanType.getJavaClass().getName()));
                } else {
                    throw new ConfigException(L.l("{0}: Bean does not have a unique constructor.  One constructor must be marked with @Inject or have a qualifier annotation.", beanType.getJavaClass().getName()));
                }
            }
            this._beanCtor = best;
            this._javaCtor = this._beanCtor.getJavaMember();
            this._javaCtor.setAccessible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private Arg<X>[] introspectArguments(Annotated ann, List<AnnotatedParameter<X>> params) {
        Arg[] args = new Arg[params.size()];
        for (int i = 0; i < args.length; ++i) {
            AnnotatedParameter<X> param = params.get(i);
            args[i] = this.introspectArg(ann, param);
        }
        return args;
    }

    private Arg<X> introspectArg(Annotated ann, AnnotatedParameter<X> param) {
        Annotation[] qualifiers = this.getQualifiers((Annotated)param);
        InjectionPointImpl ip = new InjectionPointImpl(this.getBeanManager(), this, param);
        if (ann.isAnnotationPresent(Inject.class)) {
            this._injectionPointSet.add(ip);
        }
        if (param.isAnnotationPresent(Disposes.class)) {
            throw new ConfigException(L.l("{0} is an invalid managed bean because its constructor has a @Disposes parameter", this.getAnnotatedType().getJavaClass().getName()));
        }
        if (param.isAnnotationPresent(Observes.class)) {
            throw new ConfigException(L.l("{0} is an invalid managed bean because its constructor has an @Observes parameter", this.getAnnotatedType().getJavaClass().getName()));
        }
        return new BeanArg(this.getBeanManager(), param.getBaseType(), qualifiers, ip);
    }

    private Annotation[] getQualifiers(Annotated annotated) {
        ArrayList<Annotation> qualifierList = new ArrayList<Annotation>();
        for (Annotation ann : annotated.getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifierList.add(ann);
        }
        if (qualifierList.size() == 0) {
            qualifierList.add((Annotation)CurrentLiteral.CURRENT);
        }
        Annotation[] qualifiers = new Annotation[qualifierList.size()];
        qualifierList.toArray(qualifiers);
        return qualifiers;
    }

    private ConfigProgram[] introspectInject(AnnotatedType<X> type) {
        ArrayList<ConfigProgram> injectProgramList = new ArrayList<ConfigProgram>();
        this._injectionPointSet = new HashSet<InjectionPoint>();
        this.introspectInject(type, injectProgramList);
        Object[] injectProgram = new ConfigProgram[injectProgramList.size()];
        injectProgramList.toArray(injectProgram);
        Arrays.sort(injectProgram);
        return injectProgram;
    }

    private void introspectInject(AnnotatedType<X> type, ArrayList<ConfigProgram> injectProgramList) {
        Class rawType = (Class)type.getBaseType();
        if (rawType == null || Object.class.equals((Object)rawType)) {
            return;
        }
        this.introspectInjectClass(type, injectProgramList);
        this.introspectInjectField(type, injectProgramList);
        this.introspectInjectMethod(type, injectProgramList);
        ResourceProgramManager resourceManager = this._cdiManager.getResourceManager();
        resourceManager.buildInject(rawType, injectProgramList);
    }

    private void introspectInjectClass(AnnotatedType<X> type, ArrayList<ConfigProgram> injectProgramList) {
        InjectManager cdiManager = this.getBeanManager();
        for (Annotation ann : type.getAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            InjectionPointHandler handler = cdiManager.getInjectionPointHandler(annType);
            if (handler == null) continue;
            injectProgramList.add(new ClassHandlerProgram(ann, handler));
        }
        for (Class parentClass = type.getJavaClass().getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            for (Annotation ann : parentClass.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                InjectionPointHandler handler = cdiManager.getInjectionPointHandler(annType);
                if (handler == null) continue;
                injectProgramList.add(new ClassHandlerProgram(ann, handler));
            }
        }
    }

    private void introspectInjectField(AnnotatedType<X> type, ArrayList<ConfigProgram> injectProgramList) {
        for (AnnotatedField field : type.getFields()) {
            if (field.getAnnotations().size() == 0) continue;
            if (field.isAnnotationPresent(Inject.class)) {
                InjectionPointImpl ij = new InjectionPointImpl(this.getBeanManager(), this, field);
                this._injectionPointSet.add(ij);
                if (field.isAnnotationPresent(Delegate.class)) continue;
                injectProgramList.add(new FieldInjectProgram(field.getJavaMember(), ij));
                continue;
            }
            InjectionPointHandler handler = this.getBeanManager().getInjectionPointHandler(field);
            if (handler == null) continue;
            FieldHandlerProgram program = new FieldHandlerProgram(field, handler);
            injectProgramList.add(program);
        }
    }

    private void introspectInjectMethod(AnnotatedType<X> type, ArrayList<ConfigProgram> injectProgramList) {
        for (AnnotatedMethod method : type.getMethods()) {
            if (method.getAnnotations().size() == 0) continue;
            if (method.isAnnotationPresent(Inject.class)) {
                List params = method.getParameters();
                InjectionPoint[] args = new InjectionPoint[params.size()];
                for (int i = 0; i < args.length; ++i) {
                    InjectionPointImpl ij = new InjectionPointImpl(this.getBeanManager(), this, (AnnotatedParameter)params.get(i));
                    this._injectionPointSet.add(ij);
                    args[i] = ij;
                }
                injectProgramList.add(new MethodInjectProgram(method.getJavaMember(), args));
                continue;
            }
            InjectionPointHandler handler = this.getBeanManager().getInjectionPointHandler(method);
            if (handler == null) continue;
            MethodHandlerProgram program = new MethodHandlerProgram(method, handler);
            injectProgramList.add(program);
        }
    }

    private void validate(Bean<?> bean) {
        if (bean == null) {
            return;
        }
        Class scopeType = bean.getScope();
        if (this.getBeanManager().isPassivatingScope(scopeType)) {
            this.validatePassivating(bean);
        } else if (this.getBeanManager().isNormalScope(scopeType)) {
            // empty if block
        }
    }

    private void validatePassivating(Bean<?> bean) {
        Type baseType = this._annotatedType.getBaseType();
        Class<?> cl = this.getBeanManager().createTargetBaseType(baseType).getRawClass();
        boolean isStateful = this._annotatedType.isAnnotationPresent(Stateful.class);
        if (!Serializable.class.isAssignableFrom(cl) && !isStateful) {
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because it's not serializable for {2}.", cl.getSimpleName(), bean.getScope().getSimpleName(), bean));
        }
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            Class ipClass;
            if (ip.isTransient()) continue;
            Type type = ip.getType();
            if (ip.getBean() instanceof CdiStatefulBean || !(type instanceof Class) || (ipClass = (Class)type).isInterface() || Serializable.class.isAssignableFrom(ipClass) || this.getBeanManager().isNormalScope(ip.getBean().getScope())) continue;
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because '{2}' value {3} is not serializable for {4}.", cl.getSimpleName(), bean.getScope().getSimpleName(), ip.getType(), ip.getMember().getName(), bean));
        }
    }

    public static boolean isValid(Class<?> type) {
        if (type.isInterface()) {
            return false;
        }
        if (type.getTypeParameters() != null && type.getTypeParameters().length > 0) {
            return false;
        }
        return InjectionTargetBuilder.isValidConstructor(type);
    }

    public static boolean isValidConstructor(Class<?> type) {
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length == 0) {
                return true;
            }
            if (!ctor.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    private static String location(Method method) {
        String className = method.getDeclaringClass().getName();
        return className + "." + method.getName() + ": ";
    }

    private boolean isSerializeHandle() {
        return this.getAnnotatedType().isAnnotationPresent(SerializeHandle.class);
    }

    private static boolean hasQualifierAnnotation(AnnotatedConstructor<?> ctor) {
        return ctor.isAnnotationPresent(Inject.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._annotatedType + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MethodHandlerProgram
    extends ConfigProgram {
        private final AnnotatedMethod<?> _method;
        private final InjectionPointHandler _handler;
        private ConfigProgram _boundProgram;

        MethodHandlerProgram(AnnotatedMethod<?> method, InjectionPointHandler handler) {
            this._method = method;
            this._handler = handler;
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public <T> void inject(T instance, CreationalContext<T> env) {
            if (this._boundProgram == null) {
                this.bind();
            }
            this._boundProgram.inject(instance, env);
        }

        @Override
        public void bind() {
            this._boundProgram = this._handler.introspectMethod(this._method);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassHandlerProgram
    extends ConfigProgram {
        private final Annotation _ann;
        private final InjectionPointHandler _handler;
        private ConfigProgram _boundProgram;

        ClassHandlerProgram(Annotation ann, InjectionPointHandler handler) {
            this._ann = ann;
            this._handler = handler;
        }

        @Override
        public <T> void inject(T instance, CreationalContext<T> env) {
            if (this._boundProgram == null) {
                this.bind();
            }
            this._boundProgram.inject(instance, env);
        }

        @Override
        public void bind() {
            this._boundProgram = this._handler.introspectType(InjectionTargetBuilder.this._annotatedType);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + InjectionTargetBuilder.this._annotatedType + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FieldHandlerProgram
    extends ConfigProgram {
        private final AnnotatedField<?> _field;
        private final InjectionPointHandler _handler;
        private ConfigProgram _boundProgram;

        FieldHandlerProgram(AnnotatedField<?> field, InjectionPointHandler handler) {
            this._field = field;
            this._handler = handler;
        }

        @Override
        public <T> void inject(T instance, CreationalContext<T> env) {
            if (this._boundProgram == null) {
                this.bind();
            }
            this._boundProgram.inject(instance, env);
        }

        @Override
        public void bind() {
            this._boundProgram = this._handler.introspectField(this._field);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._field + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MethodInjectProgram
    extends ConfigProgram {
        private final Method _method;
        private final InjectionPoint[] _args;
        private InjectManager.ReferenceFactory<?>[] _factoryArgs;

        MethodInjectProgram(Method method, InjectionPoint[] args) {
            this._method = method;
            this._method.setAccessible(true);
            this._args = args;
            this._factoryArgs = new InjectManager.ReferenceFactory[args.length];
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this._method.getDeclaringClass();
        }

        @Override
        public String getName() {
            return this._method.getName();
        }

        @Override
        public <T> void inject(T instance, CreationalContext<T> cxt) {
            try {
                CreationalContextImpl env = cxt instanceof CreationalContextImpl ? (CreationalContextImpl)cxt : null;
                Object[] args = new Object[this._args.length];
                for (int i = 0; i < this._args.length; ++i) {
                    if (this._factoryArgs[i] == null) {
                        this._factoryArgs[i] = InjectionTargetBuilder.this.getBeanManager().getReferenceFactory(this._args[i]);
                    }
                    args[i] = this._factoryArgs[i].create(null, env, this._args[i]);
                }
                this._method.invoke(instance, args);
            }
            catch (Exception e) {
                throw ConfigException.create(this._method, (Throwable)e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FieldInjectProgram
    extends ConfigProgram {
        private final Field _field;
        private final InjectionPoint _ip;
        private final InjectManager.ReferenceFactory<?> _fieldFactory;

        FieldInjectProgram(Field field, InjectionPoint ip) {
            this._field = field;
            this._field.setAccessible(true);
            this._ip = ip;
            InjectManager beanManager = InjectionTargetBuilder.this.getBeanManager();
            try {
                this._fieldFactory = beanManager.getReferenceFactory(this._ip);
            }
            catch (AmbiguousResolutionException e) {
                String loc = this.getLocation(field);
                throw new AmbiguousResolutionException(loc + e.getMessage(), (Throwable)e);
            }
            catch (UnsatisfiedResolutionException e) {
                String loc = this.getLocation(field);
                throw new UnsatisfiedResolutionException(loc + e.getMessage(), (Throwable)e);
            }
            catch (IllegalProductException e) {
                String loc = this.getLocation(field);
                throw new IllegalProductException(loc + e.getMessage(), (Throwable)e);
            }
            catch (InjectionException e) {
                String loc = this.getLocation(field);
                throw new InjectionException(loc + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this._field.getDeclaringClass();
        }

        @Override
        public String getName() {
            return this._field.getName();
        }

        private String getLocation(Field field) {
            return this._field.getDeclaringClass().getName() + "." + this._field.getName() + ": ";
        }

        @Override
        public <T> void inject(T instance, CreationalContext<T> cxt) {
            try {
                CreationalContextImpl env = cxt instanceof CreationalContextImpl ? (CreationalContextImpl)cxt : null;
                Object value = this._fieldFactory.create(null, env, this._ip);
                this._field.set(instance, value);
            }
            catch (AmbiguousResolutionException e) {
                throw new AmbiguousResolutionException(this.getFieldName(this._field) + e.getMessage(), (Throwable)e);
            }
            catch (IllegalProductException e) {
                throw new IllegalProductException(this.getFieldName(this._field) + e.getMessage(), (Throwable)e);
            }
            catch (InjectionException e) {
                throw new InjectionException(this.getFieldName(this._field) + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw ConfigException.create(this._field, (Throwable)e);
            }
        }

        private String getFieldName(Field field) {
            return field.getDeclaringClass().getSimpleName() + "." + field.getName() + ": ";
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._field + "]";
        }
    }
}

