/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ProducesMethodBean;
import com.caucho.config.inject.QualifierBinding;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class WebComponent {
    private static final Logger log = Logger.getLogger(WebComponent.class.getName());
    private InjectManager _beanManager;
    private Class<?> _rawType;
    private BeanEntry _injectionPointEntry;
    private ArrayList<BeanEntry> _beanList = new ArrayList();

    public WebComponent(InjectManager beanManager, Class<?> rawType) {
        this._beanManager = beanManager;
        this._rawType = rawType;
    }

    public void addComponent(BaseType type, Annotated annotated, Bean<?> bean) {
        for (BeanEntry beanEntry : this._beanList) {
            if (!beanEntry.getType().equals(type) || !beanEntry.isMatch(bean)) continue;
            return;
        }
        if (bean instanceof ProducesMethodBean && ((ProducesMethodBean)bean).isInjectionPoint()) {
            this._injectionPointEntry = new BeanEntry(type, annotated, bean);
        }
        this._beanList.add(new BeanEntry(type, annotated, bean));
        Collections.sort(this._beanList);
    }

    public void resolveSpecializes() {
        for (int i = this._beanList.size() - 1; i >= 0; --i) {
            BeanEntry entry = this._beanList.get(i);
            Annotated ann = entry.getAnnotated();
            if (ann != null && ann.isAnnotationPresent(Specializes.class)) continue;
        }
    }

    public void createProgram(ArrayList<ConfigProgram> initList, Field field, ArrayList<Annotation> bindList) throws ConfigException {
    }

    public Set<Bean<?>> resolve(Type type, Annotation[] bindings) {
        BaseType baseType = this._beanManager.createTargetBaseType(type);
        return this.resolve(baseType, bindings);
    }

    public Set<Bean<?>> resolve(BaseType type, Annotation[] qualifiers) {
        LinkedHashSet<Object> beans = null;
        if (this._injectionPointEntry != null) {
            beans = new LinkedHashSet();
            beans.add(this._injectionPointEntry.getBean());
            return beans;
        }
        boolean isVariable = !type.isGenericRaw();
        for (BeanEntry beanEntry : this._beanList) {
            if (!beanEntry.isMatch(type, qualifiers)) continue;
            if (beans == null) {
                beans = new LinkedHashSet();
            }
            if (isVariable && !beanEntry.getType().isGenericVariable()) {
                isVariable = false;
                beans.clear();
            }
            beans.add(beanEntry.getBean());
        }
        return beans;
    }

    public ArrayList<Bean<?>> getBeanList() {
        ArrayList list = new ArrayList();
        for (BeanEntry beanEntry : this._beanList) {
            Bean<?> bean = beanEntry.getBean();
            if (list.contains(bean)) continue;
            list.add(bean);
        }
        return list;
    }

    public ArrayList<Bean<?>> getEnabledBeanList() {
        ArrayList list = new ArrayList();
        int priority = 0;
        for (BeanEntry beanEntry : this._beanList) {
            Bean<?> bean = beanEntry.getBean();
            int beanPriority = this._beanManager.getDeploymentPriority(bean);
            if (priority > beanPriority) continue;
            list.add(bean);
        }
        return list;
    }

    public void validate() {
        for (BeanEntry beanEntry : this._beanList) {
            Bean<?> bean = beanEntry.getBean();
            int beanPriority = this._beanManager.getDeploymentPriority(bean);
            if (beanPriority < 0) continue;
            for (InjectionPoint ip : bean.getInjectionPoints()) {
                this._beanManager.validate(ip);
            }
        }
    }

    static String getName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return String.valueOf(type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._rawType + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BeanEntry
    implements Comparable<BeanEntry> {
        private Bean<?> _bean;
        private BaseType _type;
        private Annotated _annotated;
        private QualifierBinding[] _qualifiers;

        BeanEntry(BaseType type, Annotated annotated, Bean<?> bean) {
            this._type = type;
            this._annotated = annotated;
            this._bean = bean;
            Set qualifiers = bean.getQualifiers();
            this._qualifiers = new QualifierBinding[qualifiers.size()];
            int i = 0;
            for (Annotation qualifier : qualifiers) {
                this._qualifiers[i++] = new QualifierBinding(qualifier);
            }
        }

        Bean<?> getBean() {
            return this._bean;
        }

        Annotated getAnnotated() {
            return this._annotated;
        }

        BaseType getType() {
            return this._type;
        }

        boolean isMatch(Bean<?> bean) {
            return this._bean == bean;
        }

        boolean isMatch(BaseType type, Annotation[] qualifiers) {
            return this.isMatch(type) && this.isMatch(qualifiers);
        }

        boolean isMatch(BaseType type) {
            return type.isAssignableFrom(this._type);
        }

        boolean isMatch(Annotation[] qualifierArgs) {
            for (Annotation arg : qualifierArgs) {
                if (this.isMatch(arg)) continue;
                return false;
            }
            return true;
        }

        private boolean isMatch(Annotation arg) {
            if (arg.annotationType() == Any.class) {
                return true;
            }
            for (QualifierBinding binding : this._qualifiers) {
                if (!binding.isMatch(arg)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(BeanEntry test) {
            String beanClassNameTest;
            Bean<?> bean = test._bean;
            String beanClassName = this._bean.getBeanClass().getName();
            int beanTypeCompare = beanClassName.compareTo(beanClassNameTest = bean.getBeanClass().getName());
            if (beanTypeCompare != 0) {
                return beanTypeCompare;
            }
            Iterator qualifierIterA = this._bean.getQualifiers().iterator();
            Iterator qualifierIterB = bean.getQualifiers().iterator();
            while (qualifierIterA.hasNext() && qualifierIterB.hasNext()) {
                String annTypeB;
                Annotation qualifierA = (Annotation)qualifierIterA.next();
                Annotation qualifierB = (Annotation)qualifierIterB.next();
                String annTypeA = qualifierA.annotationType().getName();
                int cmp = annTypeA.compareTo(annTypeB = qualifierB.annotationType().getName());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._bean + "]";
        }
    }
}

