/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointHandler;
import com.caucho.config.program.ValueGenerator;
import com.caucho.naming.Jndi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaeeInjectionHandler
extends InjectionPointHandler {
    private InjectManager _manager;

    protected JavaeeInjectionHandler(InjectManager manager) {
        this._manager = manager;
    }

    protected InjectManager getManager() {
        return this._manager;
    }

    protected Bean<?> bind(String location, Class<?> type, String name) {
        try {
            InjectManager injectManager = this.getManager();
            Set<Object> beans = null;
            if ("".equals(name)) {
                name = null;
            }
            if ((beans = name != null ? injectManager.getBeans(type, new Annotation[]{Names.create(name)}) : injectManager.getBeans(type, new Annotation[]{DefaultLiteral.DEFAULT})) != null && beans.size() != 0) {
                return injectManager.resolve(beans);
            }
            beans = injectManager.getBeans(type, new Annotation[]{new AnnotationLiteral<Any>(){}});
            if (beans == null || beans.size() == 0) {
                return null;
            }
            for (Bean bean : beans) {
                if (name != null && !name.equals(bean.getName())) continue;
                return bean;
            }
            return null;
        }
        catch (AmbiguousResolutionException e) {
            throw new AmbiguousResolutionException(location + (Object)((Object)e), (Throwable)e);
        }
        catch (InjectionException e) {
            throw new InjectionException(location + (Object)((Object)e), (Throwable)e);
        }
    }

    protected Bean<?> bind(String location, Class<?> type, Annotation ... qualifiers) {
        try {
            Bean bean;
            InjectManager injectManager = this.getManager();
            Set beans = null;
            beans = injectManager.getBeans(type, qualifiers);
            if (beans != null && (bean = injectManager.resolve(beans)) != null) {
                return bean;
            }
            throw injectManager.unsatisfiedException(type, qualifiers);
        }
        catch (UnsatisfiedResolutionException e) {
            throw new UnsatisfiedResolutionException(location + (Object)((Object)e), (Throwable)e);
        }
        catch (InjectionException e) {
            throw new InjectionException(location + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void bindJndi(String name, ValueGenerator gen, String fullJndiName) {
        if (name == null || "".equals(name)) {
            name = fullJndiName;
        }
        if (!name.startsWith("java:")) {
            name = "java:comp/env/" + name;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                if (this._manager.getJndiClassLoader() != null) {
                    thread.setContextClassLoader(this._manager.getJndiClassLoader());
                }
                Jndi.bindDeep(name, gen);
            }
            catch (NamingException e) {
                throw ConfigException.create(e);
            }
            Object var8_6 = null;
            thread.setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            thread.setContextClassLoader(loader);
            throw throwable;
        }
    }

    protected void bindJndi(Field field, ValueGenerator gen) {
        String name = "java:comp/env/" + field.getDeclaringClass().getName() + "/" + field.getName();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                if (this._manager.getJndiClassLoader() != null) {
                    thread.setContextClassLoader(this._manager.getJndiClassLoader());
                }
                Jndi.bindDeep(name, gen);
            }
            catch (NamingException e) {
                throw ConfigException.create(e);
            }
            Object var8_6 = null;
            thread.setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            thread.setContextClassLoader(loader);
            throw throwable;
        }
    }

    protected void bindJndi(Method method, ValueGenerator gen) {
        String methodName = method.getName();
        if (methodName.startsWith("set")) {
            methodName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        String name = "java:comp/env/" + method.getDeclaringClass().getName() + "/" + methodName;
        try {
            Jndi.bindDeep(name, gen);
        }
        catch (NamingException e) {
            throw ConfigException.create(e);
        }
    }

    protected String getLocation(Field javaField) {
        return javaField.getDeclaringClass().getName() + "." + javaField.getName() + " ";
    }

    protected String getLocation(Method javaMethod) {
        return javaMethod.getDeclaringClass().getName() + "." + javaMethod.getName() + " ";
    }
}

