/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.j2ee.JavaeeInjectionHandler;
import com.caucho.config.j2ee.PersistenceContextGenerator;
import com.caucho.config.program.BeanValueGenerator;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FieldGeneratorProgram;
import com.caucho.config.program.MethodGeneratorProgram;
import com.caucho.config.program.NullProgram;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextHandler
extends JavaeeInjectionHandler {
    private static final L10N L = new L10N(PersistenceContextHandler.class);

    public PersistenceContextHandler(InjectManager manager) {
        super(manager);
    }

    @Override
    public ConfigProgram introspectType(AnnotatedType<?> type) {
        PersistenceContext pContext = (PersistenceContext)type.getAnnotation(PersistenceContext.class);
        String location = type.getJavaClass().getName() + ": ";
        String jndiName = null;
        if (!"".equals(pContext.name())) {
            jndiName = pContext.name();
        }
        Bean<?> bean = this.bindEntityManager(location, pContext);
        BeanValueGenerator gen = new BeanValueGenerator(location, bean);
        if (jndiName != null) {
            this.bindJndi(jndiName, gen, null);
        }
        return new NullProgram();
    }

    @Override
    public ConfigProgram introspectField(AnnotatedField<?> field) {
        PersistenceContext pContext = (PersistenceContext)field.getAnnotation(PersistenceContext.class);
        PersistenceContextType type = pContext.type();
        Field javaField = field.getJavaMember();
        String location = this.getLocation(javaField);
        if (!javaField.getType().isAssignableFrom(EntityManager.class)) {
            throw new ConfigException(L.l("{0}: @PersistenceContext field must be assignable from EntityManager.", this.getLocation(javaField)));
        }
        ValueGenerator gen = PersistenceContextType.EXTENDED.equals((Object)type) ? this.generateExtendedContext(location, pContext) : this.generateTransactionContext(location, pContext);
        return new FieldGeneratorProgram(javaField, gen);
    }

    @Override
    public ConfigProgram introspectMethod(AnnotatedMethod<?> method) {
        PersistenceContext pContext = (PersistenceContext)method.getAnnotation(PersistenceContext.class);
        Method javaMethod = method.getJavaMember();
        String location = this.getLocation(javaMethod);
        Class<EntityManager> param = javaMethod.getParameterTypes()[0];
        if (!param.isAssignableFrom(EntityManager.class)) {
            throw new ConfigException(L.l("{0}: @PersistenceContext method must be assignable from EntityManager.", this.getLocation(javaMethod)));
        }
        BeanValueGenerator gen = this.generateTransactionContext(location, pContext);
        return new MethodGeneratorProgram(javaMethod, gen);
    }

    private BeanValueGenerator generateTransactionContext(String location, PersistenceContext pContext) throws ConfigException {
        Bean<?> bean = this.bindEntityManager(location, pContext);
        BeanValueGenerator gen = new BeanValueGenerator(location, bean);
        return gen;
    }

    private ValueGenerator generateExtendedContext(String location, PersistenceContext pContext) {
        PersistenceContextGenerator gen = new PersistenceContextGenerator(location, pContext);
        return gen;
    }

    private Bean<?> bindEntityManager(String location, PersistenceContext pContext) {
        String name = pContext.name();
        String unitName = pContext.unitName();
        Bean<?> bean = this.bind(location, EntityManager.class, unitName);
        if (bean == null) {
            bean = this.bind(location, EntityManager.class, name);
        }
        if (bean == null) {
            if (!"".equals(unitName)) {
                throw new ConfigException(location + L.l("unitName='{0}' is an unknown @PersistenceContext.", unitName));
            }
            if (!"".equals(name)) {
                throw new ConfigException(location + L.l("name='{0}' is an unknown @PersistenceContext.", name));
            }
            throw new ConfigException(location + L.l("@PersistenceContext cannot find any persistence contexts.  No JPA persistence-units have been deployed"));
        }
        return bean;
    }
}

