/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

public class BeanValueGenerator
extends ValueGenerator {
    private static final Logger log = Logger.getLogger(BeanValueGenerator.class.getName());
    private static final L10N L = new L10N(BeanValueGenerator.class);
    private final InjectManager _beanManager;
    private final Bean _bean;
    private final String _location;

    public BeanValueGenerator(String location, Bean bean) {
        if (bean == null) {
            throw new NullPointerException();
        }
        this._location = location;
        this._beanManager = InjectManager.create();
        this._bean = bean;
    }

    public Object create() {
        CreationalContext env = this._beanManager.createCreationalContext(this._bean);
        Class type = this._bean.getBeanClass();
        return this._beanManager.getReference(this._bean, type, env);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._bean + "]";
    }
}

