/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.AnnotatedElementImpl;
import com.caucho.config.reflect.AnnotatedParameterImpl;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AnnotatedMethodImpl<T>
extends AnnotatedElementImpl
implements AnnotatedMethod<T> {
    private AnnotatedType<T> _declaringType;
    private Method _method;
    private List<AnnotatedParameter<T>> _parameterList;

    public AnnotatedMethodImpl(Method method) {
        this(null, null, method);
    }

    public AnnotatedMethodImpl(AnnotatedType<T> declaringType, Annotated annotated, Method method) {
        super(method.getGenericReturnType(), annotated, method.getAnnotations());
        this._declaringType = declaringType;
        this._method = method;
    }

    public AnnotatedType<T> getDeclaringType() {
        return this._declaringType;
    }

    public Method getJavaMember() {
        return this._method;
    }

    public List<AnnotatedParameter<T>> getParameters() {
        if (this._parameterList == null) {
            this._parameterList = this.introspectParameters(this._method);
        }
        return this._parameterList;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this._method.getModifiers());
    }

    private List<AnnotatedParameter<T>> introspectParameters(Method method) {
        ArrayList<AnnotatedParameter<T>> parameterList = new ArrayList<AnnotatedParameter<T>>();
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annTypes = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            AnnotatedParameterImpl param = new AnnotatedParameterImpl(this, paramTypes[i], annTypes[i], i);
            parameterList.add(param);
        }
        return parameterList;
    }

    public static boolean isMatch(Method methodA, Method methodB) {
        Class<?>[] paramB;
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        if (!methodA.getDeclaringClass().equals(methodB.getDeclaringClass())) {
            return false;
        }
        Class<?>[] paramA = methodA.getParameterTypes();
        if (paramA.length != (paramB = methodB.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramA.length; ++i) {
            if (paramA[i].equals(paramB[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._method.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnnotatedMethodImpl)) {
            return false;
        }
        AnnotatedMethodImpl method = (AnnotatedMethodImpl)obj;
        return AnnotatedMethodImpl.isMatch(this._method, method._method);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

