/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAnnotated
implements Annotated {
    private static final LinkedHashSet<Annotation> _emptyAnnSet = new LinkedHashSet();
    private static final Annotation[] _emptyAnnArray = new Annotation[0];
    private Type _type;
    private Set<Type> _typeSet;
    private LinkedHashSet<Annotation> _annSet;
    private Annotation[] _annArray;

    protected ReflectionAnnotated(Type type, Set<Type> typeClosure, Annotation[] annList) {
        this._type = type;
        this._typeSet = typeClosure;
        if (annList != null && annList.length > 0) {
            this._annSet = new LinkedHashSet();
            for (Annotation ann : annList) {
                this._annSet.add(ann);
            }
            this._annArray = new Annotation[this._annSet.size()];
            this._annSet.toArray(this._annArray);
        } else {
            this._annSet = _emptyAnnSet;
            this._annArray = _emptyAnnArray;
        }
    }

    public Type getBaseType() {
        return this._type;
    }

    public Set<Type> getTypeClosure() {
        return this._typeSet;
    }

    public Set<Annotation> getAnnotations() {
        return this._annSet;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annType) {
        for (Annotation ann : this._annArray) {
            if (!annType.equals(ann.annotationType())) continue;
            return (T)ann;
        }
        return null;
    }

    protected void addAnnotation(Annotation ann) {
        if (this._annSet == _emptyAnnSet) {
            this._annSet = new LinkedHashSet();
        }
        this._annSet.add(ann);
        this._annArray = new Annotation[this._annSet.size()];
        this._annSet.toArray(this._annArray);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annType) {
        for (Annotation ann : this._annArray) {
            if (!annType.equals(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }
}

