/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.config.reflect.ReflectionSimpleAnnotatedType;
import com.caucho.loader.EnvironmentLocal;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAnnotatedFactory {
    private static EnvironmentLocal<ReflectionAnnotatedFactory> _current = new EnvironmentLocal();
    private WeakHashMap<Class<?>, SoftReference<ReflectionSimpleAnnotatedType>> _simpleTypeMap = new WeakHashMap();
    private WeakHashMap<Class<?>, SoftReference<ReflectionAnnotatedType>> _typeMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectionAnnotatedFactory create(ClassLoader loader) {
        EnvironmentLocal<ReflectionAnnotatedFactory> environmentLocal = _current;
        synchronized (environmentLocal) {
            ReflectionAnnotatedFactory factory = _current.get(loader);
            if (factory == null) {
                factory = new ReflectionAnnotatedFactory();
                _current.set(factory, loader);
            }
            return factory;
        }
    }

    public static <T> ReflectionSimpleAnnotatedType<T> introspectSimpleType(Class<T> cl) {
        return ReflectionAnnotatedFactory.create(cl.getClassLoader()).introspectSimpleTypeImpl(cl);
    }

    private synchronized <T> ReflectionSimpleAnnotatedType<T> introspectSimpleTypeImpl(Class<T> cl) {
        SoftReference<ReflectionSimpleAnnotatedType> typeRef = this._simpleTypeMap.get(cl);
        ReflectionSimpleAnnotatedType type = null;
        if (typeRef != null) {
            type = typeRef.get();
        }
        if (type == null) {
            InjectManager inject = InjectManager.create();
            BaseType baseType = inject.createSourceBaseType(cl);
            type = new ReflectionSimpleAnnotatedType(inject, baseType);
            typeRef = new SoftReference(type);
            this._simpleTypeMap.put(cl, typeRef);
        }
        return type;
    }

    public static <X> ReflectionAnnotatedType<X> introspectType(Class<X> cl) {
        return ReflectionAnnotatedFactory.create(cl.getClassLoader()).introspectTypeImpl(cl);
    }

    private synchronized <X> ReflectionAnnotatedType<X> introspectTypeImpl(Class<X> cl) {
        SoftReference<ReflectionAnnotatedType> typeRef = this._typeMap.get(cl);
        ReflectionAnnotatedType type = null;
        if (typeRef != null) {
            type = typeRef.get();
        }
        if (type == null) {
            InjectManager inject = InjectManager.create();
            type = new ReflectionAnnotatedType(inject, inject.createSourceBaseType(cl));
            typeRef = new SoftReference<ReflectionAnnotatedType<ReflectionAnnotatedType>>(type);
            this._typeMap.put(cl, typeRef);
        }
        return type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

