/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedConstructorImpl;
import com.caucho.config.reflect.AnnotatedFieldImpl;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.ReflectionAnnotated;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionAnnotatedType<T>
extends ReflectionAnnotated
implements AnnotatedType<T> {
    private static final L10N L = new L10N(ReflectionAnnotatedType.class);
    private static final Logger log = Logger.getLogger(ReflectionAnnotatedType.class.getName());
    private Class<T> _javaClass;
    private ReflectionAnnotatedType<?> _parentType;
    private Set<AnnotatedConstructor<T>> _constructorSet = new LinkedHashSet<AnnotatedConstructor<T>>();
    private Set<AnnotatedField<? super T>> _fieldSet = new LinkedHashSet<AnnotatedField<? super T>>();
    private Set<AnnotatedMethod<? super T>> _methodSet = new LinkedHashSet<AnnotatedMethod<? super T>>();

    ReflectionAnnotatedType(InjectManager manager, BaseType type) {
        super(type.getRawClass(), type.getTypeClosure(manager), type.getRawClass().getDeclaredAnnotations());
        this._javaClass = type.getRawClass();
        Class<T> parentClass = this._javaClass.getSuperclass();
        if (parentClass != null && !parentClass.equals(Object.class)) {
            this._parentType = ReflectionAnnotatedFactory.introspectType(parentClass);
        }
        this.introspect(this._javaClass);
    }

    public Class<T> getJavaClass() {
        return this._javaClass;
    }

    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this._constructorSet;
    }

    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this._methodSet;
    }

    public AnnotatedMethod<? super T> createMethod(Method method) {
        for (AnnotatedMethod<? super T> annotatedMethod : this._methodSet) {
            if (!AnnotatedMethodImpl.isMatch(annotatedMethod.getJavaMember(), method)) continue;
            return annotatedMethod;
        }
        AnnotatedMethodImpl annMethod = new AnnotatedMethodImpl(this, null, method);
        this._methodSet.add(annMethod);
        return annMethod;
    }

    public Set<AnnotatedField<? super T>> getFields() {
        return this._fieldSet;
    }

    private void introspect(Class<T> cl) {
        try {
            this.introspectInheritedAnnotations(cl);
            if (cl.isAnnotationPresent(Specializes.class)) {
                this.introspectSpecializesAnnotations(cl);
            }
            this.introspectFields(cl);
            this.introspectMethods(cl);
            if (!cl.isInterface()) {
                for (Constructor<?> ctor : cl.getDeclaredConstructors()) {
                    this._constructorSet.add(new AnnotatedConstructorImpl(this, ctor));
                }
                if (this._constructorSet.size() == 0) {
                    try {
                        Constructor<T> ctor = cl.getConstructor(new Class[0]);
                        this._constructorSet.add(new AnnotatedConstructorImpl<T>(this, ctor));
                    }
                    catch (NoSuchMethodException e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                }
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(L.l("{0} introspection failed: {1}", (Object)cl.getName(), e), (Throwable)e);
        }
    }

    private void introspectFields(Class<?> cl) {
        if (cl == null) {
            return;
        }
        this.introspectFields(cl.getSuperclass());
        for (Field field : cl.getDeclaredFields()) {
            try {
                this._fieldSet.add(new AnnotatedFieldImpl(this, field));
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Throwable e) {
                throw ConfigException.create(L.l("{0}: {1}\n", (Object)field, e), e);
            }
        }
    }

    private void introspectMethods(Class<?> cl) {
        if (cl == null) {
            return;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || !this.hasBeanAnnotation(method) && Modifier.isPrivate(method.getModifiers())) continue;
            AnnotatedMethod childMethod = null;
            if (!Modifier.isPrivate(method.getModifiers())) {
                childMethod = AnnotatedTypeUtil.findMethod(this._methodSet, method);
            }
            if (childMethod == null) {
                this._methodSet.add(new AnnotatedMethodImpl(this, null, method));
                continue;
            }
            if (!(childMethod instanceof AnnotatedMethodImpl)) continue;
            AnnotatedMethodImpl childMethodImpl = (AnnotatedMethodImpl)childMethod;
            for (Annotation ann : method.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (childMethodImpl.isAnnotationPresent(ann.annotationType()) || !annType.isAnnotationPresent(Inherited.class)) continue;
                childMethodImpl.addAnnotation(ann);
            }
        }
        if (cl.isInterface()) {
            for (GenericDeclaration genericDeclaration : cl.getInterfaces()) {
                this.introspectMethods((Class<?>)genericDeclaration);
            }
        } else {
            this.introspectParentMethods(this._parentType);
        }
    }

    private void introspectParentMethods(AnnotatedType<?> parentType) {
        if (parentType == null) {
            return;
        }
        for (AnnotatedMethod annMethod : parentType.getMethods()) {
            Method javaMethod = annMethod.getJavaMember();
            if (!this.hasBeanAnnotation(javaMethod) && Modifier.isPrivate(javaMethod.getModifiers())) continue;
            AnnotatedMethod childMethod = null;
            if (!Modifier.isPrivate(javaMethod.getModifiers())) {
                childMethod = AnnotatedTypeUtil.findMethod(this._methodSet, javaMethod);
            }
            if (childMethod == null) {
                this._methodSet.add(annMethod);
                continue;
            }
            if (!(childMethod instanceof AnnotatedMethodImpl)) continue;
            AnnotatedMethodImpl childMethodImpl = (AnnotatedMethodImpl)childMethod;
            for (Annotation ann : annMethod.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (childMethodImpl.isAnnotationPresent(ann.annotationType()) || !annType.isAnnotationPresent(Inherited.class) || annType.equals(PostConstruct.class) || annType.equals(PreDestroy.class)) continue;
                childMethodImpl.addAnnotation(ann);
            }
        }
    }

    private void introspectInheritedAnnotations(Class<?> cl) {
        this.introspectInheritedAnnotations(cl, false, false);
    }

    private void introspectInheritedAnnotations(Class<?> cl, boolean isScope, boolean isQualifier) {
        if (cl == null) {
            return;
        }
        for (Annotation ann : cl.getDeclaredAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (ann.annotationType().isAnnotationPresent(Scope.class) || ann.annotationType().isAnnotationPresent(NormalScope.class)) {
                if (isScope) continue;
                isScope = true;
            }
            if (ann.annotationType().isAnnotationPresent(Qualifier.class)) {
                if (isQualifier) continue;
                isQualifier = true;
            }
            if (cl == this._javaClass || !annType.isAnnotationPresent(Inherited.class) || this.isAnnotationPresent(annType)) continue;
            this.addAnnotation(ann);
        }
        this.introspectInheritedAnnotations(cl.getSuperclass(), isScope, isQualifier);
    }

    private void introspectSpecializesAnnotations(Class<?> cl) {
        Class<?> parentClass = cl.getSuperclass();
        if (parentClass == null) {
            return;
        }
        if (cl.isAnnotationPresent(Named.class)) {
            throw new ConfigException(L.l("'{0}' is an invalid @Specializes bean because it has a @Named annotation.", cl.getName()));
        }
        if (this.isMetaAnnotationPresent(cl.getAnnotations(), Qualifier.class)) {
            // empty if block
        }
        for (Annotation ann : parentClass.getDeclaredAnnotations()) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (annType.isAnnotationPresent(Qualifier.class)) {
                this.addAnnotation(ann);
                continue;
            }
            if (!Named.class.equals(annType)) continue;
            this.addAnnotation(ann);
        }
    }

    private boolean hasBeanAnnotation(Method method) {
        if (this.hasBeanAnnotation(method.getAnnotations())) {
            return true;
        }
        Annotation[][] paramAnn = method.getParameterAnnotations();
        if (paramAnn != null) {
            for (int i = 0; i < paramAnn.length; ++i) {
                if (!this.hasBeanAnnotation(paramAnn[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasBeanAnnotation(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (Annotation ann : annotations) {
            if (this.isBeanAnnotation(ann.annotationType())) {
                return true;
            }
            for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                if (!this.isBeanAnnotation(metaAnn.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMetaAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> metaAnnType) {
        if (annotations == null) {
            return false;
        }
        for (Annotation ann : annotations) {
            if (!ann.annotationType().isAnnotationPresent(metaAnnType)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeanAnnotation(Class<?> annType) {
        String name = annType.getName();
        return name.startsWith("javax.");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._javaClass + "]";
    }
}

