/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.timer;

import com.caucho.config.ConfigException;
import com.caucho.config.timer.CronExpression;
import com.caucho.config.types.Trigger;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class CronTrigger
implements Trigger {
    private static final L10N L = new L10N(CronTrigger.class);
    private static final String[][] MONTH_TOKEN_MAP = new String[][]{{"january", "1"}, {"february", "2"}, {"march", "3"}, {"april", "4"}, {"may", "5"}, {"june", "6"}, {"july", "7"}, {"august", "8"}, {"september", "9"}, {"october", "10"}, {"november", "11"}, {"december", "12"}, {"jan", "1"}, {"feb", "2"}, {"mar", "3"}, {"apr", "4"}, {"jun", "6"}, {"jul", "7"}, {"aug", "8"}, {"sep", "9"}, {"oct", "10"}, {"nov", "11"}, {"dec", "12"}};
    private static final String[][] DAY_OF_WEEK_TOKEN_MAP = new String[][]{{"sunday", "0"}, {"monday", "1"}, {"tuesday", "2"}, {"wednesday", "3"}, {"thursday", "4"}, {"friday", "5"}, {"saturday", "6"}, {"sun", "0"}, {"mon", "1"}, {"tue", "2"}, {"wed", "3"}, {"thu", "4"}, {"fri", "5"}, {"sat", "6"}};
    private static final String[][] RELATIVE_DAY_OF_WEEK_TOKEN_MAP = new String[][]{{"last", "-0"}, {"1st", "1"}, {"2nd", "2"}, {"3rd", "3"}, {"4th", "4"}, {"5th", "5"}};
    private AtomicReference<QDate> _localCalendar = new AtomicReference();
    private boolean[] _seconds;
    private boolean[] _minutes;
    private boolean[] _hours;
    private boolean _isDaysFilterRelative;
    private boolean[] _days;
    private String _daysFilter;
    private boolean[] _months;
    private boolean[] _daysOfWeek;
    private YearsFilter _yearsFilter;
    private TimeZone _timezone = TimeZone.getTimeZone("GMT");
    private long _start = -1L;
    private long _end = -1L;

    public CronTrigger(CronExpression cronExpression, long start, long end, TimeZone timezone) {
        if (cronExpression.getSecond() != null) {
            this._seconds = this.parseRange(cronExpression.getSecond(), 0, 59, false);
        }
        if (cronExpression.getMinute() != null) {
            this._minutes = this.parseRange(cronExpression.getMinute(), 0, 59, false);
        }
        if (cronExpression.getHour() != null) {
            this._hours = this.parseRange(cronExpression.getHour(), 0, 23, false);
        }
        if (cronExpression.getDayOfWeek() != null) {
            this._daysOfWeek = this.parseRange(this.tokenizeDayOfWeek(cronExpression.getDayOfWeek()), 0, 7, false);
        }
        if (this._daysOfWeek[7]) {
            this._daysOfWeek[0] = this._daysOfWeek[7];
        }
        if (cronExpression.getDayOfMonth() != null) {
            this._daysFilter = this.tokenizeDayOfMonth(cronExpression.getDayOfMonth());
            this._days = this.parseRange(this._daysFilter, 1, 31, true);
        }
        if (cronExpression.getMonth() != null) {
            this._months = this.parseRange(this.tokenizeMonth(cronExpression.getMonth()), 1, 12, false);
        }
        if (cronExpression.getYear() != null) {
            this._yearsFilter = this.parseYear(cronExpression.getYear());
        }
        if (timezone != null) {
            this._timezone = timezone;
        }
        this._start = start;
        this._end = end;
    }

    private String tokenizeDayOfWeek(String dayOfWeek) {
        dayOfWeek = this.tokenize(dayOfWeek, DAY_OF_WEEK_TOKEN_MAP);
        return dayOfWeek;
    }

    private String tokenizeDayOfMonth(String dayOfMonth) {
        dayOfMonth = this.tokenize(dayOfMonth, RELATIVE_DAY_OF_WEEK_TOKEN_MAP);
        dayOfMonth = this.tokenize(dayOfMonth, DAY_OF_WEEK_TOKEN_MAP);
        return dayOfMonth;
    }

    private String tokenizeMonth(String month) {
        month = this.tokenize(month, MONTH_TOKEN_MAP);
        return month;
    }

    private String tokenize(String value, String[][] tokenMap) {
        for (int i = 0; i < tokenMap.length; ++i) {
            value = value.replaceAll("(?i)" + tokenMap[i][0], tokenMap[i][1]);
        }
        return value;
    }

    private boolean[] parseRange(String range, int rangeMin, int rangeMax, boolean parseDayOfMonth) throws ConfigException {
        boolean[] values = new boolean[rangeMax + 1];
        int i = 0;
        while (i < range.length()) {
            char character = range.charAt(i);
            int min = 0;
            int max = 0;
            int increment = 1;
            if (character == '*') {
                min = rangeMin;
                max = rangeMax;
                ++i;
            } else if ('0' <= character && character <= '9') {
                while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                    min = 10 * min + character - 48;
                    ++i;
                }
                if (i < range.length() && character == '-') {
                    ++i;
                    while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                        max = 10 * max + character - 48;
                        ++i;
                    }
                } else {
                    if (parseDayOfMonth && i < range.length() && character == ' ') {
                        this._isDaysFilterRelative = true;
                        int dayOfWeek = 0;
                        ++i;
                        while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                            dayOfWeek = 10 * dayOfWeek + character - 48;
                            ++i;
                        }
                        if (dayOfWeek < 0 || dayOfWeek > 6) {
                            throw new ConfigException(L.l("'{0}' is an illegal cron range (day of week out of range)", range));
                        }
                        if (min < 1 || min > 5) {
                            throw new ConfigException(L.l("'{0}' is an illegal cron range (invalid day of week)", range));
                        }
                        if (i >= range.length()) continue;
                        if (i < range.length() - 1 && character == ',') {
                            ++i;
                            continue;
                        }
                        throw new ConfigException(L.l("'{0}' is an illegal cron range (invalid syntax)", range));
                    }
                    max = min;
                }
            } else {
                if (parseDayOfMonth && character == '-') {
                    this._isDaysFilterRelative = true;
                    int dayOfMonth = 0;
                    ++i;
                    while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                        dayOfMonth = 10 * dayOfMonth + character - 48;
                        ++i;
                    }
                    if (dayOfMonth < 0 || dayOfMonth > 30) {
                        throw new ConfigException(L.l("'{0}' is an illegal cron range (day of month out of range)", range));
                    }
                    if (i < range.length() && (character = range.charAt(i)) == '/') {
                        increment = 0;
                        ++i;
                        while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                            increment = 10 * increment + character - 48;
                            ++i;
                        }
                        if (increment < rangeMin && increment > rangeMax) {
                            throw new ConfigException(L.l("'{0}' is an illegal cron range (increment value out of range)", range));
                        }
                    }
                    if (i < range.length() && (character = range.charAt(i)) == ' ') {
                        int dayOfWeek = 0;
                        ++i;
                        while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                            dayOfWeek = 10 * dayOfWeek + character - 48;
                            ++i;
                        }
                        if (dayOfWeek < 0 || dayOfWeek > 6) {
                            throw new ConfigException(L.l("'{0}' is an illegal cron range (day of week out of range)", range));
                        }
                        if (min != 0) {
                            throw new ConfigException(L.l("'{0}' is an illegal cron range (invalid syntax)", range));
                        }
                    }
                    if (i >= range.length()) continue;
                    if (i < range.length() - 1 && character == ',') {
                        ++i;
                        continue;
                    }
                    throw new ConfigException(L.l("'{0}' is an illegal cron range (invalid syntax)", range));
                }
                throw new ConfigException(L.l("'{0}' is an illegal cron range (invalid syntax)", range));
            }
            if (min < rangeMin) {
                throw new ConfigException(L.l("'{0}' is an illegal cron range (min value is too small)", range));
            }
            if (max > rangeMax) {
                throw new ConfigException(L.l("'{0}' is an illegal cron range (max value is too large)", range));
            }
            if (i < range.length() && (character = range.charAt(i)) == '/') {
                increment = 0;
                ++i;
                while (i < range.length() && '0' <= (character = range.charAt(i)) && character <= '9') {
                    increment = 10 * increment + character - 48;
                    ++i;
                }
                if (min == max) {
                    max = rangeMax;
                }
                if (increment < rangeMin && increment > rangeMax) {
                    throw new ConfigException(L.l("'{0}' is an illegal cron range (increment value out of range)", range));
                }
            }
            if (i < range.length()) {
                if (i < range.length() - 1 && character == ',') {
                    ++i;
                } else {
                    throw new ConfigException(L.l("'{0}' is an illegal cron range (invalid syntax)", range));
                }
            }
            while (min <= max) {
                values[min] = true;
                min += increment;
            }
        }
        return values;
    }

    private YearsFilter parseYear(String year) {
        YearsFilter yearsFilter = new YearsFilter();
        int i = 0;
        while (i < year.length()) {
            YearsFilterValue filterValue = new YearsFilterValue();
            char character = year.charAt(i);
            if (character == '*') {
                filterValue.setAnyYear(true);
                ++i;
            } else if ('0' <= character && character <= '9') {
                int startYear = 0;
                while (i < year.length() && '0' <= (character = year.charAt(i)) && character <= '9') {
                    startYear = 10 * startYear + character - 48;
                    ++i;
                }
                filterValue.setStartYear(startYear);
                if (i < year.length() && character == '-') {
                    int endYear = 0;
                    ++i;
                    while (i < year.length() && '0' <= (character = year.charAt(i)) && character <= '9') {
                        endYear = 10 * endYear + character - 48;
                        ++i;
                    }
                    filterValue.setEndYear(endYear);
                } else {
                    filterValue.setEndYear(startYear);
                }
            } else {
                throw new ConfigException(L.l("'{0}' is an illegal cron range", year));
            }
            if (i < year.length() && (character = year.charAt(i)) == '/') {
                filterValue.setAnyYear(false);
                int increment = 0;
                ++i;
                while (i < year.length() && '0' <= (character = year.charAt(i)) && character <= '9') {
                    increment = 10 * increment + character - 48;
                    ++i;
                }
                if (increment == 0) {
                    throw new ConfigException(L.l("'{0}' is an illegal cron range", year));
                }
                filterValue.setIncrement(increment);
                if (filterValue.getStartYear() == filterValue.getEndYear()) {
                    filterValue.setEndYear(Integer.MAX_VALUE);
                }
            }
            yearsFilter.addFilterValue(filterValue);
            if (i >= year.length()) continue;
            if (i < year.length() - 1 && character == ',') {
                ++i;
                continue;
            }
            throw new ConfigException(L.l("'{0}' is an illegal cron range", year));
        }
        return yearsFilter;
    }

    public long nextTime(long now) {
        if (this._start != -1L && now < this._start) {
            now = this._start;
        }
        QDate calendar = this.allocateCalendar();
        long time = now + 1000L - now % 1000L;
        calendar.setGMTTime(time);
        QDate nextTime = this.getNextTime(calendar);
        if (nextTime != null) {
            time = nextTime.getGMTTime();
            time -= (long)this._timezone.getRawOffset();
        } else {
            time = Long.MAX_VALUE;
        }
        if (this._end != -1L && time > this._end) {
            time = Long.MAX_VALUE;
        }
        this.freeCalendar(calendar);
        if (now < time) {
            return time;
        }
        return this.nextTime(now + 3600000L);
    }

    private QDate getNextTime(QDate currentTime) {
        int year = this._yearsFilter.getNextMatch(currentTime.getYear());
        if (year == -1) {
            return null;
        }
        if (year > currentTime.getYear()) {
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(0);
            currentTime.setDayOfMonth(1);
            currentTime.setMonth(0);
            currentTime.setYear(year);
        }
        QDate nextTime = this.getNextTimeInYear(currentTime);
        int count = 0;
        while (count < 5 && nextTime == null) {
            ++count;
            ++year;
            if ((year = this._yearsFilter.getNextMatch(year)) == -1) {
                return null;
            }
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(0);
            currentTime.setDayOfMonth(1);
            currentTime.setMonth(0);
            currentTime.setYear(year);
            nextTime = this.getNextTimeInYear(currentTime);
        }
        return nextTime;
    }

    private QDate getNextTimeInYear(QDate currentTime) {
        int month = this.getNextMatch(this._months, currentTime.getMonth() + 1);
        if (month == -1) {
            return null;
        }
        if (month > currentTime.getMonth() + 1) {
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(0);
            currentTime.setDayOfMonth(1);
            currentTime.setMonth(month - 1);
        }
        QDate nextTime = this.getNextTimeInMonth(currentTime);
        while (month < this._months.length && nextTime == null) {
            ++month;
            if ((month = this.getNextMatch(this._months, month)) == -1) {
                return null;
            }
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(0);
            currentTime.setDayOfMonth(1);
            currentTime.setMonth(month - 1);
            nextTime = this.getNextTimeInMonth(currentTime);
        }
        return nextTime;
    }

    private QDate getNextTimeInMonth(QDate currentTime) {
        QDate nextTime;
        int day;
        if (this._isDaysFilterRelative) {
            this.calculateDays(currentTime);
        }
        if ((day = this.getNextDayMatch(currentTime.getDayOfMonth(), currentTime.getDayOfWeek() - 1, currentTime.getDayOfMonth(), currentTime.getDaysInMonth())) == -1) {
            return null;
        }
        if (day > currentTime.getDayOfMonth()) {
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(0);
            currentTime.setDayOfMonth(day);
        }
        if ((nextTime = this.getNextTimeInDay(currentTime)) == null) {
            ++day;
            day = this.getNextDayMatch(currentTime.getDayOfMonth(), currentTime.getDayOfWeek() - 1, day, currentTime.getDaysInMonth());
            if (day == -1) {
                return null;
            }
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(0);
            currentTime.setDayOfMonth(day);
            return this.getNextTimeInDay(currentTime);
        }
        return nextTime;
    }

    private void calculateDays(QDate currentTime) {
        this._days = new boolean[currentTime.getDaysInMonth() + 1];
        int i = 0;
        while (i < this._daysFilter.length()) {
            int dayOfWeek;
            int min;
            char character = this._daysFilter.charAt(i);
            int max = min = 0;
            int increment = 1;
            if (character == '*') {
                min = 1;
                max = currentTime.getDaysInMonth();
                ++i;
            } else if ('0' <= character && character <= '9') {
                while (i < this._daysFilter.length() && '0' <= (character = this._daysFilter.charAt(i)) && character <= '9') {
                    min = 10 * min + character - 48;
                    ++i;
                }
                if (i < this._daysFilter.length() && character == '-') {
                    ++i;
                    while (i < this._daysFilter.length() && '0' <= (character = this._daysFilter.charAt(i)) && character <= '9') {
                        max = 10 * max + character - 48;
                        ++i;
                    }
                } else if (i < this._daysFilter.length() && character == ' ') {
                    dayOfWeek = 0;
                    ++i;
                    while (i < this._daysFilter.length() && '0' <= (character = this._daysFilter.charAt(i)) && character <= '9') {
                        dayOfWeek = 10 * dayOfWeek + character - 48;
                        ++i;
                    }
                    int n = min;
                    min = 1;
                    int monthStartDayofWeek = (currentTime.getDayOfWeek() - 1 - (currentTime.getDayOfMonth() - min) % 7 + 7) % 7;
                    min += (dayOfWeek - monthStartDayofWeek + 7) % 7;
                    max = min += (n - 1) * 7;
                } else {
                    max = min;
                }
            } else if (character == '-') {
                ++i;
                while (i < this._daysFilter.length() && '0' <= (character = this._daysFilter.charAt(i)) && character <= '9') {
                    min = 10 * min + character - 48;
                    ++i;
                }
                min = currentTime.getDaysInMonth() - min;
                if (i < this._daysFilter.length() && (character = this._daysFilter.charAt(i)) == ' ') {
                    dayOfWeek = 0;
                    ++i;
                    while (i < this._daysFilter.length() && '0' <= (character = this._daysFilter.charAt(i)) && character <= '9') {
                        dayOfWeek = 10 * dayOfWeek + character - 48;
                        ++i;
                    }
                    min = 1;
                    int monthStartDayofWeek = (currentTime.getDayOfWeek() - 1 - (currentTime.getDayOfMonth() - min) % 7 + 7) % 7;
                    min += (dayOfWeek - monthStartDayofWeek + 7) % 7;
                    min += (currentTime.getDaysInMonth() - min) / 7 * 7;
                }
                max = min;
            }
            if (i < this._daysFilter.length() && (character = this._daysFilter.charAt(i)) == '/') {
                ++i;
                while (i < this._daysFilter.length() && '0' <= (character = this._daysFilter.charAt(i)) && character <= '9') {
                    increment = 10 * increment + character - 48;
                    ++i;
                }
                if (min == max) {
                    max = currentTime.getDaysInMonth();
                }
            }
            for (int day = min; day > 0 && day <= max && day <= currentTime.getDaysInMonth(); day += increment) {
                this._days[day] = true;
            }
            if (character != ',') continue;
            ++i;
        }
    }

    private int getNextDayMatch(int initialDayOfMonth, int initialDayOfWeek, int day, int daysInMonth) {
        while (day <= daysInMonth) {
            if ((day = this.getNextMatch(this._days, day, daysInMonth + 1)) == -1) {
                return -1;
            }
            int dayOfWeek = (initialDayOfWeek + (day - initialDayOfMonth) % 7) % 7;
            int nextDayOfWeek = this.getNextMatch(this._daysOfWeek, dayOfWeek);
            if (nextDayOfWeek == dayOfWeek) {
                return day;
            }
            if (nextDayOfWeek == -1) {
                day += 7 - dayOfWeek;
                continue;
            }
            day += nextDayOfWeek - dayOfWeek;
        }
        return -1;
    }

    private QDate getNextTimeInDay(QDate currentTime) {
        QDate nextTime;
        int hour = this.getNextMatch(this._hours, currentTime.getHour());
        if (hour == -1) {
            return null;
        }
        if (hour > currentTime.getHour()) {
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(hour);
        }
        if ((nextTime = this.getNextTimeInHour(currentTime)) == null) {
            ++hour;
            if ((hour = this.getNextMatch(this._hours, hour)) == -1) {
                return null;
            }
            currentTime.setSecond(0);
            currentTime.setMinute(0);
            currentTime.setHour(hour);
            return this.getNextTimeInHour(currentTime);
        }
        return nextTime;
    }

    private QDate getNextTimeInHour(QDate currentTime) {
        QDate nextTime;
        int minute = this.getNextMatch(this._minutes, currentTime.getMinute());
        if (minute == -1) {
            return null;
        }
        if (minute > currentTime.getMinute()) {
            currentTime.setSecond(0);
            currentTime.setMinute(minute);
        }
        if ((nextTime = this.getNextTimeInMinute(currentTime)) == null) {
            ++minute;
            if ((minute = this.getNextMatch(this._minutes, minute)) == -1) {
                return null;
            }
            currentTime.setSecond(0);
            currentTime.setMinute(minute);
            return this.getNextTimeInMinute(currentTime);
        }
        return nextTime;
    }

    private QDate getNextTimeInMinute(QDate currentTime) {
        int second = this.getNextMatch(this._seconds, currentTime.getSecond());
        if (second == -1) {
            return null;
        }
        currentTime.setSecond(second);
        return currentTime;
    }

    private int getNextMatch(boolean[] range, int start) {
        return this.getNextMatch(range, start, range.length);
    }

    private int getNextMatch(boolean[] range, int start, int end) {
        for (int match = start; match < end; ++match) {
            if (!range[match]) continue;
            return match;
        }
        return -1;
    }

    private QDate allocateCalendar() {
        QDate calendar = this._localCalendar.getAndSet(null);
        if (calendar == null) {
            calendar = QDate.createLocal();
        }
        return calendar;
    }

    private void freeCalendar(QDate cal) {
        this._localCalendar.set(cal);
    }

    private class YearsFilterValue {
        private boolean _anyYear = false;
        private int _startYear = 0;
        private int _endYear = 0;
        private int _increment = 1;

        private YearsFilterValue() {
        }

        public boolean isAnyYear() {
            return this._anyYear;
        }

        public void setAnyYear(boolean anyYear) {
            this._anyYear = anyYear;
        }

        public int getStartYear() {
            return this._startYear;
        }

        public void setStartYear(int startYear) {
            this._startYear = startYear;
        }

        public int getEndYear() {
            return this._endYear;
        }

        public void setEndYear(int endYear) {
            this._endYear = endYear;
        }

        public void setIncrement(int increment) {
            this._increment = increment;
        }

        public int getIncrement() {
            return this._increment;
        }
    }

    private class YearsFilter {
        private List<YearsFilterValue> _filterValues = new LinkedList<YearsFilterValue>();
        private boolean _anyYear = false;
        private int _endYear = 0;

        private YearsFilter() {
        }

        private void addFilterValue(YearsFilterValue filterValue) {
            if (filterValue.isAnyYear()) {
                this._anyYear = true;
            } else if (filterValue.getEndYear() > this._endYear) {
                this._endYear = filterValue.getEndYear();
            }
            this._filterValues.add(filterValue);
        }

        private int getNextMatch(int year) {
            if (this._anyYear) {
                return year;
            }
            while (year <= this._endYear) {
                for (YearsFilterValue filterValue : this._filterValues) {
                    if (year < filterValue.getStartYear() || year > filterValue.getEndYear() || year % filterValue.getIncrement() != 0) continue;
                    return year;
                }
                ++year;
            }
            return -1;
        }
    }
}

