/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.timer;

import com.caucho.config.timer.CronExpression;
import com.caucho.config.timer.EjbTimerHandle;
import com.caucho.config.timer.ScheduledTaskStatus;
import com.caucho.config.timer.TimerTask;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public class EjbTimer
implements Timer,
Runnable {
    private static final L10N L = new L10N(EjbTimer.class);
    private static final Logger log = Logger.getLogger(EjbTimer.class.getName());
    private TimerTask _timerTask;

    public EjbTimer() {
    }

    public EjbTimer(TimerTask task) {
        this._timerTask = task;
    }

    public void setScheduledTask(TimerTask scheduledTask) {
        this._timerTask = scheduledTask;
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        if (this._timerTask.getCronExpression() != null) {
            CronExpression cronExpression = this._timerTask.getCronExpression();
            Date start = null;
            Date end = null;
            return new ScheduleExpression().second(cronExpression.getSecond()).minute(cronExpression.getMinute()).hour(cronExpression.getHour()).dayOfWeek(cronExpression.getDayOfWeek()).dayOfMonth(cronExpression.getDayOfMonth()).month(cronExpression.getMonth()).year(cronExpression.getYear()).start(start).end(end);
        }
        throw new IllegalStateException("This timer was not created by a schedule expression.");
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        return this._timerTask.getData();
    }

    public boolean isPersistent() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        return false;
    }

    public boolean isCalendarTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        return this._timerTask.getCronExpression() != null;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        return new Date(this._timerTask.getNextAlarmTime());
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        long now = Alarm.getExactTime();
        long nextTime = this._timerTask.getNextAlarmTime();
        return nextTime - now;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        return new EjbTimerHandle(this._timerTask.getTaskId());
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkStatus();
        this._timerTask.cancel();
    }

    public void run() {
        if (this._timerTask.getStatus() == ScheduledTaskStatus.ACTIVE) {
            this._timerTask.invoke(this);
        }
    }

    void checkStatus() throws NoSuchObjectLocalException {
        if (this._timerTask.getStatus() == ScheduledTaskStatus.CANCELLED) {
            throw new NoSuchObjectLocalException("This timer has been cancelled.");
        }
        if (this._timerTask.getStatus() == ScheduledTaskStatus.EXPIRED) {
            throw new NoSuchObjectLocalException("This timer has already expired.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._timerTask + "]";
    }
}

