/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.timer;

import com.caucho.config.timer.CronExpression;
import com.caucho.config.timer.ScheduledTaskStatus;
import com.caucho.config.timer.Scheduler;
import com.caucho.config.timer.TimeoutInvoker;
import com.caucho.config.types.Trigger;
import com.caucho.env.thread.ThreadPool;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.ejb.Timer;

public class TimerTask
implements AlarmListener {
    private static AtomicLong _currentTaskId = new AtomicLong();
    private ClassLoader _loader = Thread.currentThread().getContextClassLoader();
    private long _taskId;
    private TimeoutInvoker _invoker;
    private Runnable _task;
    private CronExpression _cronExpression;
    private Trigger _trigger;
    private Alarm _alarm;
    private Serializable _data;
    private AtomicBoolean _cancelled = new AtomicBoolean();

    public TimerTask(TimeoutInvoker invoker, Runnable task, CronExpression cronExpression, Trigger trigger, Serializable data) {
        this._taskId = _currentTaskId.incrementAndGet();
        this._invoker = invoker;
        this._task = task;
        this._cronExpression = cronExpression;
        this._trigger = trigger;
        this._data = data;
        if (invoker == null) {
            throw new NullPointerException();
        }
    }

    public void start() {
        long now = Alarm.getCurrentTime();
        long nextTime = this._trigger.nextTime(now);
        this._alarm = new Alarm(this);
        this._alarm.queueAt(nextTime);
    }

    public long getTaskId() {
        return this._taskId;
    }

    public CronExpression getCronExpression() {
        return this._cronExpression;
    }

    public Serializable getData() {
        return this._data;
    }

    public long getNextAlarmTime() {
        return this._trigger.nextTime(Alarm.getExactTime() + 500L);
    }

    public void cancel() {
        Scheduler.removeTimerTask(this);
        this._cancelled.set(true);
        this._alarm.dequeue();
    }

    public ScheduledTaskStatus getStatus() {
        long nextTime;
        if (this._cancelled.get()) {
            return ScheduledTaskStatus.CANCELLED;
        }
        long now = Alarm.getExactTime();
        if (now > (nextTime = this._trigger.nextTime(now + 500L))) {
            return ScheduledTaskStatus.EXPIRED;
        }
        return ScheduledTaskStatus.ACTIVE;
    }

    public void invoke(Timer timer) {
        this._invoker.timeout(timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            ThreadPool.getCurrent().schedule(this._task);
            long now = Alarm.getExactTime();
            long nextTime = this._trigger.nextTime(now + 500L);
            if (nextTime > 0L) {
                alarm.queue(nextTime - now);
            }
            Object var9_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this._taskId ^ this._taskId >>> 32);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TimerTask other = (TimerTask)object;
        return this._taskId == other.getTaskId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._invoker + "]";
    }
}

