/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.type.InlineBeanType;
import com.caucho.config.xml.XmlBeanAttribute;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class EnvironmentBeanType
extends InlineBeanType {
    private static final L10N L = new L10N(EnvironmentBeanType.class);
    private static final Logger log = Logger.getLogger(EnvironmentBeanType.class.getName());

    public EnvironmentBeanType(Class beanClass) {
        super(beanClass);
        this.setAddCustomBean(XmlBeanAttribute.ATTRIBUTE);
    }

    public void beforeConfigure(XmlConfigContext env, Object bean, Node node) {
        super.beforeConfigure(env, bean, node);
        EnvironmentBean envBean = (EnvironmentBean)bean;
        ClassLoader loader = envBean.getClassLoader();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(loader);
        ArrayList<Dependency> dependencyList = env.getDependencyList();
        if (dependencyList != null) {
            for (Dependency depend : dependencyList) {
                Environment.addDependency(depend);
            }
        }
    }
}

