/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Modifier;
import java.util.TreeSet;
import java.util.logging.Logger;

public class SetType
extends ConfigType {
    private static final L10N L = new L10N(SetType.class);
    private static final Logger log = Logger.getLogger(SetType.class.getName());
    private final Class _setClass;
    private final Class _instanceClass;

    public SetType() {
        this(TreeSet.class);
    }

    public SetType(Class setClass) {
        this._setClass = setClass;
        this._instanceClass = !this._setClass.isInterface() && Modifier.isAbstract(this._setClass.getModifiers()) ? this._setClass : TreeSet.class;
    }

    public Class getType() {
        return this._setClass;
    }

    public Object create(Object parent) {
        try {
            return this._instanceClass.newInstance();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Attribute getAttribute(QName name) {
        return TypeFactory.getFactory().getSetAttribute(name);
    }

    public Object valueOf(String text) {
        throw new ConfigException(L.l("Can't convert to '{0}' from '{1}'.", (Object)this._setClass.getName(), text));
    }
}

