/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.PathPatternType;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetType {
    static final L10N L = new L10N(PathPatternType.class);
    static final Logger log = Logger.getLogger(PathPatternType.class.getName());
    private Path _dir;
    private String _userPathPrefix = "";
    private ArrayList<PathPatternType> _includeList;
    private ArrayList<PathPatternType> _excludeList = new ArrayList();

    public void setDir(Path dir) {
        this._dir = dir;
    }

    public Path getDir() {
        return this._dir;
    }

    public void addInclude(PathPatternType pattern) {
        if (this._includeList == null) {
            this._includeList = new ArrayList();
        }
        this._includeList.add(pattern);
    }

    public void addExclude(PathPatternType pattern) {
        this._excludeList.add(pattern);
    }

    public void setUserPathPrefix(String prefix) {
        this._userPathPrefix = prefix != null && !prefix.equals("") && !prefix.endsWith("/") ? prefix + "/" : prefix;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._dir == null) {
            this._dir = Vfs.lookup();
        }
    }

    public ArrayList<Path> getPaths() {
        return this.getPaths(new ArrayList<Path>());
    }

    public ArrayList<Path> getPaths(ArrayList<Path> paths) {
        String dirPath = this._dir.getPath();
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        this.getPaths(paths, this._dir, dirPath);
        return paths;
    }

    public void getPaths(ArrayList<Path> paths, Path path, String prefix) {
        if (path.isDirectory()) {
            try {
                String[] list = path.list();
                for (int i = 0; i < list.length; ++i) {
                    this.getPaths(paths, path.lookup(list[i]), prefix);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        } else if (path.exists() && this.isMatch(path, prefix)) {
            String suffix = "";
            String fullPath = path.getPath();
            if (prefix.length() < fullPath.length()) {
                suffix = path.getPath().substring(prefix.length());
            }
            path.setUserPath(this._userPathPrefix + suffix);
            paths.add(path);
        }
    }

    public boolean isMatch(Path path, String prefix) {
        PathPatternType pattern;
        int i;
        String suffix = "";
        String fullPath = path.getPath();
        if (prefix.length() < fullPath.length()) {
            suffix = path.getPath().substring(prefix.length());
        }
        for (i = 0; i < this._excludeList.size(); ++i) {
            pattern = this._excludeList.get(i);
            if (!pattern.isMatch(suffix)) continue;
            return false;
        }
        if (this._includeList == null) {
            return true;
        }
        for (i = 0; i < this._includeList.size(); ++i) {
            pattern = this._includeList.get(i);
            if (!pattern.isMatch(suffix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "FileSetType[]";
    }
}

