/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Signature;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SignaturePattern {
    private static L10N L = new L10N(SignaturePattern.class);
    private String _methodName;
    private ArrayList<String> _paramTypes;

    public void addText(String methodName) throws ConfigException {
        if (methodName.indexOf(40) < 0) {
            this._methodName = methodName;
            return;
        }
        Signature sig = new Signature();
        sig.addText(methodName);
        sig.init();
        this._methodName = sig.getName();
        String[] params = sig.getParameterTypes();
        if (params != null) {
            this._paramTypes = new ArrayList();
            for (int i = 0; i < params.length; ++i) {
                this._paramTypes.add(params[i]);
            }
        }
    }

    public void addParam(String typeName) {
        if (this._paramTypes == null) {
            this._paramTypes = new ArrayList();
        }
        this._paramTypes.add(typeName);
    }

    public void setHasParams() {
        if (this._paramTypes == null) {
            this._paramTypes = new ArrayList();
        }
    }

    public boolean isMatch(Method method) {
        return this.isMatch(method.getName(), method.getParameterTypes());
    }

    public boolean isMatch(String methodName, Class[] params) {
        if (this._methodName == null) {
            return false;
        }
        if (this._methodName.equals("*")) {
            return true;
        }
        if (!this._methodName.equals(methodName)) {
            return false;
        }
        if (this._paramTypes == null) {
            return true;
        }
        if (params.length != this._paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            String param;
            String name = params[i].getName();
            if (name.equals(param = this._paramTypes.get(i)) || name.endsWith("." + param)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._methodName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SignaturePattern)) {
            return false;
        }
        SignaturePattern cfg = (SignaturePattern)o;
        if (!this._methodName.equals(cfg._methodName)) {
            return false;
        }
        if (this._paramTypes == null || cfg._paramTypes == null) {
            return this._paramTypes == cfg._paramTypes;
        }
        if (this._paramTypes.size() != cfg._paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < this._paramTypes.size(); ++i) {
            if (this._paramTypes.get(i).equals(cfg._paramTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append("SignaturePattern[");
        cb.append(this._methodName);
        cb.append("(");
        for (int i = 0; this._paramTypes != null && i < this._paramTypes.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._paramTypes.get(i));
        }
        cb.append(")]");
        return cb.toString();
    }
}

