/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.NodeBuilderChildProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.StringType;
import com.caucho.config.type.TypeFactory;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.inject.Module;
import com.caucho.util.CompileException;
import com.caucho.util.DisplayableException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttributedNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class XmlConfigContext {
    private static final L10N L = new L10N(XmlConfigContext.class);
    private static final Logger log = Logger.getLogger(XmlConfigContext.class.getName());
    private static final QName TEXT = new QName("#text");
    private static final Object NULL = new Object();
    private static ThreadLocal<XmlConfigContext> _currentBuilder = new ThreadLocal();
    private Config _config;
    private InjectionPoint _ij;
    private CreationalContextImpl<?> _beanStack;
    private ArrayList<Dependency> _dependList;
    private Document _dependDocument;
    private String _baseUri;

    public XmlConfigContext() {
    }

    public XmlConfigContext(XmlConfigContext parent) {
        this();
    }

    public XmlConfigContext(Config config) {
        this();
        this._config = config;
    }

    public static XmlConfigContext create() {
        XmlConfigContext env = _currentBuilder.get();
        if (env != null) {
            return env;
        }
        return new XmlConfigContext();
    }

    public static XmlConfigContext createForProgram() {
        return new XmlConfigContext();
    }

    public static XmlConfigContext getCurrentBuilder() {
        return _currentBuilder.get();
    }

    public static XmlConfigContext getCurrent() {
        return _currentBuilder.get();
    }

    static void setCurrentBuilder(XmlConfigContext builder) {
        _currentBuilder.set(builder);
    }

    public InjectionPoint getInjectionPoint() {
        return this._ij;
    }

    public void setInjectionPoint(InjectionPoint ij) {
        this._ij = ij;
    }

    public String getBaseUri() {
        return Vfs.decode(this._baseUri);
    }

    public Object get(Bean<?> bean) {
        return CreationalContextImpl.find(this._beanStack, bean);
    }

    public Object findByName(String name) {
        return CreationalContextImpl.findByName(this._beanStack, name);
    }

    public CreationalContext<?> setCreationalContext(CreationalContext<?> cxt) {
        CreationalContextImpl<?> oldCxt = this._beanStack;
        this._beanStack = (CreationalContextImpl)cxt;
        return oldCxt;
    }

    public CreationalContext<?> getCreationalContext() {
        return this._beanStack;
    }

    public Config getConfig() {
        return this._config;
    }

    private boolean isEL() {
        return this._config == null || this._config.isEL();
    }

    public boolean isIgnoreEnvironment() {
        return this._config != null && this._config.isIgnoreEnvironment();
    }

    public Object configure(Object bean, Node top) throws LineConfigException {
        if (bean == null) {
            throw new NullPointerException(L.l("unexpected null bean at node '{0}'", top));
        }
        XmlConfigContext oldBuilder = _currentBuilder.get();
        try {
            _currentBuilder.set(this);
            ConfigType<?> type = TypeFactory.getType(bean);
            this.configureBean(bean, top);
            type.init(bean);
            Object object = type.replaceObject(bean);
            return object;
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw XmlConfigContext.error(e, top);
        }
        finally {
            _currentBuilder.set(oldBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureBean(Object bean, Node top) throws LineConfigException {
        XmlConfigContext oldBuilder = _currentBuilder.get();
        String oldFile = this._baseUri;
        ArrayList<Dependency> oldDependList = this._dependList;
        try {
            _currentBuilder.set(this);
            if (top instanceof QNode) {
                QNode qNode = (QNode)top;
                this._baseUri = qNode.getBaseURI();
            }
            this._dependList = this.getDependencyList(top);
            ConfigType<?> type = TypeFactory.getType(bean);
            this.configureNode(top, bean, type);
        }
        finally {
            _currentBuilder.set(oldBuilder);
            this._dependList = oldDependList;
            this._baseUri = oldFile;
        }
    }

    public void configureAttribute(Object bean, Node attribute) throws LineConfigException {
        String attrName = attribute.getNodeName();
        if (attrName.startsWith("xmlns")) {
            return;
        }
        String oldFile = this._baseUri;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        XmlConfigContext oldBuilder = XmlConfigContext.getCurrentBuilder();
        try {
            XmlConfigContext.setCurrentBuilder(this);
            this._baseUri = attribute.getBaseURI();
            ConfigType<?> type = TypeFactory.getType(bean);
            QName qName = ((QAbstractNode)attribute).getQName();
            type.beforeConfigure(this, bean, attribute);
            this.configureChildNode(attribute, qName, bean, type, false);
            type.afterConfigure(this, bean);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw XmlConfigContext.error(e, attribute);
        }
        finally {
            this._baseUri = oldFile;
            XmlConfigContext.setCurrentBuilder(oldBuilder);
            thread.setContextClassLoader(oldLoader);
        }
    }

    public Object configureNode(Node node, Object bean, ConfigType<?> type) throws LineConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            type.beforeConfigure(this, bean, node);
            type.beforeConfigureBean(this, bean, node);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("config begin " + type);
            }
            this.configureNodeAttributes(node, bean, type);
            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                QName qName = ((QAbstractNode)childNode).getQName();
                this.configureChildNode(childNode, qName, bean, type, false);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("config end " + type);
            }
            type.afterConfigure(this, bean);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw XmlConfigContext.error(e, node);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return bean;
    }

    private void configureNodeAttributes(Node node, Object bean, ConfigType<?> type) {
        block3: {
            block2: {
                if (!(node instanceof QAttributedNode)) break block2;
                for (Node child = ((QAttributedNode)node).getFirstAttribute(); child != null; child = child.getNextSibling()) {
                    Attr attr = child;
                    QName qName = ((QNode)((Object)attr)).getQName();
                    this.configureChildNode(attr, qName, bean, type, false);
                }
                break block3;
            }
            NamedNodeMap attrList = node.getAttributes();
            if (attrList == null) break block3;
            int length = attrList.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)attrList.item(i);
                QName qName = ((QNode)((Object)attr)).getQName();
                this.configureChildNode(attr, qName, bean, type, false);
            }
        }
    }

    private void configureChildNode(Node childNode, QName qName, Object bean, ConfigType<?> type, boolean allowParam) {
        if (qName.getName().startsWith("xmlns")) {
            return;
        }
        try {
            Attribute attrStrategy = this.getAttribute(type, qName, childNode);
            if (attrStrategy != null) {
                if (attrStrategy.isProgram()) {
                    attrStrategy.setValue(bean, qName, this.buildProgram(attrStrategy, childNode));
                } else if (attrStrategy.isNode()) {
                    attrStrategy.setValue(bean, qName, childNode);
                } else if (!this.configureInlineText(bean, childNode, qName, attrStrategy) && !this.configureInlineBean(bean, childNode, attrStrategy)) {
                    this.configureBeanProperties(childNode, qName, bean, type, attrStrategy, allowParam);
                }
            }
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw XmlConfigContext.error(e, childNode);
        }
    }

    private Attribute getAttribute(ConfigType<?> type, QName qName, Node childNode) {
        Attribute attrStrategy = type.getAttribute(qName);
        if (attrStrategy == null) {
            attrStrategy = type.getDefaultAttribute(qName);
        }
        if (attrStrategy != null) {
            return attrStrategy;
        }
        if (childNode instanceof Element || childNode instanceof Attr) {
            String localName = qName.getLocalName();
            if (localName.indexOf(58) >= 0) {
                throw XmlConfigContext.error(L.l("'{0}' does not have a defined namespace for 'xmlns:{1}'.  Tags with prefixes need defined namespaces.", (Object)qName.getName(), localName.substring(0, localName.indexOf(58))), childNode);
            }
            if ("new".equals(localName)) {
                return null;
            }
            throw XmlConfigContext.error(L.l("'{0}' is an unknown property of '{1}'.", (Object)qName.getName(), type.getTypeName()), childNode);
        }
        return null;
    }

    private void setText(Object bean, QName qName, String text, Attribute attrStrategy, boolean isTrim) {
        ConfigType<?> attrType = attrStrategy.getConfigType();
        if (isTrim && !attrType.isNoTrim()) {
            text = text.trim();
        }
        if (this.isEL() && attrType.isEL() && text.indexOf("${") >= 0) {
            Object value = attrType.valueOf(this.evalObject(text));
            attrStrategy.setValue(bean, qName, value);
        } else {
            attrStrategy.setText(bean, qName, text);
        }
    }

    private boolean configureInlineText(Object bean, Node childNode, QName qName, Attribute attrStrategy) {
        if (!attrStrategy.isSetter()) {
            return false;
        }
        boolean isTrim = !attrStrategy.getConfigType().isNoTrim();
        String text = this.getTextValue(childNode, isTrim);
        if (text == null) {
            return false;
        }
        isTrim = this.isTrim(childNode);
        if (this.isEL() && attrStrategy.isEL() && (text.indexOf("#{") >= 0 || text.indexOf("${") >= 0)) {
            Object elValue;
            if (isTrim) {
                text = text.trim();
            }
            if ((elValue = this.eval(attrStrategy.getConfigType(), text)) != NULL) {
                attrStrategy.setValue(bean, qName, elValue);
            } else {
                try {
                    attrStrategy.setValue(bean, qName, null);
                }
                catch (Exception e) {
                    throw ConfigException.create(L.l("{0} value must not be null.\n  ", text), (Throwable)e);
                }
            }
            return true;
        }
        if (attrStrategy.isAllowText()) {
            this.setText(bean, qName, text, attrStrategy, isTrim);
            return true;
        }
        return false;
    }

    private boolean configureInlineBean(Object parent, Node node, Attribute attrStrategy) {
        Node childNode = this.getChildElement(node);
        if (childNode == null) {
            return false;
        }
        QName qName = ((QNode)childNode).getQName();
        ConfigType<?> type = TypeFactory.getFactory().getEnvironmentType(qName);
        if (type == null || !attrStrategy.isInlineType(type)) {
            return false;
        }
        Element childNew = this.getChildNewElement(childNode);
        Object childBean = childNew != null ? this.createNew(type, parent, childNew) : type.create(parent, qName);
        if (childBean == null) {
            return false;
        }
        ConfigType<?> childType = TypeFactory.getType(childBean);
        childBean = this.configureChildBean(childBean, childType, childNode, attrStrategy);
        attrStrategy.setValue(parent, qName, childBean);
        return true;
    }

    private void configureBeanProperties(Node childNode, QName qName, Object bean, ConfigType<?> type, Attribute attrStrategy, boolean allowParam) {
        Object childBean = attrStrategy.create(bean, qName);
        if (childBean == null) {
            throw this.unableToCreateError(attrStrategy, bean, qName, childNode);
        }
        ConfigType<?> childBeanType = TypeFactory.getType(childBean);
        childBean = this.configureChildBean(childBean, childBeanType, childNode, attrStrategy);
        attrStrategy.setValue(bean, qName, childBean);
    }

    private Object configureChildBean(Object childBean, ConfigType<?> childBeanType, Node childNode, Attribute attrStrategy) {
        if (childNode instanceof Element) {
            this.configureNode(childNode, childBean, childBeanType);
        } else {
            this.configureChildNode(childNode, TEXT, childBean, childBeanType, false);
        }
        childBeanType.init(childBean);
        Object newBean = attrStrategy.replaceObject(childBean);
        if (newBean == childBean) {
            return childBeanType.replaceObject(childBean);
        }
        return newBean;
    }

    private ConfigException unableToCreateError(Attribute attr, Object bean, QName qName, Node node) {
        Element child = this.getUniqueChildElement(node);
        if (child == null) {
            throw XmlConfigContext.error(L.l("unable to create inline attribute '{2}' for '{1}' because no unique child Element exists.  Attribute = {0}", attr, bean, qName), node);
        }
        QName childQName = ((QNode)((Object)child)).getQName();
        String uri = childQName.getNamespaceURI();
        if (uri == null || !uri.startsWith("urn:java:")) {
            throw XmlConfigContext.error(L.l("unable to create inline attribute '{0}' for '{1}' because the child <{2}> uri must start with xmlns='urn:java:...' but uri='{3}' for {4}", qName.getName(), bean, childQName.getName(), uri, attr), node);
        }
        throw this.throwUnableToCreateError(attr, bean, qName, node);
    }

    private ConfigException throwUnableToCreateError(Attribute attr, Object bean, QName qName, Node childNode) {
        throw XmlConfigContext.error(L.l("unable to create attribute {0} for {1} and {2}", attr, bean, qName), childNode);
    }

    private Node getChildElement(Node node) {
        Element child = this.getUniqueChildElement(node);
        if (child == null) {
            return null;
        }
        QName qName = ((QNode)((Object)child)).getQName();
        String uri = qName.getNamespaceURI();
        if (uri == null || !uri.startsWith("urn:java:")) {
            return null;
        }
        return child;
    }

    private Element getUniqueChildElement(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element elt = (Element)node;
        Node child = elt.getFirstChild();
        if (child == null) {
            return null;
        }
        if (this.isEmptyText(child) && (child = child.getNextSibling()) == null) {
            return null;
        }
        Node next = child.getNextSibling();
        if (!(next == null || next.getNextSibling() == null && this.isEmptyText(next))) {
            return null;
        }
        if (child instanceof Element) {
            return (Element)child;
        }
        return null;
    }

    private Object createNew(ConfigType<?> type, Object parent, Element newNode) {
        boolean isTrim = true;
        String text = this.getTextValue(newNode, isTrim);
        if (text != null) {
            text = text.trim();
            return type.valueOf(this.create(newNode, StringType.TYPE));
        }
        int count = this.countNewChildren(newNode);
        Constructor ctor = type.getConstructor(count);
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        int i = 0;
        for (Node child = newNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            ConfigType<?> childType = TypeFactory.getType(paramTypes[i]);
            args[i++] = this.create(child, childType);
        }
        try {
            return ctor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw ConfigException.create(ctor.getName(), e.getCause());
        }
        catch (Exception e) {
            throw ConfigException.create(ctor.getName(), (Throwable)e);
        }
    }

    private int countNewChildren(Element newNode) {
        int count = 0;
        for (Node child = newNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            ++count;
        }
        return count;
    }

    private Element getChildNewElement(Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element elt = (Element)node;
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"new".equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    private boolean isEmptyText(Node node) {
        if (!(node instanceof CharacterData)) {
            return false;
        }
        CharacterData data = (CharacterData)node;
        return data.getData().trim().length() == 0;
    }

    private boolean isTrim(Node node) {
        Element elt;
        if (node instanceof Attr) {
            return false;
        }
        return !(node instanceof Element) || "".equals((elt = (Element)node).getAttribute("xml:space"));
    }

    private ConfigProgram buildProgram(Attribute attr, Node node) {
        return new NodeBuilderChildProgram(node);
    }

    public Object create(Node childNode, ConfigType<?> type) throws ConfigException {
        try {
            String text = this.getArgTextValue(childNode);
            if (text != null) {
                boolean isTrim = this.isTrim(childNode);
                if (this.isEL() && type.isEL() && (text.indexOf("#{") >= 0 || text.indexOf("${") >= 0)) {
                    Object elValue;
                    if (isTrim) {
                        text = text.trim();
                    }
                    if ((elValue = this.eval(type, text)) != NULL) {
                        return elValue;
                    }
                    return null;
                }
                return type.valueOf(text);
            }
            QName qName = ((QNode)childNode).getQName();
            ConfigType childBeanType = type.createType(qName);
            if (childBeanType != null) {
                Object childBean = childBeanType.create(null, qName);
                if (childNode instanceof Element) {
                    this.configureNode(childNode, childBean, childBeanType);
                } else {
                    this.configureChildNode(childNode, TEXT, childBean, childBeanType, false);
                }
                childBeanType.init(childBean);
                return childBeanType.replaceObject(childBean);
            }
            String textValue = type.isNoTrim() ? XmlConfigContext.textValueNoTrim(childNode) : XmlConfigContext.textValue(childNode);
            if (this.isEL() && type.isEL() && textValue.indexOf("${") >= 0) {
                Object value = type.valueOf(this.evalObject(textValue));
                return value;
            }
            return type.valueOf(textValue);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw XmlConfigContext.error(e, childNode);
        }
    }

    Object configureValue(Node node) {
        String value = XmlConfigContext.textValue(node);
        if (this.isEL() && value != null && value.startsWith("${") && value.endsWith("}")) {
            return this.evalObject(value);
        }
        return value;
    }

    public ArrayList<Dependency> getDependencyList() {
        return this._dependList;
    }

    ArrayList<Dependency> getDependencyList(Node node) {
        ArrayList<Depend> dependList = null;
        if (node instanceof QElement) {
            QElement qelt = (QElement)node;
            QDocument doc = (QDocument)qelt.getOwnerDocument();
            if (doc == null) {
                return null;
            }
            if (doc == this._dependDocument) {
                return this._dependList;
            }
            this._dependDocument = doc;
            ArrayList<Path> pathList = doc.getDependList();
            if (pathList != null) {
                dependList = new ArrayList<Depend>();
                for (int i = 0; i < pathList.size(); ++i) {
                    dependList.add(new Depend(pathList.get(i)));
                }
            }
            this._dependList = dependList;
        }
        return dependList;
    }

    public static ConfigELContext getELContext() {
        return ConfigELContext.EL_CONTEXT;
    }

    private String getTextValue(Node node, boolean isTrim) {
        if (node instanceof Attr) {
            Attr attrNode = (Attr)node;
            String data = attrNode.getNodeValue();
            return data;
        }
        if (node instanceof CharacterData) {
            CharacterData cData = (CharacterData)node;
            return cData.getData();
        }
        if (!(node instanceof Element)) {
            return null;
        }
        QElement elt = (QElement)node;
        for (Node attr = elt.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            if ("xml".equals(attr.getPrefix())) continue;
            return null;
        }
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                return null;
            }
            if (!(child instanceof CharacterData)) continue;
            String data = ((CharacterData)child).getData();
            if (child.getNextSibling() != null) {
                return null;
            }
            if (!isTrim || !XmlUtil.isWhitespace(data)) {
                return data;
            }
            return null;
        }
        return "";
    }

    private String getArgTextValue(Node node) {
        if (node instanceof Element && !node.getLocalName().equals("value")) {
            return null;
        }
        boolean isTrim = true;
        return this.getTextValue(node, isTrim);
    }

    private Object eval(ConfigType<?> type, String data) {
        ELParser parser;
        Expr expr;
        ConfigELContext elContext = XmlConfigContext.getELContext();
        Object value = type.valueOf(elContext, expr = (parser = new ELParser(elContext, data)).parse());
        if (value != null) {
            return value;
        }
        return NULL;
    }

    private static String textValue(Node node) {
        String space;
        if (node instanceof Attr) {
            return node.getNodeValue();
        }
        String value = XmlUtil.textValue(node);
        if (value == null || value.equals("")) {
            return "";
        }
        if (node instanceof Element && !(space = ((Element)node).getAttribute("xml:space")).equals("")) {
            return value;
        }
        return value.trim();
    }

    private static String textValueNoTrim(Node node) {
        if (node instanceof Attr) {
            return node.getNodeValue();
        }
        String value = XmlUtil.textValue(node);
        if (value == null) {
            return "";
        }
        return value;
    }

    private Object evalObject(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0 && this.isEL()) {
            ELParser parser = new ELParser(XmlConfigContext.getELContext(), exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.getValue(XmlConfigContext.getELContext());
        }
        return exprString;
    }

    private static RuntimeException error(String msg, Node node) {
        String systemId = null;
        String filename = null;
        int line = 0;
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            systemId = qnode.getBaseURI();
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        if (systemId != null) {
            String sourceLines = XmlConfigContext.getSourceLines(systemId, line);
            msg = msg + sourceLines;
        }
        if (filename != null) {
            return new LineConfigException(filename, line, msg);
        }
        return new LineConfigException(msg);
    }

    private static RuntimeException error(Throwable e, Node node) {
        String sourceLines;
        String systemId = null;
        String filename = null;
        int line = 0;
        if (e instanceof RuntimeException && e instanceof DisplayableException && !ConfigException.class.equals(e.getClass())) {
            return (RuntimeException)e;
        }
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            systemId = qnode.getBaseURI();
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        while (!(e.getCause() == null || e instanceof LineCompileException || e instanceof LineConfigException || e instanceof CompileException)) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            return (LineConfigException)e;
        }
        if (e instanceof LineCompileException) {
            return new LineConfigException(e.getMessage(), e);
        }
        if (e instanceof ConfigException && e.getMessage() != null && filename != null) {
            sourceLines = XmlConfigContext.getSourceLines(systemId, line);
            return new LineConfigException(filename, line, e.getMessage() + sourceLines, e);
        }
        if (e instanceof CompileException && e.getMessage() != null) {
            return new LineConfigException(filename, line, e);
        }
        sourceLines = XmlConfigContext.getSourceLines(systemId, line);
        String msg = filename + ":" + line + ": " + e + sourceLines;
        if (e instanceof RuntimeException) {
            throw new LineConfigException(msg, e);
        }
        if (e instanceof Error) {
            throw new LineConfigException(msg, e);
        }
        return new LineConfigException(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSourceLines(String systemId, int errorLine) {
        if (systemId == null) {
            return "";
        }
        ReadStream is = null;
        try {
            String text;
            is = Vfs.lookup().lookup(systemId).openRead();
            int line = 0;
            StringBuilder sb = new StringBuilder("\n\n");
            while ((text = is.readLine()) != null) {
                if (errorLine - 2 > ++line || line > errorLine + 2) continue;
                sb.append(line);
                sb.append(": ");
                sb.append(text);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.log(Level.FINEST, e.toString(), e);
            String string = "";
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

