/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.blob;

import com.caucho.db.blob.Inode;
import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import java.io.IOException;
import java.io.InputStream;

public class InodeBlobInputStream
extends InputStream {
    private static final int INODE_DIRECT_BLOCKS = 14;
    private BlockStore _store;
    private long _length;
    private long _offset;
    private byte[] _inode;
    private int _inodeOffset;
    private Block _block;
    private byte[] _buffer;
    private int _bufferOffset;
    private int _bufferEnd;

    public InodeBlobInputStream(BlockStore store, byte[] inode, int inodeOffset) {
        this.init(store, inode, inodeOffset);
    }

    public InodeBlobInputStream(Inode inode) {
        this.init(inode.getStore(), inode.getBuffer(), 0);
    }

    public void init(BlockStore store, byte[] inode, int inodeOffset) {
        if (store == null) {
            throw new NullPointerException();
        }
        this._store = store;
        this._inode = inode;
        this._inodeOffset = inodeOffset;
        this._length = InodeBlobInputStream.readLong(inode, inodeOffset);
        this._offset = 0L;
        this._block = null;
        if (this._length <= 120L) {
            this._buffer = inode;
            this._bufferOffset = inodeOffset + 8;
            this._bufferEnd = (int)((long)this._bufferOffset + this._length);
        } else {
            this._buffer = null;
            this._bufferOffset = 0;
            this._bufferEnd = 0;
        }
    }

    public int read() throws IOException {
        if (this._length <= this._offset) {
            return -1;
        }
        if (this._bufferEnd <= this._bufferOffset) {
            this.readBlock();
        }
        ++this._offset;
        return this._buffer[this._bufferOffset++] & 0xFF;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int sublen;
        if (this._length <= this._offset) {
            return -1;
        }
        if (this._bufferEnd <= this._bufferOffset) {
            this.readBlock();
        }
        if (length < (sublen = this._bufferEnd - this._bufferOffset)) {
            sublen = length;
        }
        this._offset += (long)sublen;
        System.arraycopy(this._buffer, this._bufferOffset, buf, offset, sublen);
        this._bufferOffset += sublen;
        return sublen;
    }

    public void close() {
        if (this._block != null) {
            Block block = this._block;
            this._block = null;
            block.free();
        }
    }

    public void readBlock() throws IOException {
        long addr;
        int blockCount;
        if (this._block != null) {
            Block block = this._block;
            this._block = null;
            block.free();
        }
        if ((blockCount = (int)(this._offset / 8192L)) < 14) {
            addr = InodeBlobInputStream.readLong(this._inode, this._inodeOffset + 8 * (blockCount + 1));
        } else {
            long ptrAddr = InodeBlobInputStream.readLong(this._inode, this._inodeOffset + 120);
            Block ptr = this._store.readBlock(this._store.addressToBlockId(ptrAddr));
            addr = InodeBlobInputStream.readLong(ptr.getBuffer(), 8 * (blockCount - 14));
            ptr.free();
        }
        this._block = this._store.readBlock(this._store.addressToBlockId(addr));
        this._buffer = this._block.getBuffer();
        int offset = (int)(addr & 0x1FFFL);
        if (offset > 0) {
            this._bufferOffset = InodeBlobInputStream.readShort(this._buffer, offset);
            this._bufferEnd = this._bufferOffset + InodeBlobInputStream.readShort(this._buffer, offset + 2);
        } else {
            this._bufferOffset = 0;
            this._bufferEnd = this._buffer.length;
        }
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private static int readShort(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 8) + (buffer[offset + 1] & 0xFF);
    }
}

