/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.BlockManager;
import com.caucho.db.block.BlockStore;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockReadWrite {
    private static final Logger log = Logger.getLogger(BlockReadWrite.class.getName());
    private static final L10N L = new L10N(BlockReadWrite.class);
    private final BlockStore _store;
    private final BlockManager _blockManager;
    private Path _path;
    private long _fileSize;
    private Object _fileLock = new Object();
    private FreeList<RandomAccessWrapper> _cachedRowFile = new FreeList(4);
    private final Semaphore _rowFileSemaphore = new Semaphore(8);

    public BlockReadWrite(BlockStore store, Path path) {
        this._store = store;
        this._blockManager = store.getBlockManager();
        this._path = path;
        if (path == null) {
            throw new NullPointerException();
        }
    }

    public long getFileSize() {
        return this._fileSize;
    }

    void create() throws IOException, SQLException {
        this._path.getParent().mkdirs();
        if (this._path.exists()) {
            throw new SQLException(L.l("CREATE for path '{0}' failed, because the file already exists.  CREATE can not override an existing table.", this._path.getNativePath()));
        }
    }

    boolean isFileExist() {
        return this._path.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws IOException {
        RandomAccessWrapper wrapper = this.openRowFile(true);
        boolean isPriority = true;
        try {
            RandomAccessStream file = wrapper.getFile();
            this._fileSize = file.getLength();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeRowFile(wrapper, isPriority);
            throw throwable;
        }
        this.closeRowFile(wrapper, isPriority);
    }

    public void remove() throws SQLException {
        try {
            Path path = this._path;
            this._path = null;
            this.close();
            if (path != null) {
                path.remove();
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlock(long blockId, byte[] buffer, int offset, int length) throws IOException {
        boolean isPriority = false;
        RandomAccessWrapper wrapper = this.openRowFile(isPriority);
        try {
            RandomAccessStream is = wrapper.getFile();
            long blockAddress = blockId & 0xFFFFFFFFFFFFE000L;
            if (blockAddress < 0L || this._fileSize < blockAddress + (long)length) {
                throw new IllegalStateException(L.l("block at 0x{0} is invalid for file {1} (length 0x{2})", Long.toHexString(blockAddress), this._path, Long.toHexString(this._fileSize)));
            }
            int readLen = is.read(blockAddress, buffer, offset, length);
            if (readLen < 0) {
                throw new IllegalStateException("Error reading " + is + " for block " + Long.toHexString(blockAddress) + " result=" + readLen);
            }
            if (readLen < length) {
                System.out.println("BAD-READ: " + Long.toHexString(blockAddress));
                if (readLen < 0) {
                    readLen = 0;
                }
                for (int i = readLen; i < 8192; ++i) {
                    buffer[i] = 0;
                }
            }
            this._blockManager.addBlockRead();
            this.freeRowFile(wrapper, isPriority);
            wrapper = null;
            Object var14_11 = null;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            this.closeRowFile(wrapper, isPriority);
            throw throwable;
        }
        this.closeRowFile(wrapper, isPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(long blockAddress, byte[] buffer, int offset, int length, boolean isPriority) throws IOException {
        RandomAccessWrapper wrapper = this.openRowFile(isPriority);
        try {
            RandomAccessStream os = wrapper.getFile();
            if (buffer == null || offset < 0 || length < 0 || buffer.length < offset + length) {
                System.out.println("BUFFER: " + buffer + " " + offset + " " + length);
            }
            os.write(blockAddress, buffer, offset, length);
            this.freeRowFile(wrapper, isPriority);
            wrapper = null;
            Object object = this._fileLock;
            synchronized (object) {
                if (this._fileSize < blockAddress + (long)length) {
                    this._fileSize = blockAddress + (long)length;
                }
            }
            this._blockManager.addBlockWrite();
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.closeRowFile(wrapper, isPriority);
            throw throwable;
        }
        this.closeRowFile(wrapper, isPriority);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RandomAccessWrapper openRowFile(boolean isPriority) throws IOException {
        if (!isPriority) {
            try {
                Thread.interrupted();
                this._rowFileSemaphore.acquire();
            }
            catch (InterruptedException e) {
                log.log(Level.FINE, e.toString(), e);
                return null;
            }
        }
        RandomAccessWrapper wrapper = null;
        try {
            RandomAccessWrapper randomAccessWrapper;
            try {
                randomAccessWrapper = wrapper = this.openRowFileImpl();
                Object var5_8 = null;
                if (wrapper != null) return randomAccessWrapper;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this._rowFileSemaphore.release();
            return randomAccessWrapper;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (wrapper != null) throw throwable;
            this._rowFileSemaphore.release();
            throw throwable;
        }
    }

    private RandomAccessWrapper openRowFileImpl() throws IOException {
        Path path;
        RandomAccessStream file = null;
        RandomAccessWrapper wrapper = null;
        wrapper = this._cachedRowFile.allocate();
        if (wrapper != null) {
            file = wrapper.getFile();
        }
        if (file == null && (path = this._path) != null) {
            file = path.openRandomAccess();
            wrapper = new RandomAccessWrapper(file);
        }
        return wrapper;
    }

    private void freeRowFile(RandomAccessWrapper wrapper, boolean isPriority) throws IOException {
        if (wrapper == null) {
            return;
        }
        if (!isPriority) {
            this._rowFileSemaphore.release();
        }
        if (this._cachedRowFile.free(wrapper)) {
            return;
        }
        wrapper.close();
    }

    private void closeRowFile(RandomAccessWrapper wrapper, boolean isPriority) throws IOException {
        if (wrapper == null) {
            return;
        }
        if (!isPriority) {
            this._rowFileSemaphore.release();
        }
        wrapper.close();
    }

    void close() {
        this._path = null;
        RandomAccessWrapper wrapper = null;
        wrapper = this._cachedRowFile.allocate();
        if (wrapper != null) {
            try {
                wrapper.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._store.getId() + "]";
    }

    static class RandomAccessWrapper {
        private RandomAccessStream _file;

        RandomAccessWrapper(RandomAccessStream file) {
            this._file = file;
        }

        RandomAccessStream getFile() {
            return this._file;
        }

        void close() throws IOException {
            RandomAccessStream file = this._file;
            this._file = null;
            if (file != null) {
                file.close();
            }
        }
    }
}

