/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.Database;
import com.caucho.db.block.Block;
import com.caucho.db.block.BlockManager;
import com.caucho.db.block.BlockReadWrite;
import com.caucho.db.block.BlockWriter;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockStore {
    private static final Logger log = Logger.getLogger(BlockStore.class.getName());
    private static final L10N L = new L10N(BlockStore.class);
    public static final int BLOCK_BITS = 13;
    public static final int BLOCK_SIZE = 8192;
    public static final long BLOCK_INDEX_MASK = 8191L;
    public static final long BLOCK_MASK = -8192L;
    public static final long BLOCK_OFFSET_MASK = 8191L;
    private static final int ALLOC_BYTES_PER_BLOCK = 2;
    private static final int ALLOC_CHUNK_SIZE = 8192;
    private static final int ALLOC_GROUP_COUNT = 4096;
    private static final long ALLOC_GROUP_SIZE = 0x2000000L;
    public static final int ALLOC_FREE = 0;
    public static final int ALLOC_ROW = 1;
    public static final int ALLOC_USED = 2;
    public static final int ALLOC_INDEX = 4;
    public static final int ALLOC_MINI_FRAG = 5;
    public static final int ALLOC_MASK = 15;
    public static final int MINI_FRAG_SIZE = 256;
    public static final int MINI_FRAG_PER_BLOCK = 31;
    public static final int MINI_FRAG_ALLOC_OFFSET = 7936;
    public static final long DATA_START = 8192L;
    public static final int STORE_CREATE_END = 1024;
    private final String _name;
    private int _id;
    protected final Database _database;
    protected final BlockManager _blockManager;
    private final BlockReadWrite _readWrite;
    private final BlockWriter _writer;
    private boolean _isFlushDirtyBlocksOnCommit = true;
    private long _blockCount;
    private final Object _allocationLock = new Object();
    private byte[] _allocationTable;
    private long _freeAllocIndex;
    private int _freeAllocCount;
    private int _freeMiniAllocIndex;
    private int _freeMiniAllocCount;
    private final Object _allocationWriteLock = new Object();
    private final AtomicInteger _allocationWriteCount = new AtomicInteger();
    private int _allocDirtyMin = Integer.MAX_VALUE;
    private int _allocDirtyMax;
    private long _miniFragmentUseCount;
    private Lock _rowWriteLock;
    private long _blockLockTimeout = 120000L;
    private boolean _isCorrupted;
    private final Lifecycle _lifecycle = new Lifecycle();

    public BlockStore(Database database, String name, ReadWriteLock tableLock) {
        this(database, name, tableLock, database.getPath().lookup(name + ".db"));
    }

    public BlockStore(Database database, String name, ReadWriteLock rowLock, Path path) {
        this._database = database;
        this._blockManager = this._database.getBlockManager();
        this._name = name;
        this._id = this._blockManager.allocateStoreId();
        if (path == null) {
            throw new NullPointerException();
        }
        this._readWrite = new BlockReadWrite(this, path);
        this._writer = new BlockWriter(this);
        if (rowLock == null) {
            rowLock = new ReentrantReadWriteLock();
        }
        rowLock.readLock();
        this._rowWriteLock = rowLock.writeLock();
    }

    public static BlockStore create(Path path) throws IOException, SQLException {
        Database db = new Database();
        db.init();
        BlockStore store = new BlockStore(db, "temp", null, path);
        if (path.canRead()) {
            store.init();
        } else {
            store.create();
        }
        return store;
    }

    public void setFlushDirtyBlocksOnCommit(boolean flushOnCommit) {
        this._isFlushDirtyBlocksOnCommit = flushOnCommit;
    }

    public boolean isFlushDirtyBlocksOnCommit() {
        return this._isFlushDirtyBlocksOnCommit;
    }

    public String getName() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public Lock getWriteLock() {
        return this._rowWriteLock;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    protected BlockReadWrite getReadWrite() {
        return this._readWrite;
    }

    BlockWriter getWriter() {
        return this._writer;
    }

    public void setCorrupted(boolean isCorrupted) {
        this._isCorrupted = isCorrupted;
    }

    public boolean isCorrupted() {
        return this._isCorrupted;
    }

    public long getFileSize() {
        return this._readWrite.getFileSize();
    }

    public long getBlockCount() {
        return this._blockCount;
    }

    public static long blockIndexToAddr(long blockIndex) {
        return blockIndex << 13;
    }

    private final long blockIndexToBlockId(long blockIndex) {
        return (blockIndex << 13) + (long)this._id;
    }

    public static long blockIdToIndex(long blockId) {
        return blockId >> 13;
    }

    public final long addressToBlockId(long address) {
        return (address & 0xFFFFFFFFFFFFE000L) + (long)this._id;
    }

    public static long blockIdToAddress(long blockId) {
        return blockId & 0xFFFFFFFFFFFFE000L;
    }

    public static long blockIdToAddress(long blockId, int offset) {
        return (blockId & 0xFFFFFFFFFFFFE000L) + (long)offset;
    }

    public void create() throws IOException, SQLException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(this + " create");
        this._readWrite.create();
        this._allocationTable = new byte[8192];
        this.setAllocation(0L, 2);
        this.setAllocation(1L, 2);
        boolean isPriority = true;
        byte[] buffer = new byte[8192];
        this._readWrite.writeBlock(0L, buffer, 0, 8192, isPriority);
        this._readWrite.writeBlock(8192L, buffer, 0, 8192, isPriority);
        this._readWrite.writeBlock(0L, this._allocationTable, 0, this._allocationTable.length, isPriority);
        this._blockCount = 2L;
    }

    public void init() throws IOException {
        if (!this._lifecycle.toActive()) {
            return;
        }
        log.finer(this + " init");
        this._readWrite.init();
        this._blockCount = (this.getFileSize() + 8192L - 1L) / 8192L;
        int allocCount = (int)this._blockCount;
        allocCount += 4095;
        allocCount -= allocCount % 4096;
        int allocSize = allocCount * 2;
        this._allocationTable = new byte[allocSize];
        for (int i = 0; i < allocSize; i += 8192) {
            int len = allocSize - i;
            long allocGroup = i / 8192;
            if (8192 < len) {
                len = 8192;
            }
            this._readWrite.readBlock(allocGroup * 0x2000000L, this._allocationTable, i, len);
        }
    }

    public void remove() throws SQLException {
        this._readWrite.remove();
        this.close();
    }

    public long firstRowBlock(long blockId) throws IOException {
        return this.firstBlock(blockId, 1);
    }

    public long firstBlock(long blockId, int type) throws IOException {
        if (blockId <= 8192L) {
            blockId = 8192L;
        }
        long blockCount = this._blockCount;
        for (long blockIndex = blockId >> 13; blockIndex < blockCount; ++blockIndex) {
            if (this.getAllocation(blockIndex) != type) continue;
            return this.blockIndexToBlockId(blockIndex);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Block readBlock(long blockAddress) throws IOException {
        long blockId = this.addressToBlockId(blockAddress);
        Block block = this._blockManager.getBlock(this, blockId);
        boolean isValid = false;
        try {
            block.read();
            isValid = true;
            Block block2 = block;
            Object var9_6 = null;
            if (!isValid) {
                block.free();
            }
            return block2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var9_7 = null;
                if (isValid) break block3;
                block.free();
            }
            throw throwable;
        }
    }

    public final Block loadBlock(long blockAddress) throws IOException {
        long blockId = this.addressToBlockId(blockAddress);
        Block block = this._blockManager.getBlock(this, blockId);
        return block;
    }

    public Block allocateRow() throws IOException {
        boolean isSave = true;
        Block block = this.allocateBlock(1, isSave);
        return block;
    }

    public boolean isRowBlock(long blockAddress) {
        return this.getAllocation(blockAddress / 8192L) == 1;
    }

    public Block allocateBlock() throws IOException {
        boolean isSave = true;
        return this.allocateBlock(2, isSave);
    }

    private Block allocateBlockMiniFragment() throws IOException {
        boolean isSave = true;
        return this.allocateBlock(5, isSave);
    }

    public Block allocateIndexBlock() throws IOException {
        boolean isSave = false;
        return this.allocateBlock(4, isSave);
    }

    public boolean isIndexBlock(long blockAddress) {
        return this.getAllocation(blockAddress / 8192L) == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block allocateBlock(int code, boolean isSave) throws IOException {
        long blockIndex;
        while ((blockIndex = this.findFreeBlock()) == 0L) {
            if (this._freeAllocIndex != this._blockCount || this._freeAllocCount != 0) continue;
            this.extendFile();
        }
        long blockId = this.blockIndexToBlockId(blockIndex);
        Block block = this._blockManager.getBlock(this, blockId);
        byte[] buffer = block.getBuffer();
        for (int i = 8191; i >= 0; --i) {
            buffer[i] = 0;
        }
        block.validate();
        block.setDirty(0, 8192);
        Object object = this._allocationLock;
        synchronized (object) {
            this.setAllocation(blockIndex, code);
        }
        this.saveAllocation();
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findFreeBlock() {
        Object object = this._allocationLock;
        synchronized (object) {
            long end = this._blockCount;
            if ((long)this._allocationTable.length < 2L * end) {
                end = this._allocationTable.length / 2;
            }
            for (long blockIndex = this._freeAllocIndex; blockIndex < end; ++blockIndex) {
                if (this.getAllocation(blockIndex) != 0) continue;
                this._freeAllocIndex = blockIndex;
                ++this._freeAllocCount;
                this.setAllocation(blockIndex, 2);
                return blockIndex;
            }
            if (this._freeAllocCount > 0) {
                this._freeAllocIndex = 0L;
                this._freeAllocCount = 0;
            } else {
                this._freeAllocIndex = this._blockCount;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extendFile() {
        long newBlockCount;
        Object object = this._allocationLock;
        synchronized (object) {
            if (this._freeAllocIndex < this._blockCount) {
                return;
            }
            newBlockCount = this._blockCount < 256L ? this._blockCount + 1L : this._blockCount + 256L;
            while ((long)(this._allocationTable.length / 2) <= newBlockCount) {
                byte[] newTable = new byte[this._allocationTable.length + 8192];
                System.arraycopy(this._allocationTable, 0, newTable, 0, this._allocationTable.length);
                this._allocationTable = newTable;
                long superBlockMax = this._allocationTable.length / 2;
                for (long count = 0L; count < superBlockMax; count += 4096L) {
                    this.setAllocation(count, 2);
                    if (newBlockCount != count) continue;
                    ++newBlockCount;
                }
                this._allocDirtyMin = 0;
                this._allocDirtyMax = newTable.length;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " extending file " + newBlockCount);
            }
            this._blockCount = newBlockCount;
            this._freeAllocIndex = 0L;
            if (this.getAllocation(newBlockCount) != 0) {
                System.out.println("BAD_BLOCK: " + newBlockCount);
            }
            this.setAllocation(newBlockCount, 2);
        }
        long blockId = this.blockIndexToBlockId(newBlockCount);
        Block block = this._blockManager.getBlock(this, blockId);
        byte[] buffer = block.getBuffer();
        for (int i = 8191; i >= 0; --i) {
            buffer[i] = 0;
        }
        block.validate();
        block.setDirty(0, 8192);
        try {
            block.writeFromBlockWriter();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        block.free();
        Object object2 = this._allocationLock;
        synchronized (object2) {
            this.setAllocation(newBlockCount, 0);
        }
    }

    protected void validateBlockId(long blockId) throws IllegalArgumentException, IllegalStateException {
        RuntimeException e = null;
        if (this.isClosed()) {
            e = new IllegalStateException(L.l("store {0} is closing.", this));
        } else if (this.getId() <= 0) {
            e = new IllegalStateException(L.l("invalid store {0}.", this));
        } else if ((long)this.getId() != (blockId & 0x1FFFL)) {
            e = new IllegalArgumentException(L.l("block {0} must match store {1}.", (Object)(blockId & 0x1FFFL), this));
        }
        if (e != null) {
            throw e;
        }
    }

    protected void assertStoreActive() throws IllegalStateException {
        IllegalStateException e = null;
        if (this.isClosed()) {
            e = new IllegalStateException(L.l("store {0} is closing.", this));
        } else if (this.getId() <= 0) {
            e = new IllegalStateException(L.l("invalid store {0}.", this));
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeBlock(long blockId) throws IOException {
        if (blockId == 0L) {
            return;
        }
        Object object = this._allocationLock;
        synchronized (object) {
            long index = BlockStore.blockIdToIndex(blockId);
            if (this.getAllocation(index) == 0) {
                throw new IllegalStateException(L.l("{0} double free of {1}", (Object)this, Long.toHexString(blockId)));
            }
            this.setAllocation(index, 0);
        }
        this.saveAllocation();
    }

    public final int getAllocation(long blockIndex) {
        int allocOffset = (int)(2L * blockIndex);
        return this._allocationTable[allocOffset] & 0xF;
    }

    private void setAllocation(long blockIndex, int code) {
        int allocOffset = (int)(2L * blockIndex);
        for (int i = 1; i < 2; ++i) {
            this._allocationTable[allocOffset + i] = 0;
        }
        this._allocationTable[allocOffset] = (byte)code;
        this.setAllocDirty(allocOffset, allocOffset + 2);
    }

    private void setAllocDirty(int min, int max) {
        if (min < this._allocDirtyMin) {
            this._allocDirtyMin = min;
        }
        if (this._allocDirtyMax < max) {
            this._allocDirtyMax = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllocation() throws IOException {
        if (!this._isFlushDirtyBlocksOnCommit) {
            return;
        }
        if (this._allocDirtyMax <= this._allocDirtyMin) {
            return;
        }
        try {
            if (this._allocationWriteCount.incrementAndGet() < 2) {
                Object object = this._allocationWriteLock;
                synchronized (object) {
                    int dirtyMax;
                    int dirtyMin;
                    Object object2 = this._allocationLock;
                    synchronized (object2) {
                        dirtyMin = this._allocDirtyMin;
                        this._allocDirtyMin = Integer.MAX_VALUE;
                        dirtyMax = this._allocDirtyMax;
                        this._allocDirtyMax = 0;
                    }
                    this.saveAllocation(dirtyMin, dirtyMax);
                }
            }
            Object var8_7 = null;
            this._allocationWriteCount.decrementAndGet();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this._allocationWriteCount.decrementAndGet();
            throw throwable;
        }
    }

    private void saveAllocation(int dirtyMin, int dirtyMax) throws IOException {
        while (dirtyMin < dirtyMax) {
            int allocGroup = dirtyMin / 8192;
            int offset = dirtyMin % 8192;
            int length = dirtyMin / 8192 != dirtyMax / 8192 ? 8192 - offset : dirtyMax - dirtyMin;
            boolean isPriority = true;
            this._readWrite.writeBlock((long)allocGroup * 0x2000000L + (long)offset, this._allocationTable, dirtyMin, length, isPriority);
            dirtyMin = dirtyMin + 8192 - dirtyMin % 8192;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlock(long blockId, int blockOffset, OutputStream os, int length) throws IOException {
        if (blockId <= 0L) {
            log.warning(this + " illegal block read with block-id=0");
            return;
        }
        if (8192 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(blockId);
        try {
            try {
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    os.write(blockBuffer, blockOffset, length);
                    Object var10_9 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var12_12 = null;
                block.free();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBlock(long blockAddress, int blockOffset, byte[] buffer, int offset, int length) throws IOException {
        if (8192 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            try {
                int n;
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    System.arraycopy(blockBuffer, blockOffset, buffer, offset, length);
                    n = length;
                    Object var12_11 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var14_13 = null;
                block.free();
                return n;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBlock(long blockAddress, int blockOffset, char[] buffer, int offset, int length) throws IOException {
        if (8192 - blockOffset < 2 * length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            try {
                int n;
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    for (int i = 0; i < length; blockOffset += 2, ++i) {
                        int ch1 = blockBuffer[blockOffset] & 0xFF;
                        int ch2 = blockBuffer[blockOffset + 1] & 0xFF;
                        buffer[offset + i] = (char)((ch1 << 8) + ch2);
                    }
                    n = length;
                    Object var14_13 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var16_15 = null;
                block.free();
                return n;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readBlockLong(long blockAddress, int offset) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            try {
                long l;
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    l = BlockStore.readLong(blockBuffer, offset);
                    Object var10_8 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var12_10 = null;
                block.free();
                return l;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Block writeBlock(long blockAddress, int blockOffset, byte[] buffer, int offset, int length) throws IOException {
        if (8192 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            try {
                Block block2;
                Lock lock = block.getWriteLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    System.arraycopy(buffer, offset, blockBuffer, blockOffset, length);
                    block.setDirty(blockOffset, blockOffset + length);
                    block2 = block;
                    Object var12_11 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var14_13 = null;
                block.free();
                return block2;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Block writeBlock(long blockAddress, int blockOffset, char[] buffer, int offset, int charLength) throws IOException {
        int length = 2 * charLength;
        if (8192 - blockOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", blockOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            try {
                Block block2;
                Lock lock = block.getWriteLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    int blockTail = blockOffset;
                    for (int i = 0; i < charLength; blockTail += 2, ++i) {
                        char ch = buffer[offset + i];
                        blockBuffer[blockTail] = (byte)(ch >> 8);
                        blockBuffer[blockTail + 1] = (byte)ch;
                    }
                    block.setDirty(blockOffset, blockTail);
                    block2 = block;
                    Object var15_15 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var17_17 = null;
                block.free();
                return block2;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Block writeBlockLong(long blockAddress, int offset, long value) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(blockAddress));
        try {
            try {
                Block block2;
                Lock lock = block.getWriteLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    byte[] blockBuffer = block.getBuffer();
                    BlockStore.writeLong(blockBuffer, offset, value);
                    block.setDirty(offset, offset + 8);
                    block2 = block;
                    Object var11_9 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var13_11 = null;
                block.free();
                return block2;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readMiniFragment(long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            try {
                int n;
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
                    byte[] blockBuffer = block.getBuffer();
                    System.arraycopy(blockBuffer, blockOffset + fragmentOffset, buffer, offset, length);
                    n = length;
                    Object var13_12 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var15_14 = null;
                block.free();
                return n;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readMiniFragment(long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < 2 * length) {
            throw new IllegalArgumentException(L.l("read offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            try {
                int n;
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
                    blockOffset += fragmentOffset;
                    byte[] blockBuffer = block.getBuffer();
                    for (int i = 0; i < length; blockOffset += 2, ++i) {
                        int ch1 = blockBuffer[blockOffset] & 0xFF;
                        int ch2 = blockBuffer[blockOffset + 1] & 0xFF;
                        buffer[offset + i] = (char)((ch1 << 8) + ch2);
                    }
                    n = length;
                    Object var15_14 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var17_16 = null;
                block.free();
                return n;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long readMiniFragmentLong(long fragmentAddress, int fragmentOffset) throws IOException {
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            try {
                long l;
                Lock lock = block.getReadLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
                    byte[] blockBuffer = block.getBuffer();
                    l = BlockStore.readLong(blockBuffer, blockOffset + fragmentOffset);
                    Object var11_9 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var13_11 = null;
                block.free();
                return l;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public long allocateMiniFragment() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateMiniFragmentBlock() throws IOException {
        while (true) {
            byte[] allocationTable = this._allocationTable;
            for (int i = this._freeMiniAllocIndex; i < allocationTable.length; i += 2) {
                int fragMask = allocationTable[i + 1] & 0xFF;
                if (allocationTable[i] != 5 || fragMask == 255) continue;
                this._freeMiniAllocIndex = i;
                ++this._freeMiniAllocCount;
                Object object = this._allocationLock;
                synchronized (object) {
                    if (allocationTable[i] == 5 && fragMask != 255) {
                        allocationTable[i + 1] = -1;
                        this.setAllocDirty(i + 1, i + 2);
                        ++this._miniFragmentUseCount;
                        long fragmentAddress = 8192L * ((long)i / 2L);
                        return fragmentAddress;
                    }
                    continue;
                }
            }
            if (this._freeMiniAllocCount == 0) {
                int count = this._blockCount >= 256L ? 16 : 1;
                for (int i = 0; i < count; ++i) {
                    Block block = this.allocateBlockMiniFragment();
                    block.free();
                }
            }
            this._freeMiniAllocCount = 0;
            this._freeMiniAllocIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMiniFragment(long fragmentAddress) throws IOException {
        Block block = this.readBlock(fragmentAddress);
        try {
            try {
                Lock lock = block.getWriteLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    int fragIndex = (int)(fragmentAddress & 0x1FFFL);
                    int offset = fragIndex / 8 + 7936;
                    int mask = 1 << fragIndex % 8;
                    byte[] blockBuffer = block.getBuffer();
                    int n = offset;
                    blockBuffer[n] = (byte)(blockBuffer[n] & ~mask);
                    block.setDirty(offset, offset + 1);
                    int i = (int)(2L * (fragmentAddress / 8192L));
                    Object object = this._allocationLock;
                    synchronized (object) {
                        int fragMask = this._allocationTable[i + 1] & 0xFF;
                        if (this._allocationTable[i] != 5) {
                            System.out.println("BAD ENTRY: " + fragMask);
                        }
                        this._allocationTable[i + 1] = 0;
                        --this._miniFragmentUseCount;
                        this.setAllocDirty(i + 1, i + 2);
                    }
                    Object var14_13 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var16_16 = null;
                block.free();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Block writeMiniFragment(long fragmentAddress, int fragmentOffset, byte[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            try {
                Block block2;
                Lock lock = block.getWriteLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
                    byte[] blockBuffer = block.getBuffer();
                    System.arraycopy(buffer, offset, blockBuffer, blockOffset += fragmentOffset, length);
                    block.setDirty(blockOffset, blockOffset + length);
                    block2 = block;
                    Object var13_12 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var15_14 = null;
                block.free();
                return block2;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            block.free();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Block writeMiniFragment(long fragmentAddress, int fragmentOffset, char[] buffer, int offset, int length) throws IOException {
        if (256 - fragmentOffset < length) {
            throw new IllegalArgumentException(L.l("write offset {0} length {1} too long", fragmentOffset, length));
        }
        Block block = this.readBlock(this.addressToBlockId(fragmentAddress));
        try {
            try {
                Block block2;
                Lock lock = block.getWriteLock();
                lock.tryLock(this._blockLockTimeout, TimeUnit.MILLISECONDS);
                try {
                    int blockOffset = this.getMiniFragmentOffset(fragmentAddress);
                    byte[] blockBuffer = block.getBuffer();
                    int blockTail = blockOffset += fragmentOffset;
                    for (int i = 0; i < length; blockTail += 2, ++i) {
                        char ch = buffer[offset + i];
                        blockBuffer[blockTail] = (byte)(ch >> 8);
                        blockBuffer[blockTail + 1] = (byte)ch;
                    }
                    block.setDirty(blockOffset, blockTail);
                    block2 = block;
                    Object var15_15 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var17_17 = null;
                block.free();
                return block2;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            block.free();
            throw throwable;
        }
    }

    private int getMiniFragmentOffset(long fragmentAddress) {
        int id = (int)(fragmentAddress & 0x1FFFL);
        return 256 * id;
    }

    public void flush() {
        if (this._lifecycle.isActive() && this._blockManager != null) {
            this._blockManager.flush(this);
        }
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        log.finer(this + " closing");
        if (this._blockManager != null) {
            this._blockManager.freeStore(this);
        }
        this._writer.destroy();
        this._writer.waitForComplete(60000L);
        int id = this._id;
        this._id = 0;
        this._readWrite.close();
        if (this._blockManager != null) {
            this._blockManager.freeStoreId(id);
        }
    }

    public byte[] getAllocationTable() {
        byte[] table = new byte[this._allocationTable.length];
        System.arraycopy(this._allocationTable, 0, table, 0, table.length);
        return table;
    }

    public static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    public static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    public static String codeToName(int code) {
        switch (code) {
            case 0: {
                return "free";
            }
            case 1: {
                return "row";
            }
            case 2: {
                return "used";
            }
            case 5: {
                return "mini-fragment";
            }
            case 4: {
                return "index";
            }
        }
        return String.valueOf(code);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

