/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.env.thread.TaskWorker;
import com.caucho.util.Alarm;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockWriter
extends TaskWorker {
    private static final Logger log = Logger.getLogger(BlockWriter.class.getName());
    private final BlockStore _store;
    private int _writeQueueMax = 256;
    private final ArrayList<Block> _writeQueue = new ArrayList();

    BlockWriter(BlockStore store) {
        this._store = store;
        store.getReadWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirtyBlock(Block block) {
        ArrayList<Block> arrayList = this._writeQueue;
        synchronized (arrayList) {
            if (this._writeQueueMax < this._writeQueue.size()) {
                this.wake();
                try {
                    this._writeQueue.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this._writeQueue.add(block);
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean copyDirtyBlock(long blockId, Block block) {
        Block writeBlock = null;
        ArrayList<Block> arrayList = this._writeQueue;
        synchronized (arrayList) {
            int size = this._writeQueue.size();
            for (int i = size - 1; i >= 0; --i) {
                Block testBlock = this._writeQueue.get(i);
                if (testBlock.getBlockId() != blockId) continue;
                writeBlock = testBlock;
                break;
            }
        }
        if (writeBlock != null) {
            return writeBlock.copyToBlock(block);
        }
        return false;
    }

    public boolean isClosed() {
        return super.isClosed() && this._writeQueue.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForComplete(long timeout) {
        long expires = Alarm.getCurrentTimeActual() + timeout;
        ArrayList<Block> arrayList = this._writeQueue;
        synchronized (arrayList) {
            while (this._writeQueue.size() > 0) {
                this.wake();
                long now = Alarm.getCurrentTimeActual();
                long delta = now - expires;
                if (delta <= 0L) {
                    return;
                }
                try {
                    this._writeQueue.wait(delta);
                }
                catch (Exception e) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runTask() {
        try {
            int retryMax;
            int retry = retryMax = 10;
            while (true) {
                Block block;
                if ((block = this.peekFirstBlock()) != null) {
                    Object var5_5;
                    retry = retryMax;
                    try {
                        block.writeFromBlockWriter();
                        var5_5 = null;
                        this.removeFirstBlock();
                    }
                    catch (Throwable throwable) {
                        var5_5 = null;
                        this.removeFirstBlock();
                        throw throwable;
                    }
                }
                if (retry-- <= 0) break;
            }
            return -1L;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return -1L;
        }
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block peekFirstBlock() {
        ArrayList<Block> arrayList = this._writeQueue;
        synchronized (arrayList) {
            if (this._writeQueue.size() > 0) {
                Block block = this._writeQueue.get(0);
                return block;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFirstBlock() {
        ArrayList<Block> arrayList = this._writeQueue;
        synchronized (arrayList) {
            if (this._writeQueue.size() > 0) {
                this._writeQueue.remove(0);
                this._writeQueue.notifyAll();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._store + "]";
    }
}

