/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.debug;

import com.caucho.db.block.BlockStore;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Logger;

public class DebugStore {
    private static final Logger log = Log.open(DebugStore.class);
    private static final L10N L = new L10N(DebugStore.class);
    Path _path;
    BlockStore _store;

    public DebugStore(Path path) throws Exception {
        this._path = path;
        this._store = BlockStore.create(path);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: DebugStore store.db");
            return;
        }
        Path path = Vfs.lookup(args[0]);
        WriteStream out = Vfs.openWrite(System.out);
        new DebugStore(path).test(out);
        out.close();
    }

    public void test(WriteStream out) throws Exception {
        out.println("file-size   : " + this._store.getFileSize());
        out.println("block-count : " + this._store.getBlockCount());
        this.debugAllocation(out, this._store.getAllocationTable(), this._store.getBlockCount());
        this.debugFragments(out, this._store.getAllocationTable(), this._store.getBlockCount());
    }

    private void debugAllocation(WriteStream out, byte[] allocTable, long count) throws IOException {
        out.println();
        int i = 0;
        while ((long)i < 2L * count) {
            byte v = allocTable[i];
            int code = v & 0xF;
            switch (code) {
                case 0: {
                    out.print('.');
                    break;
                }
                case 1: {
                    out.print('r');
                    break;
                }
                case 2: {
                    out.print('u');
                    break;
                }
                case 5: {
                    out.print('m');
                    break;
                }
                case 4: {
                    out.print('i');
                    break;
                }
                default: {
                    out.print('?');
                }
            }
            if (i % 64 == 63) {
                out.println();
            } else if (i % 8 == 7) {
                out.print(' ');
            }
            i += 2;
        }
        out.println();
    }

    private void debugFragments(WriteStream out, byte[] allocTable, long count) throws Exception {
        long totalUsed = 0L;
        byte[] block = new byte[8192];
        int i = 0;
        while ((long)i < 2L * count) {
            byte code = allocTable[i];
            i += 2;
        }
        out.println();
        out.println("Total-used: " + totalUsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBlock(byte[] block, long count) throws Exception {
        ReadStream is = this._path.openRead();
        try {
            is.skip(count * 8192L);
            is.read(block, 0, block.length);
            Object var6_4 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            is.close();
            throw throwable;
        }
    }

    private int readShort(byte[] block, int offset) {
        return ((block[offset] & 0xFF) << 8) + (block[offset + 1] & 0xFF);
    }
}

