/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.jdbc.ResultSetImpl;
import com.caucho.db.jdbc.StatementImpl;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.xa.Transaction;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement {
    private Query _query;
    private boolean _wasResultSet;
    private ResultSet _resultSet;
    private boolean _isReturnGeneratedKeys;
    private int _count;

    PreparedStatementImpl(ConnectionImpl conn, Query query) {
        super(conn);
        this._query = query;
    }

    void setReturnGeneratedKeys(boolean isReturnGeneratedKeys) {
        this._isReturnGeneratedKeys = isReturnGeneratedKeys;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.getQueryContext().clearParameters();
    }

    @Override
    public void setNull(int parameter, int sqlType) throws SQLException {
        this.getQueryContext().setString(parameter, null);
    }

    @Override
    public void setNull(int parameter, int sqlType, String typeName) throws SQLException {
        this.getQueryContext().setString(parameter, null);
    }

    @Override
    public void setBoolean(int parameter, boolean x) throws SQLException {
        this.getQueryContext().setBoolean(parameter, x);
    }

    @Override
    public void setByte(int parameter, byte x) throws SQLException {
        this.getQueryContext().setLong(parameter, x);
    }

    @Override
    public void setShort(int parameter, short x) throws SQLException {
        this.getQueryContext().setLong(parameter, x);
    }

    @Override
    public void setInt(int parameter, int x) throws SQLException {
        this.getQueryContext().setLong(parameter, x);
    }

    @Override
    public void setLong(int parameter, long x) throws SQLException {
        this.getQueryContext().setLong(parameter, x);
    }

    @Override
    public void setFloat(int parameter, float x) throws SQLException {
        this.getQueryContext().setDouble(parameter, x);
    }

    @Override
    public void setDouble(int parameter, double x) throws SQLException {
        this.getQueryContext().setDouble(parameter, x);
    }

    @Override
    public void setBigDecimal(int parameter, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(int parameter, String x) throws SQLException {
        this.getQueryContext().setString(parameter, x);
    }

    @Override
    public void setBytes(int parameter, byte[] x) throws SQLException {
        if (x != null) {
            this.getQueryContext().setBytes(parameter, x);
        } else {
            this.setNull(parameter, 0);
        }
    }

    @Override
    public void setDate(int parameter, Date x, Calendar calendar) throws SQLException {
        this.setDate(parameter, x);
    }

    @Override
    public void setDate(int parameter, Date x) throws SQLException {
        if (x != null) {
            this.setTime(parameter, x.getTime());
        } else {
            this.setNull(parameter, 0);
        }
    }

    @Override
    public void setTime(int parameter, Time x, Calendar calendar) throws SQLException {
        this.setTime(parameter, x);
    }

    @Override
    public void setTime(int parameter, Time x) throws SQLException {
        if (x != null) {
            this.setTime(parameter, x.getTime());
        } else {
            this.setNull(parameter, 0);
        }
    }

    @Override
    public void setTimestamp(int parameter, Timestamp x, Calendar calendar) throws SQLException {
        this.setTimestamp(parameter, x);
    }

    @Override
    public void setTimestamp(int parameter, Timestamp x) throws SQLException {
        if (x != null) {
            this.setTime(parameter, x.getTime());
        } else {
            this.setNull(parameter, 0);
        }
    }

    private void setTime(int parameter, long now) throws SQLException {
        this.getQueryContext().setDate(parameter, now);
    }

    @Override
    public void setAsciiStream(int parameter, InputStream is, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUnicodeStream(int parameter, InputStream is, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameter, InputStream is, int len) throws SQLException {
        this.getQueryContext().setBinaryStream(parameter, is, len);
    }

    @Override
    public void setCharacterStream(int parameter, Reader is, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameter, Object x, int target, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameter, Object x, int target) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameter, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameter, (String)x);
        } else if (x instanceof Number) {
            Number number = (Number)x;
            if (x instanceof Double) {
                this.setDouble(parameter, number.doubleValue());
            } else if (x instanceof Float) {
                this.setDouble(parameter, number.doubleValue());
            } else {
                this.setLong(parameter, number.longValue());
            }
        } else if (x instanceof Time) {
            this.setTime(parameter, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameter, (Timestamp)x);
        } else if (x instanceof Date) {
            this.setDate(parameter, (Date)x);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setRef(int parameter, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameter, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameter, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArray(int parameter, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        if (this._wasResultSet) {
            return this._resultSet;
        }
        throw new SQLException("missing result set");
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean bl;
        block6: {
            QueryContext queryContext;
            Transaction xa;
            block4: {
                boolean bl2;
                block5: {
                    ++this._count;
                    xa = null;
                    try {
                        if (this._count != 1) {
                            throw new IllegalStateException("Multithreading execute");
                        }
                        xa = this._conn.getTransaction();
                        queryContext = this.getQueryContext();
                        if (!this._query.isSelect()) break block4;
                        this._query.execute(queryContext, xa);
                        this._wasResultSet = true;
                        this._resultSet = new ResultSetImpl(this, queryContext.getResult());
                        bl2 = true;
                        Object var5_5 = null;
                        --this._count;
                        if (xa == null || !xa.isAutoCommit()) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var5_7 = null;
                            --this._count;
                            if (xa == null || !xa.isAutoCommit()) break block7;
                            xa.rollback();
                        }
                        throw throwable;
                    }
                    xa.rollback();
                }
                return bl2;
            }
            queryContext.setReturnGeneratedKeys(this._isReturnGeneratedKeys);
            this._query.execute(queryContext, xa);
            this._wasResultSet = false;
            bl = false;
            Object var5_6 = null;
            --this._count;
            if (xa == null || !xa.isAutoCommit()) break block6;
            xa.rollback();
        }
        return bl;
    }

    @Override
    public void setURL(int foo, URL url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

