/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.GroupItem;
import com.caucho.db.sql.GroupResultExpr;
import com.caucho.db.sql.Order;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.Transaction;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectQuery
extends Query {
    private static final Logger log = Logger.getLogger(SelectQuery.class.getName());
    private Expr[] _results;
    private String[] _resultNames;
    private boolean[] _groupFields;
    private Order _order;
    private int _limit = 0x3FFFFFFF;

    SelectQuery(Database db, String sql) throws SQLException {
        super(db, sql);
    }

    SelectQuery(Database db, String sql, FromItem[] fromItems) throws SQLException {
        super(db, sql, fromItems);
    }

    void setResults(Expr[] resultExprs) throws SQLException {
        this._results = new Expr[resultExprs.length];
        for (int i = 0; i < resultExprs.length; ++i) {
            this._results[i] = resultExprs[i];
        }
        this.setDataFields(resultExprs.length);
    }

    Expr[] getResults() {
        return this._results;
    }

    public void setGroupResult(int index) {
        if (this._groupFields == null) {
            this._groupFields = new boolean[this._results.length];
        }
        this._groupFields[index] = true;
    }

    protected void bind() throws SQLException {
        int i;
        super.bind();
        for (i = 0; i < this._results.length; ++i) {
            this._results[i] = this._results[i].bind(this);
        }
        if (this.isGroup()) {
            for (i = 0; i < this._results.length; ++i) {
                if (!this.isGroup() || this._results[i] instanceof GroupExpr) continue;
                this._results[i] = new GroupResultExpr(i, this._results[i]);
            }
        }
        for (i = 0; i < this._results.length; ++i) {
            this._results[i] = this._results[i].bind(this);
        }
        this._resultNames = new String[this._results.length];
        for (i = 0; i < this._resultNames.length; ++i) {
            this._resultNames[i] = this._results[i].getName();
        }
    }

    void setOrder(Order order) {
        this._order = order;
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public boolean isSelect() {
        return true;
    }

    Class getType() {
        if (this._results.length == 1) {
            return this._results[0].getType();
        }
        return Object.class;
    }

    /*
     * Loose catch block
     */
    public void execute(QueryContext context, Transaction xa) throws SQLException {
        block12: {
            SelectResult result = SelectResult.create(this._results, this._order);
            FromItem[] fromItems = this.getFromItems();
            TableIterator[] rows = null;
            rows = result.initRows(fromItems);
            context.init(xa, rows, this.isReadOnly());
            if (this.isGroup()) {
                this.executeGroup(result, rows, context, xa);
            } else {
                this.execute(result, rows, context, xa);
            }
            result.initRead();
            context.setResult(result);
            Object var8_6 = null;
            try {
                context.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (rows != null) {
                this.freeRows(rows, rows.length);
            }
            break block12;
            {
                catch (IOException e) {
                    throw new SQLExceptionWrapper(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    context.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                if (rows != null) {
                    this.freeRows(rows, rows.length);
                }
                throw throwable;
            }
        }
    }

    private void execute(SelectResult result, TableIterator[] rows, QueryContext context, Transaction xa) throws SQLException, IOException {
        FromItem[] fromItems = this.getFromItems();
        int rowLength = fromItems.length;
        int limit = this._limit;
        int contextLimit = context.getLimit();
        if (contextLimit > 0) {
            limit = contextLimit;
        }
        if (this.start(rows, rowLength, context, xa)) {
            do {
                result.startRow();
                for (int i = 0; i < this._results.length; ++i) {
                    this._results[i].evalToResult(context, result);
                }
            } while (this.nextTuple(rows, rowLength, context, xa) && --limit > 0);
        }
    }

    private void executeGroup(SelectResult result, TableIterator[] rows, QueryContext context, Transaction transaction) throws SQLException, IOException {
        FromItem[] fromItems = this.getFromItems();
        int rowLength = fromItems.length;
        Expr[] results = this._results;
        int resultsLength = results.length;
        if (this._groupFields == null) {
            this._groupFields = new boolean[0];
        }
        boolean[] groupByFields = this._groupFields;
        int groupByLength = this._groupFields.length;
        if (this.start(rows, rowLength, context, transaction)) {
            do {
                int i;
                context.initGroup(this.getDataFields(), this._groupFields);
                for (i = 0; i < groupByLength; ++i) {
                    if (!groupByFields[i]) continue;
                    results[i].evalGroup(context);
                }
                context.selectGroup();
                for (i = 0; i < resultsLength; ++i) {
                    if (i < groupByLength && groupByFields[i]) continue;
                    results[i].evalGroup(context);
                }
            } while (this.nextTuple(rows, rowLength, context, transaction));
        }
        Iterator<GroupItem> groupIter = context.groupResults();
        while (groupIter.hasNext()) {
            GroupItem item = groupIter.next();
            context.setGroupItem(item);
            result.startRow();
            for (int i = 0; i < results.length; ++i) {
                results[i].evalToResult(context, result);
            }
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("SelectQuery[");
        cb.append("SELECT ");
        for (int i = 0; i < this._results.length; ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append(this._results[i]);
        }
        cb.append(" FROM ");
        FromItem[] fromItems = this.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append(fromItems[i]);
        }
        if (this._whereExpr != null) {
            cb.append(" WHERE " + this._whereExpr);
        }
        cb.append("]");
        return cb.close();
    }
}

