/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.BinaryKeyCompare;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.index.SqlIndexAlreadyExistsException;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.Transaction;
import com.caucho.util.L10N;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BinaryColumn
extends Column {
    private static final L10N L = new L10N(BinaryColumn.class);
    private final int _length;

    BinaryColumn(Row row, String name, int length) {
        super(row, name);
        if (length < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (255 < length) {
            throw new IllegalArgumentException("length too big");
        }
        this._length = length;
    }

    @Override
    public Column.ColumnType getTypeCode() {
        return Column.ColumnType.BINARY;
    }

    @Override
    public Class<?> getJavaType() {
        return String.class;
    }

    @Override
    public int getDeclarationSize() {
        return this._length;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public KeyCompare getIndexKeyCompare() {
        return new BinaryKeyCompare(this._length);
    }

    @Override
    void setString(Transaction xa, byte[] block, int rowOffset, String str) {
        int offset = rowOffset + this._columnOffset;
        if (str == null) {
            this.setNull(block, rowOffset);
            return;
        }
        int len = str.length();
        int maxOffset = offset + this._length;
        for (int i = 0; i < len && offset < maxOffset; ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0080') {
                block[offset++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                block[offset++] = (byte)(192 + (ch >> 6 & 0x1F));
                block[offset++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            block[offset++] = (byte)(224 + (ch >> 12 & 0xF));
            block[offset++] = (byte)(128 + (ch >> 6 & 0x3F));
            block[offset++] = (byte)(128 + (ch & 0x3F));
        }
        this.setNonNull(block, rowOffset);
    }

    @Override
    public String getString(long blockId, byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = this._length;
        char[] buffer = new char[len];
        int offset = startOffset;
        int endOffset = offset + len;
        int i = 0;
        while (offset < endOffset) {
            buffer[i++] = (char)(block[offset++] & 0xFF);
        }
        return new String(buffer, 0, len);
    }

    @Override
    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else {
            int len = this.getLength();
            for (int i = expr.evalToBuffer(context, block, rowOffset + this._columnOffset, this.getTypeCode()); i < len; ++i) {
                block[rowOffset + this._columnOffset + i] = 0;
            }
            this.setNonNull(block, rowOffset);
        }
    }

    @Override
    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int startOffset2 = rowOffset2 + this._columnOffset;
        for (int i = this._length - 1; i >= 0; --i) {
            if (block1[startOffset1 + i] == block2[startOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        if (this._length != length) {
            return false;
        }
        int blockOffset = startOffset;
        int endOffset = blockOffset + this._length;
        while (blockOffset < endOffset) {
            if (block[blockOffset++] == buffer[offset++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(byte[] block, int rowOffset, String value) {
        if (value == null) {
            return this.isNull(block, rowOffset);
        }
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int strLength = value.length();
        int strOffset = 0;
        int offset = startOffset;
        int endOffset = offset + this._length;
        while (offset < endOffset && strOffset < strLength) {
            char ch;
            int ch1;
            if ((ch1 = block[offset++] & 0xFF) == (ch = value.charAt(strOffset++))) continue;
            return false;
        }
        return offset == endOffset && strOffset == strLength;
    }

    @Override
    public void evalToResult(long blockId, byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        result.writeBinary(block, rowOffset + this._columnOffset, this.getLength());
    }

    @Override
    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        if (this.isNull(block, rowOffset)) {
            return 0;
        }
        int startOffset = rowOffset + this._columnOffset;
        System.arraycopy(block, startOffset, buffer, bufferOffset, this._length);
        return this._length;
    }

    @Override
    public void set(Transaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        byte[] buffer = iter.getBuffer();
        int rowOffset = iter.getRowOffset();
        int colOffset = this._columnOffset;
        if (expr.isNull(context)) {
            this.setNull(buffer, rowOffset);
            iter.setDirty();
            return;
        }
        int i = expr.evalToBuffer(context, buffer, rowOffset + this._columnOffset, this.getTypeCode());
        if (i >= 0) {
            int len = this.getLength();
            while (i < len) {
                buffer[i + rowOffset + colOffset] = 0;
                ++i;
            }
            this.setNonNull(buffer, rowOffset);
        } else {
            this.setNull(buffer, rowOffset);
        }
        iter.setDirty();
    }

    @Override
    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            try {
                index.insert(block, rowOffset + this._columnOffset, this.getLength(), rowAddr, false);
            }
            catch (SqlIndexAlreadyExistsException e) {
                throw new SqlIndexAlreadyExistsException(L.l("StringColumn '{0}.{1}' unique index set failed for {2}\n{3}", this.getTable().getName(), this.getName(), this.getDebugString(block, rowOffset), e.toString()), e);
            }
        }
    }

    @Override
    void deleteIndex(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, this.getLength());
        }
    }

    private String getDebugString(byte[] block, int rowOffset) {
        return this.getIndexKeyCompare().toString(block, rowOffset + this._columnOffset, this._length);
    }

    @Override
    public String toString() {
        if (this.getIndex() != null) {
            return "BinaryColumn[" + this.getName() + ",index]";
        }
        return "BinaryColumn[" + this.getName() + "]";
    }
}

