/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Row;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.Transaction;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class Column {
    private static final L10N L = new L10N(Column.class);
    private final Row _row;
    private final String _name;
    protected final int _columnOffset;
    protected final int _nullOffset;
    protected final byte _nullMask;
    private Table _table;
    private boolean _isPrimaryKey;
    private boolean _isUnique;
    private boolean _isNotNull;
    private int _autoIncrementMin = -1;
    private Expr _defaultExpr;
    private BTree _index;

    Column(Row row, String name) {
        this._row = row;
        this._name = name;
        this._columnOffset = this._row.getLength();
        this._nullOffset = this._row.getNullOffset();
        this._nullMask = this._row.getNullMask();
    }

    public String getName() {
        return this._name;
    }

    void setTable(Table table) {
        this._table = table;
    }

    public Table getTable() {
        return this._table;
    }

    int getColumnOffset() {
        return this._columnOffset;
    }

    public abstract ColumnType getTypeCode();

    public Class<?> getJavaType() {
        return Object.class;
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this._isPrimaryKey = primaryKey;
    }

    public boolean isUnique() {
        return this._isUnique;
    }

    public void setUnique() {
        this._isUnique = true;
    }

    public BTree getIndex() {
        return this._index;
    }

    public void setIndex(BTree index) {
        this._index = index;
    }

    public KeyCompare getIndexKeyCompare() {
        return null;
    }

    public void setNotNull() {
        this._isNotNull = true;
    }

    public boolean isNotNull() {
        return this._isNotNull;
    }

    public void setDefault(Expr expr) {
        this._defaultExpr = expr;
    }

    public Expr getDefault() {
        return this._defaultExpr;
    }

    public void setAutoIncrement(int min) {
        this._autoIncrementMin = min;
    }

    public int getAutoIncrement() {
        return this._autoIncrementMin;
    }

    public abstract int getDeclarationSize();

    abstract int getLength();

    public boolean isNull(byte[] block, int rowOffset) {
        return (block[rowOffset + this._nullOffset] & this._nullMask) == 0;
    }

    public final void setNull(byte[] block, int rowOffset) {
        int n = rowOffset + this._nullOffset;
        block[n] = (byte)(block[n] & ~this._nullMask);
    }

    protected final void setNonNull(byte[] block, int rowOffset) {
        int n = rowOffset + this._nullOffset;
        block[n] = (byte)(block[n] | this._nullMask);
    }

    public abstract String getString(long var1, byte[] var3, int var4) throws SQLException;

    abstract void setString(Transaction var1, byte[] var2, int var3, String var4) throws SQLException;

    public int getInteger(long blockId, byte[] block, int rowOffset) throws SQLException {
        String str = this.getString(blockId, block, rowOffset);
        if (str == null) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    void setInteger(Transaction xa, byte[] block, int rowOffset, int value) throws SQLException {
        this.setString(xa, block, rowOffset, String.valueOf(value));
    }

    public long getLong(long blockId, byte[] block, int rowOffset) throws SQLException {
        String str = this.getString(blockId, block, rowOffset);
        if (str == null) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    void setLong(Transaction xa, byte[] block, int rowOffset, long value) throws SQLException {
        this.setString(xa, block, rowOffset, String.valueOf(value));
    }

    public double getDouble(long blockId, byte[] block, int rowOffset) throws SQLException {
        String str = this.getString(blockId, block, rowOffset);
        if (str == null) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    void setDouble(Transaction xa, byte[] block, int rowOffset, double value) throws SQLException {
        this.setString(xa, block, rowOffset, String.valueOf(value));
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    public long getDate(byte[] block, int rowOffset) throws SQLException {
        throw new UnsupportedOperationException();
    }

    void setDate(Transaction xa, byte[] block, int rowOffset, long value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    int evalToBuffer(byte[] block, int rowOffset, byte[] buffer, int bufferOffset) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        return false;
    }

    public boolean isEqual(byte[] buffer1, int rowOffset1, byte[] buffer2, int rowOffset2) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(byte[] block, int rowOffset, String string) {
        return false;
    }

    public void evalToResult(long blockId, byte[] block, int rowOffset, SelectResult result) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void set(Transaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        this.setString(xa, iter.getBuffer(), iter.getRowOffset(), expr.evalString(context));
        iter.setDirty();
    }

    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index == null) {
            return;
        }
        index.insert(block, rowOffset + this.getColumnOffset(), this.getLength(), rowAddr, false);
    }

    void deleteIndex(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index == null) {
            return;
        }
        index.remove(block, rowOffset + this.getColumnOffset(), this.getLength());
    }

    void validateIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr) throws SQLException, IOException {
        BTree index = this.getIndex();
        if (index == null) {
            return;
        }
        long value = index.lookup(block, rowOffset + this.getColumnOffset(), this.getLength());
        if (value != rowAddr) {
            throw new IllegalStateException(L.l("invalid index '{0}' at {1}", (Object)value, Long.toHexString(rowAddr)));
        }
    }

    void deleteData(Transaction xa, byte[] block, int rowOffset) throws SQLException {
    }

    public void close() {
        BTree index = this._index;
        if (index != null) {
            index.close();
        }
    }

    public String toString() {
        if (this.getIndex() != null) {
            return this.getClass().getName() + "[" + this._name + ",index]";
        }
        return this.getClass().getName() + "[" + this._name + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Module
    public static enum ColumnType {
        NONE,
        VARCHAR,
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        DOUBLE,
        DATE,
        BLOB,
        NUMERIC,
        BINARY,
        VARBINARY,
        IDENTITY;

    }
}

