/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.config.ConfigException;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.util.L10N;

class Row {
    private static final L10N L = new L10N(Row.class);
    private static final int NULL_OFFSET = 2;
    private Table _table;
    private Column[] _columns = new Column[0];
    private int _rowLength = 1;
    private int _nullOffset = 0;

    Row() {
    }

    int getLength() {
        return this._rowLength;
    }

    int getNullOffset() {
        return this._nullOffset;
    }

    byte getNullMask() {
        return (byte)(1 << (this._columns.length + 2) % 8);
    }

    Column[] getColumns() {
        return this._columns;
    }

    Column getColumn(String name) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (!name.equals(this._columns[i].getName())) continue;
            return this._columns[i];
        }
        return null;
    }

    void allocateColumn() {
        if ((this._columns.length + 2) % 8 == 0) {
            this._nullOffset = this._rowLength++;
        }
    }

    Column addColumn(Column column) {
        Column[] newColumns = new Column[this._columns.length + 1];
        System.arraycopy(this._columns, 0, newColumns, 0, this._columns.length);
        this._columns = newColumns;
        this._columns[this._columns.length - 1] = column;
        this._rowLength += column.getLength();
        if (8192 <= this._rowLength) {
            throw new ConfigException(L.l("database row max length {0} exceeded at column {1}", (Object)8192, column.getName()));
        }
        return column;
    }

    public void close() {
        for (Column column : this._columns) {
            column.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._table + "]";
    }
}

