/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.Database;
import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.CreateQuery;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.Parser;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.NumericColumn;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableFactory;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.Transaction;
import com.caucho.env.thread.TaskWorker;
import com.caucho.inject.Module;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class Table
extends BlockStore {
    private static final Logger log = Logger.getLogger(Table.class.getName());
    private static final L10N L = new L10N(Table.class);
    private static final int ROOT_DATA_OFFSET = 1024;
    private static final int INDEX_ROOT_OFFSET = 1056;
    private static final int ROOT_DATA_END = 2048;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final long ROW_CLOCK_MIN = 1024L;
    public static final byte ROW_VALID = 1;
    public static final byte ROW_ALLOC = 2;
    public static final byte ROW_MASK = 3;
    private static final String DB_VERSION = "Resin-DB 4.0.6";
    private static final String MIN_VERSION = "Resin-DB 4.0.6";
    private final Row _row;
    private final int _rowLength;
    private final int _rowsPerBlock;
    private final int _rowEnd;
    private final Constraint[] _constraints;
    private final Column _autoIncrementColumn;
    private long _entries;
    private static final int FREE_ROW_BLOCK_SIZE = 256;
    private final AtomicLongArray _insertFreeRowBlockArray = new AtomicLongArray(256);
    private final AtomicInteger _insertFreeRowBlockHead = new AtomicInteger();
    private final AtomicInteger _insertFreeRowBlockTail = new AtomicInteger();
    private long _rowTailTop = 0x200000L;
    private final AtomicLong _rowTailOffset = new AtomicLong();
    private final RowAllocator _rowAllocator = new RowAllocator();
    private long _rowClockTop;
    private long _rowClockOffset;
    private long _clockRowFree;
    private long _clockRowUsed;
    private long _clockBlockFree;
    private long _autoIncrementValue = -1L;

    Table(Database database, String name, Row row, Constraint[] constraints) {
        super(database, name, null);
        this._row = row;
        this._constraints = constraints;
        this._rowLength = this._row.getLength();
        this._rowsPerBlock = 8192 / this._rowLength;
        this._rowEnd = this._rowLength * this._rowsPerBlock;
        Column[] columns = this._row.getColumns();
        Column autoIncrementColumn = null;
        for (int i = 0; i < columns.length; ++i) {
            columns[i].setTable(this);
            if (columns[i].getAutoIncrement() < 0) continue;
            autoIncrementColumn = columns[i];
        }
        this._autoIncrementColumn = autoIncrementColumn;
    }

    Row getRow() {
        return this._row;
    }

    public int getRowLength() {
        return this._rowLength;
    }

    int getRowEnd() {
        return this._rowEnd;
    }

    public final Column[] getColumns() {
        return this._row.getColumns();
    }

    public final Constraint[] getConstraints() {
        return this._constraints;
    }

    public Column getAutoIncrementColumn() {
        return this._autoIncrementColumn;
    }

    public Column getColumn(String name) {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return columns[i];
        }
        return null;
    }

    public int getColumnIndex(String name) throws SQLException {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Table loadFromFile(Database db, String name) throws IOException, SQLException {
        Throwable throwable3;
        Table table;
        int ch;
        Path path = db.getPath().lookup(name + ".db");
        if (!path.exists()) {
            if (!log.isLoggable(Level.FINE)) return null;
            log.fine(db + " '" + path.getNativePath() + "' is an unknown table");
            return null;
        }
        String version = null;
        ReadStream is = path.openRead();
        try {
            is.skip(9216L);
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) > 0) {
                sb.append((char)ch);
            }
            version = sb.toString();
            if (!version.startsWith("Resin-DB")) {
                throw new SQLException(L.l("table {0} is not a Resin DB.  Version '{1}'", (Object)name, version));
            }
            if (version.compareTo("Resin-DB 4.0.6") < 0 || "Resin-DB 4.0.6".compareTo(version) < 0) {
                throw new SQLException(L.l("table {0} is out of date.  Old version {1}.", (Object)name, version));
            }
            Object var8_7 = null;
            is.close();
        }
        catch (Throwable throwable2) {
            Object var8_8 = null;
            is.close();
            throw throwable2;
        }
        is = path.openRead();
        is.skip(10240L);
        StringBuilder cb = new StringBuilder();
        while ((ch = is.read()) > 0) {
            cb.append((char)ch);
        }
        String sql = cb.toString();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Table[" + name + "] " + version + " loading\n" + sql);
        }
        try {
            CreateQuery query = (CreateQuery)Parser.parse(db, sql);
            TableFactory factory = query.getFactory();
            if (!factory.getName().equalsIgnoreCase(name)) {
                throw new IOException(L.l("factory {0} does not match", name));
            }
            Table table2 = new Table(db, factory.getName(), factory.getRow(), factory.getConstraints());
            table2.init();
            table2.clearIndexes();
            table2.initIndexes();
            table2.rebuildIndexes();
            table = table2;
        }
        catch (Exception e) {
            try {
                log.log(Level.WARNING, e.toString(), e);
                throw new SQLException(L.l("can't load table {0} in {1}.\n{2}", name, path.getNativePath(), e.toString()));
            }
            catch (Throwable throwable3) {
                Object var13_16 = null;
                is.close();
            }
        }
        Object var13_15 = null;
        is.close();
        return table;
        throw throwable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws IOException, SQLException {
        super.create();
        this.initIndexes();
        byte[] tempBuffer = new byte[8192];
        this.getReadWrite().readBlock(8192L, tempBuffer, 0, 8192);
        TempStream ts = new TempStream();
        WriteStream os = new WriteStream(ts);
        try {
            for (int i = 0; i < 1024; ++i) {
                os.write(tempBuffer[i]);
            }
            this.writeTableHeader(os);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            os.close();
            throw throwable;
        }
        os.close();
        int offset = 0;
        for (TempBuffer head = ts.getHead(); head != null; head = head.getNext()) {
            int length;
            byte[] buffer = head.getBuffer();
            System.arraycopy(buffer, 0, tempBuffer, offset, length);
            for (length = head.getLength(); length < buffer.length; ++length) {
                tempBuffer[offset + length] = 0;
            }
            offset += buffer.length;
        }
        while (offset < 8192) {
            tempBuffer[offset] = 0;
            ++offset;
        }
        boolean isPriority = false;
        this.getReadWrite().writeBlock(8192L, tempBuffer, 0, 8192, isPriority);
        this._database.addTable(this);
    }

    private void initIndexes() throws IOException, SQLException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            KeyCompare keyCompare;
            Column column = columns[i];
            if (!column.isUnique() || (keyCompare = column.getIndexKeyCompare()) == null) continue;
            Block rootBlock = this.allocateIndexBlock();
            long rootBlockId = rootBlock.getBlockId();
            rootBlock.free();
            BTree btree = new BTree(this, rootBlockId, column.getLength(), keyCompare);
            column.setIndex(btree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void clearIndexes() throws IOException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Object var12_10;
            BTree index = columns[i].getIndex();
            if (index == null) continue;
            long rootAddr = index.getIndexRoot();
            Block block = this.readBlock(this.addressToBlockId(rootAddr));
            try {
                byte[] blockBuffer;
                byte[] byArray = blockBuffer = block.getBuffer();
                // MONITORENTER : blockBuffer
                for (int j = 0; j < blockBuffer.length; ++j) {
                    blockBuffer[j] = 0;
                }
                block.setDirty(0, 8192);
                // MONITOREXIT : byArray
                var12_10 = null;
                block.free();
                continue;
            }
            catch (Throwable throwable) {
                var12_10 = null;
                block.free();
                throw throwable;
            }
        }
        long blockAddr = 0L;
        while ((blockAddr = this.firstBlock(blockAddr + 8192L, 4)) > 0L) {
            this.freeBlock(blockAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndexes() throws IOException, SQLException {
        Transaction xa = Transaction.create();
        xa.setAutoCommit(true);
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(xa);
            Column[] columns = this._row.getColumns();
            while (iter.nextBlock()) {
                iter.initRow();
                byte[] blockBuffer = iter.getBuffer();
                while (iter.nextRow()) {
                    try {
                        long rowAddress = iter.getRowAddress();
                        int rowOffset = iter.getRowOffset();
                        for (int i = 0; i < columns.length; ++i) {
                            Column column = columns[i];
                            column.setIndex(xa, blockBuffer, rowOffset, rowAddress, null);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            xa.commit();
            throw throwable;
        }
        xa.commit();
    }

    public void validate() throws SQLException {
        try {
            this.validateIndexes();
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateIndexes() throws IOException, SQLException {
        Transaction xa = Transaction.create();
        xa.setAutoCommit(true);
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(xa);
            Column[] columns = this._row.getColumns();
            while (iter.nextBlock()) {
                iter.initRow();
                byte[] blockBuffer = iter.getBuffer();
                while (iter.nextRow()) {
                    try {
                        long rowAddress = iter.getRowAddress();
                        int rowOffset = iter.getRowOffset();
                        for (int i = 0; i < columns.length; ++i) {
                            Column column = columns[i];
                            column.validateIndex(xa, blockBuffer, rowOffset, rowAddress);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            xa.commit();
            throw throwable;
        }
        xa.commit();
    }

    private void writeTableHeader(WriteStream os) throws IOException {
        int i;
        os.print("Resin-DB 4.0.6");
        os.write(0);
        while (os.getPosition() < 1056L) {
            os.write(0);
        }
        Column[] columns = this._row.getColumns();
        for (i = 0; i < columns.length; ++i) {
            if (!columns[i].isUnique()) continue;
            BTree index = columns[i].getIndex();
            if (index != null) {
                this.writeLong(os, index.getIndexRoot());
                continue;
            }
            this.writeLong(os, 0L);
        }
        while (os.getPosition() < 2048L) {
            os.write(0);
        }
        os.print("CREATE TABLE " + this.getName() + "(");
        for (i = 0; i < this._row.getColumns().length; ++i) {
            Expr defaultExpr;
            Column column = this._row.getColumns()[i];
            if (i != 0) {
                os.print(",");
            }
            os.print(column.getName());
            os.print(" ");
            switch (column.getTypeCode()) {
                case IDENTITY: {
                    os.print("IDENTITY");
                    break;
                }
                case VARCHAR: {
                    os.print("VARCHAR(" + column.getDeclarationSize() + ")");
                    break;
                }
                case VARBINARY: {
                    os.print("VARBINARY(" + column.getDeclarationSize() + ")");
                    break;
                }
                case BINARY: {
                    os.print("BINARY(" + column.getDeclarationSize() + ")");
                    break;
                }
                case SHORT: {
                    os.print("SMALLINT");
                    break;
                }
                case INT: {
                    os.print("INTEGER");
                    break;
                }
                case LONG: {
                    os.print("BIGINT");
                    break;
                }
                case DOUBLE: {
                    os.print("DOUBLE");
                    break;
                }
                case DATE: {
                    os.print("TIMESTAMP");
                    break;
                }
                case BLOB: {
                    os.print("BLOB");
                    break;
                }
                case NUMERIC: {
                    NumericColumn numeric = (NumericColumn)column;
                    os.print("NUMERIC(" + numeric.getPrecision() + "," + numeric.getScale() + ")");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf(column));
                }
            }
            if (column.isPrimaryKey()) {
                os.print(" PRIMARY KEY");
            } else if (column.isUnique()) {
                os.print(" UNIQUE");
            }
            if (column.isNotNull()) {
                os.print(" NOT NULL");
            }
            if ((defaultExpr = column.getDefault()) != null) {
                os.print(" DEFAULT (");
                os.print(defaultExpr);
                os.print(")");
            }
            if (column.getAutoIncrement() < 0) continue;
            os.print(" auto_increment");
        }
        os.print(")");
    }

    public TableIterator createTableIterator() {
        this.assertStoreActive();
        return new TableIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextAutoIncrement(QueryContext context) throws SQLException {
        Table table = this;
        synchronized (table) {
            if (this._autoIncrementValue >= 0L) {
                return ++this._autoIncrementValue;
            }
        }
        long max = 0L;
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(context);
            while (iter.next()) {
                byte[] buffer = iter.getBuffer();
                long blockId = iter.getBlockId();
                long value = this._autoIncrementColumn.getLong(blockId, buffer, iter.getRowOffset());
                if (max >= value) continue;
                max = value;
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        Table table2 = this;
        synchronized (table2) {
            if (this._autoIncrementValue < max) {
                this._autoIncrementValue = max;
            }
            return ++this._autoIncrementValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insert(QueryContext queryContext, Transaction xa, ArrayList<Column> columns, ArrayList<Expr> values) throws IOException, SQLException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("db table " + this.getName() + " insert row xa:" + xa);
        }
        Block block = null;
        try {
            try {}
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (block == null) throw throwable;
            block.free();
            throw throwable;
        }
        while (true) {
            long blockId;
            int rowOffset;
            if ((rowOffset = this.allocateRow(block = xa.loadBlock(this, blockId = this.allocateInsertRowBlock()), xa)) >= 0) {
                this.insertRow(queryContext, xa, columns, values, block, rowOffset);
                block.saveAllocation();
                this.freeRowBlockId(blockId);
                long l = Table.blockIdToAddress(blockId, rowOffset);
                Object var12_11 = null;
                if (block == null) return l;
                block.free();
                return l;
            }
            Block freeBlock = block;
            block = null;
            freeBlock.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int allocateRow(Block block, Transaction xa) throws IOException, SQLException, InterruptedException {
        Lock blockLock = block.getWriteLock();
        blockLock.tryLock(xa.getTimeout(), TimeUnit.MILLISECONDS);
        try {
            block.read();
            byte[] buffer = block.getBuffer();
            int rowOffset = 0;
            while (true) {
                if (rowOffset >= this._rowEnd) {
                    Object var8_8 = null;
                    blockLock.unlock();
                    return -1;
                }
                if (buffer[rowOffset] == 0) {
                    buffer[rowOffset] = 2;
                    block.setDirty(rowOffset, rowOffset + 1);
                    int n = rowOffset;
                    Object var8_7 = null;
                    blockLock.unlock();
                    return n;
                }
                rowOffset += this._rowLength;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            blockLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertRow(QueryContext queryContext, Transaction xa, ArrayList<Column> columns, ArrayList<Expr> values, Block block, int rowOffset) throws SQLException {
        byte[] buffer = block.getBuffer();
        long rowAddr = Table.blockIdToAddress(block.getBlockId(), rowOffset);
        TableIterator iter = this.createTableIterator();
        TableIterator[] iterSet = new TableIterator[]{iter};
        boolean isReadOnly = false;
        queryContext.init(xa, iterSet, isReadOnly);
        iter.init(queryContext);
        boolean isOkay = false;
        queryContext.lock();
        try {
            block14: {
                Column column;
                int i;
                iter.setRow(block, rowOffset);
                if (buffer[rowOffset] != 2) {
                    throw new IllegalStateException(L.l("Expected ROW_ALLOC at '{0}'", buffer[rowOffset]));
                }
                for (i = rowOffset + this._rowLength - 1; rowOffset < i; --i) {
                    buffer[i] = 0;
                }
                for (i = 0; i < columns.size(); ++i) {
                    column = columns.get(i);
                    Expr value = values.get(i);
                    column.setExpr(xa, buffer, rowOffset, value, queryContext);
                }
                try {
                    this.validate(block, rowOffset, queryContext, xa);
                    for (i = 0; i < columns.size(); ++i) {
                        column = columns.get(i);
                        column.setIndex(xa, buffer, rowOffset, rowAddr, queryContext);
                    }
                    buffer[rowOffset] = (byte)(buffer[rowOffset] & 0xFFFFFFFC | 1);
                    xa.addUpdateBlock(block);
                    if (this._autoIncrementColumn != null) {
                        long blockId = iter.getBlockId();
                        long value = this._autoIncrementColumn.getLong(blockId, buffer, rowOffset);
                        Table table = this;
                        synchronized (table) {
                            if (this._autoIncrementValue < value) {
                                this._autoIncrementValue = value;
                            }
                        }
                    }
                    block.setDirty(rowOffset, rowOffset + this._rowLength);
                    ++this._entries;
                    isOkay = true;
                    Object var21_20 = null;
                    if (isOkay) break block14;
                }
                catch (Throwable throwable) {
                    Object var21_21 = null;
                    if (isOkay) throw throwable;
                    this.delete(xa, block, buffer, rowOffset, false);
                    block.setDirty(rowOffset, rowOffset + this._rowLength);
                    throw throwable;
                }
                this.delete(xa, block, buffer, rowOffset, false);
                block.setDirty(rowOffset, rowOffset + this._rowLength);
            }
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            queryContext.unlock();
            throw throwable;
        }
        queryContext.unlock();
    }

    private long allocateInsertRowBlock() throws IOException {
        long blockId = this.allocateRowBlockId();
        if (blockId != 0L) {
            return blockId;
        }
        long rowTailOffset = this._rowTailOffset.get();
        blockId = this.firstRowBlock(rowTailOffset);
        if (blockId <= 0L) {
            Block block = this.allocateRow();
            blockId = block.getBlockId();
            block.free();
        }
        this._rowTailOffset.compareAndSet(rowTailOffset, blockId + 8192L);
        return blockId;
    }

    private void fillFreeRows() {
        if (this._rowTailOffset.get() < this._rowTailTop) {
            return;
        }
        while (this.scanClock()) {
            if (this.resetClock()) continue;
            return;
        }
    }

    private boolean resetClock() {
        long newRowCount = (this._clockRowUsed - this._clockRowFree) / (long)this._rowsPerBlock;
        if (this._clockRowFree < 1024L && this._rowClockOffset > 0L) {
            newRowCount = 1024L;
        }
        if (newRowCount > 0L) {
            this._rowTailTop = this._rowTailOffset.get() + newRowCount * (long)this._rowLength;
        }
        this._rowClockOffset = 0L;
        this._rowClockTop = this._rowTailOffset.get();
        this._clockRowUsed = 0L;
        this._clockRowFree = 0L;
        return newRowCount <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanClock() {
        while (this.isFreeRowBlockIdAvailable()) {
            Object var5_4;
            long clockBlockId;
            block6: {
                clockBlockId = this._rowClockOffset;
                clockBlockId = this.firstRowBlock(clockBlockId);
                if (clockBlockId >= 0L) break block6;
                this._rowClockOffset = this._rowClockTop;
                boolean bl = true;
                var5_4 = null;
                this._rowClockOffset = clockBlockId + 8192L;
                return bl;
            }
            try {
                block7: {
                    try {
                        if (!this.isRowBlockFree(clockBlockId)) break block7;
                        ++this._clockBlockFree;
                        this.freeRowBlockId(clockBlockId);
                    }
                    catch (IOException e) {
                        log.log(Level.FINE, e.toString(), e);
                        clockBlockId = this._rowClockTop;
                        var5_4 = null;
                        this._rowClockOffset = clockBlockId + 8192L;
                        continue;
                    }
                }
                var5_4 = null;
                this._rowClockOffset = clockBlockId + 8192L;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this._rowClockOffset = clockBlockId + 8192L;
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRowBlockFree(long blockId) throws IOException {
        Block block = this.readBlock(blockId);
        try {
            byte[] buffer = block.getBuffer();
            boolean isFree = false;
            for (int rowOffset = 0; rowOffset < this._rowEnd; rowOffset += this._rowLength) {
                if (buffer[rowOffset] == 0) {
                    isFree = true;
                    ++this._clockRowFree;
                    continue;
                }
                ++this._clockRowUsed;
            }
            boolean bl = isFree;
            Object var9_7 = null;
            block.free();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            block.free();
            throw throwable;
        }
    }

    private boolean isFreeRowBlockIdAvailable() {
        int tail;
        int head = this._insertFreeRowBlockHead.get();
        return (head + 1) % 256 != (tail = this._insertFreeRowBlockTail.get());
    }

    private long allocateRowBlockId() {
        int head;
        int tail;
        long blockId;
        do {
            tail = this._insertFreeRowBlockTail.get();
            head = this._insertFreeRowBlockHead.get();
            if (head == tail) {
                this._rowAllocator.wake();
                return 0L;
            }
            blockId = this._insertFreeRowBlockArray.getAndSet(tail, 0L);
            int nextTail = (tail + 1) % 256;
            this._insertFreeRowBlockTail.compareAndSet(tail, nextTail);
        } while (blockId <= 0L);
        int size = (head - tail + 256) % 256;
        if (2 * size < 256) {
            this._rowAllocator.wake();
        }
        return blockId;
    }

    private void freeRowBlockId(long blockId) {
        int head;
        do {
            int tail;
            int nextHead;
            if ((nextHead = ((head = this._insertFreeRowBlockHead.get()) + 1) % 256) == (tail = this._insertFreeRowBlockTail.get())) {
                return;
            }
            this._insertFreeRowBlockHead.compareAndSet(head, nextHead);
        } while (!this._insertFreeRowBlockArray.compareAndSet(head, 0L, blockId));
    }

    private void validate(Block block, int rowOffset, QueryContext queryContext, Transaction xa) throws SQLException {
        TableIterator row = this.createTableIterator();
        TableIterator[] rows = new TableIterator[]{row};
        row.setRow(block, rowOffset);
        for (int i = 0; i < this._constraints.length; ++i) {
            this._constraints[i].validate(rows, queryContext, xa);
        }
    }

    void delete(Transaction xa, Block block, byte[] buffer, int rowOffset, boolean isDeleteIndex) throws SQLException {
        int i;
        byte rowState = buffer[rowOffset];
        buffer[rowOffset] = (byte)(rowState & 0xFFFFFFFC | 2);
        Column[] columns = this._row.getColumns();
        for (i = 0; i < columns.length; ++i) {
            columns[i].deleteData(xa, buffer, rowOffset);
        }
        if (isDeleteIndex) {
            for (i = 0; i < columns.length; ++i) {
                try {
                    columns[i].deleteIndex(xa, buffer, rowOffset);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        buffer[rowOffset] = 0;
    }

    @Override
    public void close() {
        this._row.close();
        super.close();
        this._rowAllocator.destroy();
    }

    private void writeLong(WriteStream os, long value) throws IOException {
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    @Override
    public String toString() {
        int id = Alarm.isTest() ? 1 : this.getId();
        return this.getClass().getSimpleName() + "[" + this.getName() + ":" + id + "]";
    }

    class RowAllocator
    extends TaskWorker {
        RowAllocator() {
        }

        public long runTask() {
            Table.this.fillFreeRows();
            return -1L;
        }
    }
}

