/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Period;
import com.caucho.distcache.ByteStreamCache;
import com.caucho.distcache.CacheManager;
import com.caucho.distcache.CacheSerializer;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.distcache.ObjectCache;
import com.caucho.env.distcache.DistCacheService;
import com.caucho.loader.Environment;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.DistributedCacheManager;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.cache.CacheEntry;
import javax.cache.CacheListener;
import javax.cache.CacheLoader;
import javax.cache.CacheStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache
extends AbstractMap
implements ObjectCache,
ByteStreamCache,
CacheStatistics,
Closeable {
    private static final L10N L = new L10N(AbstractCache.class);
    private static final Logger log = Logger.getLogger(AbstractCache.class.getName());
    private CacheManager _localManager;
    private DistributedCacheManager _manager;
    private String _name = null;
    private String _guid;
    private Collection<CacheListener<?>> _listeners = new ConcurrentLinkedQueue();
    private CacheConfig _config = new CacheConfig();
    private LruCache<Object, DistCacheEntry> _entryCache;
    private boolean _isInit;
    private boolean _isClosed;
    private long _priorMisses = 0L;
    private long _priorHits = 0L;
    private String _scopeName = Scope.CLUSTER.toString();
    private String _persistenceOption = Persistence.TRIPLE.toString();

    public String getName() {
        return this._name;
    }

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    public void setGuid(String guid) {
        this._guid = guid;
    }

    @Configurable
    public void setCacheLoader(CacheLoader loader) {
        this._config.setCacheLoader(loader);
    }

    @Configurable
    public void setSerializer(CacheSerializer serializer) {
        this._config.setValueSerializer(serializer);
    }

    @Configurable
    public void setBackup(boolean isBackup) {
        this._config.setBackup(isBackup);
    }

    @Configurable
    public void setGlobal(boolean isGlobal) {
        this._config.setGlobal(isGlobal);
    }

    @Configurable
    public void setTriplicate(boolean isTriplicate) {
        this._config.setTriplicate(isTriplicate);
    }

    public long getExpireTimeout() {
        return this._config.getExpireTimeout();
    }

    @Configurable
    public void setExpireTimeout(Period expireTimeout) {
        this.setExpireTimeoutMillis(expireTimeout.getPeriod());
    }

    @Configurable
    public void setExpireTimeoutMillis(long expireTimeout) {
        this._config.setExpireTimeout(expireTimeout);
    }

    @Configurable
    public void setIdleTimeout(Period period) {
        this.setIdleTimeoutMillis(period.getPeriod());
    }

    public long getIdleTimeout() {
        return this._config.getIdleTimeout();
    }

    @Configurable
    public void setIdleTimeoutMillis(long timeout) {
        this._config.setIdleTimeout(timeout);
    }

    public long getIdleTimeoutWindow() {
        return this._config.getIdleTimeoutWindow();
    }

    public void setIdleTimeoutWindow(Period period) {
        this._config.setIdleTimeoutWindow(period.getPeriod());
    }

    public long getLeaseTimeout() {
        return this._config.getLeaseTimeout();
    }

    @Configurable
    public void setLeaseTimeout(Period period) {
        this.setLeaseTimeoutMillis(period.getPeriod());
    }

    @Configurable
    public void setLeaseTimeoutMillis(long timeout) {
        this._config.setLeaseTimeout(timeout);
    }

    public long getLocalReadTimeout() {
        return this._config.getLocalReadTimeout();
    }

    @Configurable
    public void setLocalReadTimeout(Period period) {
        this.setLocalReadTimeoutMillis(period.getPeriod());
    }

    @Configurable
    public void setLocalReadTimeoutMillis(long period) {
        this._config.setLocalReadTimeout(period);
    }

    public void setScopeMode(Scope scope) {
        this._config.setScopeMode(scope);
    }

    @Configurable
    public void setScope(String scopeName) {
        this._scopeName = scopeName;
    }

    public String getScope() {
        return this._config.getScopeMode().toString().toLowerCase();
    }

    public void setPersistence(String persistenceOption) {
        this._persistenceOption = persistenceOption;
    }

    protected void setCacheManager(CacheManager cacheManager) {
        this._localManager = cacheManager;
    }

    public static AbstractCache getMatchingCache(String name) {
        DistCacheService cacheService = DistCacheService.getCurrent();
        CacheManager localManager = cacheService.getCacheManager();
        String contextId = Environment.getEnvironmentName();
        String guid = contextId + ":" + name;
        return localManager.get(guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        AbstractCache abstractCache = this;
        synchronized (abstractCache) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            this._config.init();
            this.initServer();
            this.initName(this._name);
            this.initScope(this._scopeName);
            this.initPersistence(this._persistenceOption);
            this._config.setCacheKey(this._manager.createSelfHashKey(this._config.getGuid(), this._config.getKeySerializer()));
            if (this._localManager == null) {
                DistCacheService cacheService = DistCacheService.getCurrent();
                this._localManager = cacheService.getCacheManager();
            }
            if (this._localManager.putIfAbsent(this._guid, this) != null) {
                throw new ConfigException(L.l("'{0}' with full name '{1}' is an invalid Cache name because it's already used by another cache.", (Object)this, this._guid));
            }
            this._entryCache = new LruCache(512);
            Environment.addCloseListener(this);
        }
    }

    public Object peek(Object key) {
        DistCacheEntry cacheEntry = this._entryCache.get(key);
        return cacheEntry != null ? cacheEntry.peek() : null;
    }

    @Override
    public Object get(Object key) {
        return this.getDistCacheEntry(key).get(this._config);
    }

    @Override
    public Object getLazy(Object key) {
        return this.getDistCacheEntry(key).getLazy(this._config);
    }

    @Override
    public boolean get(Object key, OutputStream os) throws IOException {
        return this.getDistCacheEntry(key).getStream(os, this._config);
    }

    @Override
    public ExtCacheEntry getExtCacheEntry(Object key) {
        return this.getDistCacheEntry(key).getMnodeValue(this._config);
    }

    @Override
    public ExtCacheEntry peekExtCacheEntry(Object key) {
        return this.getDistCacheEntry(key).getMnodeValue();
    }

    public CacheEntry getCacheEntry(Object key) {
        return this.getExtCacheEntry(key);
    }

    @Override
    public Object put(Object key, Object value) {
        Object object = this.getDistCacheEntry(key).put(value, this._config);
        this.notifyPut(key);
        return object;
    }

    @Override
    public ExtCacheEntry put(Object key, InputStream is, long idleTimeout) throws IOException {
        return this.getDistCacheEntry(key).put(is, this._config, idleTimeout);
    }

    @Override
    public boolean compareAndPut(Object key, long version, Object value) {
        this.put(key, value);
        return true;
    }

    @Override
    public boolean compareAndPut(Object key, long version, InputStream inputStream) throws IOException {
        this.put(key, inputStream);
        return true;
    }

    @Override
    public Object remove(Object key) {
        this.notifyRemove(key);
        return this.getDistCacheEntry(key).remove(this._config);
    }

    @Override
    public boolean compareAndRemove(Object key, long version) {
        DistCacheEntry cacheEntry = this.getDistCacheEntry(key);
        if (cacheEntry.getVersion() == version) {
            this.remove(key);
            return true;
        }
        return false;
    }

    protected DistCacheEntry getDistCacheEntry(Object key) {
        DistCacheEntry cacheEntry = this._entryCache.get(key);
        if (cacheEntry == null) {
            cacheEntry = this._manager.getCacheEntry(key, this._config);
            this._entryCache.put(key, cacheEntry);
        }
        return cacheEntry;
    }

    @Override
    public Set<Map.Entry> entrySet() {
        return new CacheEntrySet<Map.Entry>(this._entryCache);
    }

    public Map getAll(Collection keys) {
        HashMap result = new HashMap();
        for (Object key : keys) {
            Object value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public void load(Object key) {
        if (this.containsKey(key) || this.get(key) != null) {
            return;
        }
        Object loaderValue = this.cacheLoader(key);
        if (loaderValue != null) {
            this.put(key, loaderValue);
        }
        this.notifyLoad(key);
    }

    public void loadAll(Collection keys) {
        Map entries = null;
        CacheLoader loader = this._config.getCacheLoader();
        if (loader == null || keys == null || keys.size() == 0) {
            return;
        }
        entries = loader.loadAll(keys);
        if (entries.isEmpty()) {
            return;
        }
        for (Map.Entry loaderEntry : entries.entrySet()) {
            Object loaderKey = loaderEntry.getKey();
            if (this.containsKey(loaderKey) || this.get(loaderKey) == null) continue;
            this.put(loaderKey, loaderEntry.getValue());
            this.notifyLoad(loaderKey);
        }
    }

    public void addListener(CacheListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(CacheListener listener) {
        this._listeners.remove(listener);
    }

    public CacheStatistics getCacheStatistics() {
        return this;
    }

    public void evict() {
        this.notifyEvict(null);
    }

    @Override
    public Collection values() {
        return new CacheValues<Object, DistCacheEntry>(this._entryCache);
    }

    @Override
    public Set keySet() {
        return new CacheKeys(this._entryCache);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Collection values = this.values();
        for (Object item : values) {
            if (!value.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._entryCache.clear();
        this.notifyClear(null);
    }

    @Override
    public int size() {
        return this._entryCache.size();
    }

    @Override
    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Set entries = map.entrySet();
        Iterator i$ = entries.iterator();
        while (i$.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = i$.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this._entryCache.get(key) != null;
    }

    @Override
    public boolean isEmpty() {
        return this._entryCache.size() == 0;
    }

    public int getCacheHits() {
        return (int)(this._entryCache.getHitCount() - this._priorHits);
    }

    public int getCacheMisses() {
        return (int)(this._entryCache.getMissCount() - this._priorMisses);
    }

    public int getObjectCount() {
        return this._entryCache.size();
    }

    public void clearStatistics() {
        this._priorHits = this._entryCache.getHitCount();
        this._priorMisses = this._entryCache.getMissCount();
    }

    public int getStatisticsAccuracy() {
        return 1;
    }

    public boolean isBackup() {
        return this._config.isBackup();
    }

    public boolean isTriplicate() {
        return this._config.isTriplicate();
    }

    protected Object cacheLoader(Object key) {
        Object value = this.get(key);
        if (value != null) {
            return value;
        }
        CacheLoader loader = this._config.getCacheLoader();
        Object object = value = loader != null ? loader.load(key) : null;
        if (value != null) {
            this.put(key, value);
        }
        this.notifyLoad(key);
        return value;
    }

    protected void setPersistenceMode(Persistence persistence) {
        switch (persistence) {
            case NONE: {
                this.setTriplicate(false);
                this.setBackup(false);
                break;
            }
            case SINGLE: {
                this.setTriplicate(false);
                this.setBackup(true);
                break;
            }
            default: {
                this.setTriplicate(true);
            }
        }
    }

    protected void notifyLoad(Object key) {
        for (CacheListener<?> listener : this._listeners) {
            listener.onLoad(key);
        }
    }

    protected void notifyEvict(Object key) {
        for (CacheListener<?> listener : this._listeners) {
            listener.onEvict(key);
        }
    }

    protected void notifyClear(Object key) {
        for (CacheListener<?> listener : this._listeners) {
            listener.onClear(key);
        }
    }

    protected void notifyPut(Object key) {
        for (CacheListener<?> listener : this._listeners) {
            listener.onPut(key);
        }
    }

    protected void notifyRemove(Object key) {
        for (CacheListener<?> listener : this._listeners) {
            listener.onRemove(key);
        }
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public void close() {
        this._isClosed = true;
        this._localManager.remove(this._guid);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._guid + "]";
    }

    private void initName(String name) throws ConfigException {
        if (this._name == null || this._name.length() == 0) {
            throw new ConfigException(L.l("Each Cache must have a name."));
        }
        String contextId = Environment.getEnvironmentName();
        if (this._guid == null) {
            this._guid = contextId + ":" + this._name;
        }
        this._config.setGuid(this._guid);
    }

    private void initPersistence(String persistence) throws ConfigException {
        Persistence result = Persistence.TRIPLE;
        if (persistence != null) {
            try {
                result = Persistence.valueOf(persistence.toUpperCase());
            }
            catch (Exception e) {
                throw new ConfigException(L.l("'{0}' is not a valid Persistence option", persistence));
            }
        }
        this.setPersistenceMode(result);
    }

    private void initScope(String scopeName) throws ConfigException {
        Scope scope = null;
        if (this._scopeName != null) {
            try {
                scope = Scope.valueOf(this._scopeName.toUpperCase());
            }
            catch (Exception e) {
                throw new ConfigException(L.l("'{0}' is not a valid Scope option", scopeName));
            }
        }
        this.setScopeMode(scope);
    }

    protected void setManager(DistributedCacheManager manager) {
        this._manager = manager;
    }

    private void initServer() throws ConfigException {
        if (this._manager != null) {
            return;
        }
        DistCacheService cacheService = DistCacheService.getCurrent();
        if (cacheService == null) {
            throw new ConfigException(L.l("'{0}' cannot be initialized because it is not in a clustered environment", this.getClass().getSimpleName()));
        }
        this._manager = cacheService.getDistCacheManager();
        if (this._manager == null) {
            throw new IllegalStateException("distributed cache manager not available");
        }
    }

    protected static class CacheKeys
    extends CacheEntrySet {
        private LruCache _lruCache;

        public CacheKeys(LruCache cache) {
            super(cache);
            this._lruCache = cache;
        }

        public Iterator iterator() {
            return new CacheEntrySetIterator<Object, Object>(this._lruCache){

                @Override
                public Object next() {
                    return ((Map.Entry)super.next()).getKey();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheValues<K, V>
    extends CacheEntrySet {
        private LruCache<K, V> _lruCache;

        public CacheValues(LruCache<K, V> lruCache) {
            super(lruCache);
            this._lruCache = lruCache;
        }

        @Override
        public Iterator iterator() {
            return new CacheEntrySetIterator<K, V>(this._lruCache){

                @Override
                public Object next() {
                    return ((Map.Entry)super.next()).getValue();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheEntrySetIterator<K, V>
    implements Iterator {
        private Iterator<LruCache.Entry<K, V>> _iterator;

        protected CacheEntrySetIterator(LruCache<K, V> lruCache) {
            this._iterator = lruCache.iterator();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LruCache.Entry<K, V> entry = this._iterator.next();
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            return new AbstractMap.SimpleEntry<Object, Object>(cacheEntry.getKey(), cacheEntry.getValue());
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheEntrySet<E>
    extends AbstractSet {
        private LruCache<Object, CacheEntry> _lruCache;

        protected CacheEntrySet(LruCache cache) {
            this._lruCache = cache;
        }

        @Override
        public Iterator iterator() {
            return new CacheEntrySetIterator<Object, CacheEntry>(this._lruCache);
        }

        @Override
        public int size() {
            return this._lruCache.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Persistence {
        NONE,
        SINGLE,
        TRIPLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        LOCAL,
        SERVER,
        POD,
        CLUSTER,
        GLOBAL;

    }
}

