/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.JndiBuilder;
import com.caucho.config.types.Period;
import com.caucho.ejb.manager.EjbEnvironmentListener;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.env.jpa.ListenerPersistenceEnvironment;
import com.caucho.env.jpa.PersistenceManager;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class EJBServer
implements EnvironmentBean {
    static final L10N L = new L10N(EJBServer.class);
    protected static final Logger log = Logger.getLogger(EJBServer.class.getName());
    private static EnvironmentLocal<EJBServer> _localServer = new EnvironmentLocal("caucho.ejb-server");
    protected static EnvironmentLocal<String> _localURL = new EnvironmentLocal("caucho.url");
    private EjbManager _ejbContainer;
    private AmberContainer _amberContainer;
    private String _entityManagerJndiName = "java:comp/EntityManager";
    private ArrayList<Path> _ejbJars = new ArrayList();
    private MergePath _mergePath;
    private String _urlPrefix;
    private ArrayList<FileSetType> _configFileSetList = new ArrayList();
    private ContainerProgram _jpaProgram = new ContainerProgram();
    private boolean _validateDatabaseSchema = true;
    private String _resinIsolation;
    private String _jdbcIsolation;
    private ConnectionFactory _jmsConnectionFactory;
    private Path _configDirectory;
    private boolean _forbidJVMCall;
    private boolean _autoCompile = true;
    private boolean _isAllowPOJO = false;
    private String _startupMode;
    private long _transactionTimeout = 0L;

    public EJBServer() throws ConfigException {
        this._ejbContainer = EjbManager.create();
        this._urlPrefix = _localURL.get();
        this._mergePath = new MergePath();
        this._mergePath.addMergePath(Vfs.lookup());
        this._mergePath.addClassPath();
    }

    public void addJarUrls(EnvironmentClassLoader loader, Path root) throws IOException {
        Iterator<String> it = root.iterator();
        while (it.hasNext()) {
            String s = it.next();
            Path path = root.lookup(s);
            if (path.isDirectory()) {
                this.addJarUrls(loader, path);
                continue;
            }
            if (!s.endsWith(".jar")) continue;
            JarPath jarPath = JarPath.create(path);
            loader.addURL(jarPath);
        }
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._ejbContainer.getClassLoader();
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader env) {
    }

    public void setName(String name) {
        this.setJndiName(name);
    }

    public void setJndiName(String name) {
        this.setJndiPrefix(name);
    }

    public void setJndiPrefix(String name) {
        this._ejbContainer.getProtocolManager().setJndiPrefix(name);
    }

    public void setJndiLocalPrefix(String name) {
        this._ejbContainer.getProtocolManager().setLocalJndiPrefix(name);
    }

    public void setJndiRemotePrefix(String name) {
        this._ejbContainer.getProtocolManager().setRemoteJndiPrefix(name);
    }

    public void setEntityManagerJndiName(String name) {
        this._entityManagerJndiName = name;
    }

    public String getEntityManagerJndiName() {
        return this._entityManagerJndiName;
    }

    public void setURLPrefix(String urlPrefix) {
        this._urlPrefix = urlPrefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setConfigDirectory(Path path) {
    }

    public void addEJBJar(Path ejbJar) throws ConfigException {
        if (!ejbJar.canRead() || !ejbJar.isFile()) {
            throw new ConfigException(L.l("<ejb-jar> {0} must refer to a valid jar file.", ejbJar.getURL()));
        }
        if (this._ejbJars.contains(ejbJar)) {
            log.fine("EJBServer.addEJBJar already added: " + ejbJar);
            return;
        }
        this._ejbJars.add(ejbJar);
    }

    public void setDataSource(DataSource dataSource) throws ConfigException {
        if (dataSource == null) {
            throw new ConfigException(L.l("<ejb-server> data-source must be a valid DataSource."));
        }
        this._jpaProgram.addProgram(new PropertyValueProgram("jta-data-source-value", dataSource));
    }

    public void setReadDataSource(DataSource dataSource) throws ConfigException {
        if (dataSource == null) {
            throw new ConfigException(L.l("<ejb-server> data-source must be a valid DataSource."));
        }
        this._jpaProgram.addProgram(new PropertyValueProgram("non-jta-data-source-value", dataSource));
    }

    public void setXADataSource(DataSource dataSource) throws ConfigException {
        this.setDataSource(dataSource);
    }

    public void setCreateDatabaseSchema(boolean create) {
    }

    public boolean getCreateDatabaseSchema() {
        return false;
    }

    public void setValidateDatabaseSchema(boolean validate) {
        log.config("validate-database-schema is no longer valid");
    }

    public boolean getValidateDatabaseSchema() {
        log.config("validate-database-schema is no longer valid");
        return true;
    }

    public void setLoadLazyOnTransaction(boolean isLazy) {
    }

    public void setJMSConnectionFactory(JndiBuilder factory) throws ConfigException, NamingException {
        Object obj = factory.getObject();
        if (!(obj instanceof ConnectionFactory)) {
            throw new ConfigException(L.l("'{0}' must be a JMS ConnectionFactory.", obj));
        }
        this._ejbContainer.setJmsConnectionFactory((ConnectionFactory)obj);
    }

    public ConnectionFactory getConnectionFactory() {
        return this._jmsConnectionFactory;
    }

    public void setMessageConsumerMax(int consumerMax) throws ConfigException, NamingException {
        this._ejbContainer.setMessageConsumerMax(consumerMax);
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setTransactionTimeout(Period timeout) {
        this._transactionTimeout = timeout.getPeriod();
    }

    public String getResinIsolation() {
        return this._resinIsolation;
    }

    public void setResinIsolation(String resinIsolation) {
        this._resinIsolation = resinIsolation;
    }

    public String getJdbcIsolation() {
        return this._jdbcIsolation;
    }

    public void setJdbcIsolation(String jdbcIsolation) {
        this._jdbcIsolation = jdbcIsolation;
    }

    public void setForbidJvmCall(boolean forbid) {
        this._forbidJVMCall = forbid;
    }

    public boolean isAutoCompile() {
        return this._autoCompile;
    }

    public void setAutoCompile(boolean autoCompile) {
        this._autoCompile = autoCompile;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public void setStartupMode(String startupMode) {
        this._startupMode = startupMode;
    }

    public static EJBServer getLocal() {
        return _localServer.get();
    }

    @PostConstruct
    public void init() {
        try {
            Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
            PersistenceManager persistenceManager = PersistenceManager.create();
            if (persistenceManager != null) {
                persistenceManager.addPersistenceUnitDefault(this._jpaProgram);
            }
            if ("manual".equals(this._startupMode)) {
                return;
            }
            this.manualInit();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public void manualInit() throws Exception {
        try {
            log.fine("Initializing ejb-server : local-jndi=" + this._ejbContainer.getProtocolManager().getLocalJndiPrefix() + " remote-jndi=" + this._ejbContainer.getProtocolManager().getRemoteJndiPrefix());
            Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
            Environment.addChildLoaderListener(new EjbEnvironmentListener());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public void initEJBs() throws Exception {
        this.manualInit();
    }
}

