/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.LineConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.inject.AnnotatedOverrideMap;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.config.reflect.ReflectionAnnotatedFactory;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.config.types.EjbLocalRef;
import com.caucho.config.types.EjbRef;
import com.caucho.config.types.EnvEntry;
import com.caucho.config.types.MessageDestinationRef;
import com.caucho.config.types.Period;
import com.caucho.config.types.PostConstructType;
import com.caucho.config.types.ResourceEnvRef;
import com.caucho.config.types.ResourceGroupConfig;
import com.caucho.config.types.ResourceRef;
import com.caucho.ejb.cfg.AroundInvokeConfig;
import com.caucho.ejb.cfg.AroundInvokeLiteral;
import com.caucho.ejb.cfg.AsyncConfig;
import com.caucho.ejb.cfg.AsynchronousLiteral;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbSecurityIdentity;
import com.caucho.ejb.cfg.ExcludeClassInterceptorsLiteral;
import com.caucho.ejb.cfg.ExcludeDefaultInterceptorsLiteral;
import com.caucho.ejb.cfg.Interceptor;
import com.caucho.ejb.cfg.InterceptorBinding;
import com.caucho.ejb.cfg.InterceptorOrder;
import com.caucho.ejb.cfg.InterceptorsDefaultLiteral;
import com.caucho.ejb.cfg.InterceptorsLiteral;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg.RemoveMethod;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.EnvironmentBean;
import com.caucho.make.ClassDependency;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.Vfs;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.Remote;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBean<X>
extends DescriptionGroupConfig
implements EnvironmentBean,
DependencyBean {
    private static final L10N L = new L10N(EjbBean.class);
    private final EjbConfig _ejbConfig;
    private final String _ejbModuleName;
    private ClassLoader _loader;
    protected ClassLoader _jClassLoader;
    private String _ejbName;
    private AnnotatedType<X> _rawAnnType;
    private AnnotatedTypeImpl<X> _ejbClass;
    private String _mappedName;
    private String _location = "";
    private String _filename;
    private int _line;
    private boolean _isInit;
    private InjectionTarget<X> _injectionTarget;
    protected ArrayList<AnnotatedType<? super X>> _remoteList = new ArrayList();
    protected ArrayList<AnnotatedType<? super X>> _localList = new ArrayList();
    protected AnnotatedType<X> _localBean;
    private boolean _isAllowPOJO = true;
    protected boolean _isContainerTransaction = true;
    ArrayList<PersistentDependency> _dependList = new ArrayList();
    ArrayList<PersistentDependency> _configDependList = new ArrayList();
    ArrayList<String> _beanDependList = new ArrayList();
    protected ArrayList<EjbMethodPattern<X>> _methodList = new ArrayList();
    private ContainerProgram _initProgram;
    private ArrayList<ConfigProgram> _postConstructList = new ArrayList();
    private ContainerProgram _serverProgram;
    private ArrayList<ResourceGroupConfig> _resourceList = new ArrayList();
    private ArrayList<Interceptor> _defaultInterceptors = new ArrayList();
    private ArrayList<Interceptor> _classInterceptors = new ArrayList();
    private ArrayList<AroundInvokeConfig> _aroundInvoke = new ArrayList();
    private ArrayList<AsyncConfig> _asyncConfig = new ArrayList();
    private String _timeoutMethodName;
    private long _transactionTimeout;
    private ArrayList<RemoveMethod> _removeMethods = new ArrayList();

    public EjbBean(EjbConfig ejbConfig, String ejbModuleName) {
        this._ejbConfig = ejbConfig;
        this._ejbModuleName = ejbModuleName;
        this._loader = ejbConfig.getEjbContainer().getClassLoader();
    }

    public EjbBean(EjbConfig ejbConfig, AnnotatedType<X> rawAnnType, AnnotatedType<X> annType, String ejbModuleName) {
        this._ejbConfig = ejbConfig;
        this._rawAnnType = rawAnnType;
        this._ejbClass = AnnotatedTypeImpl.create(annType);
        this._ejbModuleName = ejbModuleName;
        this.setEJBClass(this._ejbClass.getJavaClass());
        this._loader = ejbConfig.getEjbContainer().getClassLoader();
    }

    public EjbConfig getConfig() {
        return this._ejbConfig;
    }

    public EjbManager getEjbContainer() {
        return this._ejbConfig.getEjbContainer();
    }

    public String getModuleName() {
        return this._ejbModuleName;
    }

    public void setAroundInvoke(AroundInvokeConfig aroundInvoke) {
        this._aroundInvoke.add(aroundInvoke);
    }

    public void addAsyncMethod(AsyncConfig async) {
        this._asyncConfig.add(async);
    }

    public void setInjectionTarget(InjectionTarget<X> injectTarget) {
        this._injectionTarget = injectTarget;
    }

    public InjectionTarget<X> getInjectionTarget() {
        return this._injectionTarget;
    }

    public RemoveMethod getRemoveMethod(Method method) {
        for (RemoveMethod removeMethod : this._removeMethods) {
            if (!removeMethod.isMatch(method)) continue;
            return removeMethod;
        }
        return null;
    }

    public ArrayList<RemoveMethod> getRemoveMethods() {
        return this._removeMethods;
    }

    public String getTimeoutMethodName() {
        return this._timeoutMethodName;
    }

    public void addRemoveMethod(RemoveMethod removeMethod) {
        this._removeMethods.add(removeMethod);
    }

    public void addInterceptor(Interceptor interceptor, boolean isDefault) {
        if (isDefault) {
            this._defaultInterceptors.add(interceptor);
        } else {
            this._classInterceptors.add(interceptor);
        }
    }

    public String getEJBModuleName() {
        return this._ejbModuleName;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    protected Class<?> loadClass(String className) {
        try {
            return Class.forName(className, false, this._loader);
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create(e);
        }
    }

    public void setConfigLocation(String filename, int line) {
        if (this._filename == null) {
            this._filename = filename;
            this._line = line;
        }
        if (this._location == null) {
            this._location = filename + ":" + line + ": ";
        }
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public void setMappedName(String mappedName) {
        this._mappedName = mappedName;
    }

    public String getMappedName() {
        return this._mappedName == null ? this.getEJBName() : this._mappedName;
    }

    public String getEJBKind() {
        return "unknown";
    }

    public void setEJBClass(Class<X> ejbClass) throws ConfigException {
        if (this._ejbClass != null) {
            return;
        }
        ReflectionAnnotatedType<X> refType = ReflectionAnnotatedFactory.introspectType(ejbClass);
        AnnotatedTypeImpl<X> annType = new AnnotatedTypeImpl<X>(refType);
        this.setEJBClassWrapper(annType);
    }

    public void setEJBClassWrapper(AnnotatedType<X> ejbClass) throws ConfigException {
        if (this._ejbClass != null && !this._ejbClass.getJavaClass().getName().equals(ejbClass.getJavaClass().getName())) {
            throw this.error(L.l("ejb-class '{0}' cannot be redefined.  Old value is '{1}'.", (Object)this._ejbClass.getJavaClass().getName(), ejbClass.getJavaClass().getName()));
        }
        this._ejbClass = AnnotatedTypeImpl.create(ejbClass);
        int modifiers = this._ejbClass.getJavaClass().getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            throw this.error(L.l("'{0}' must be public.  Bean implementations must be public.", ejbClass.getJavaClass().getName()));
        }
        if (Modifier.isFinal(modifiers)) {
            throw this.error(L.l("'{0}' must not be final.  Bean implementations must not be final.", ejbClass.getJavaClass().getName()));
        }
        if (this._ejbClass.getJavaClass().isInterface()) {
            throw this.error(L.l("'{0}' must not be an interface.  Bean implementations must be classes.", ejbClass.getJavaClass().getName()));
        }
        AnnotatedMethod<X> method = this.getMethod("finalize", new Class[0]);
        if (method != null && !method.getJavaMember().getDeclaringClass().equals(Object.class)) {
            throw this.error(L.l("'{0}' may not implement finalize().  Bean implementations may not implement finalize().", method.getJavaMember().getDeclaringClass().getName()));
        }
    }

    public Class<X> getEJBClass() {
        try {
            if (this._ejbClass == null) {
                return null;
            }
            return Class.forName(this._ejbClass.getJavaClass().getName(), false, this.getClassLoader());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public AnnotatedType<X> getRawAnnotatedType() {
        return this._rawAnnType;
    }

    public AnnotatedTypeImpl<X> getAnnotatedType() {
        return this._ejbClass;
    }

    public String getEJBFullClassName() {
        return this._ejbClass.getJavaClass().getName();
    }

    public String getEJBClassName() {
        String s = this._ejbClass.getJavaClass().getName();
        int p = s.lastIndexOf(46);
        if (p > 0) {
            return s.substring(p + 1);
        }
        return s;
    }

    public String getFullImplName() {
        return this.getEJBFullClassName();
    }

    public <T> void addRemote(Class<T> remote) throws ConfigException {
        ReflectionAnnotatedType<T> refType = ReflectionAnnotatedFactory.introspectType(remote);
        AnnotatedTypeImpl<T> annType = new AnnotatedTypeImpl<T>(refType);
        this.addRemoteWrapper(annType);
    }

    public void addRemoteWrapper(AnnotatedType<? super X> remote) throws ConfigException {
        Class remoteClass = remote.getJavaClass();
        int modifiers = remoteClass.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw this.error(L.l("'{0}' must be public.  <remote> interfaces must be public.", remoteClass.getName()));
        }
        if (!remoteClass.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <remote> interfaces must be interfaces.", remoteClass.getName()));
        }
        if (!this._remoteList.contains(remote)) {
            this._remoteList.add(remote);
        }
    }

    public ArrayList<AnnotatedType<? super X>> getRemoteList() {
        return this._remoteList;
    }

    public void addLocal(Class<? super X> local) throws ConfigException {
        ReflectionAnnotatedType<? super X> refType = ReflectionAnnotatedFactory.introspectType(local);
        AnnotatedTypeImpl<? super X> annType = new AnnotatedTypeImpl<X>(refType);
        this.addLocalWrapper(annType);
    }

    public void addLocalWrapper(AnnotatedType<? super X> local) throws ConfigException {
        Class localClass = local.getJavaClass();
        if (!localClass.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface. <local> interfaces must be interfaces.", localClass.getName()));
        }
        for (int i = this._localList.size() - 1; i >= 0; --i) {
            AnnotatedType<? super X> oldLocal = this._localList.get(i);
            Class oldClass = oldLocal.getJavaClass();
            if (!localClass.equals(oldClass)) continue;
            return;
        }
        this._localList.add(local);
    }

    public ArrayList<AnnotatedType<? super X>> getLocalList() {
        return this._localList;
    }

    public AnnotatedType<X> getLocalBean() {
        return this._localBean;
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setContainerTransaction(boolean isContainerTransaction) {
        this._isContainerTransaction = isContainerTransaction;
    }

    public EjbMethodPattern<X> createMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern<X> method = this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        EjbMethodPattern method = new EjbMethodPattern(this, sig);
        this._methodList.add(method);
        return method;
    }

    public void addMethod(EjbMethodPattern<X> method) {
        this._methodList.add(method);
    }

    public boolean isMatch(AnnotatedMethod<?> method) {
        if (this._methodList.size() == 0) {
            return true;
        }
        for (EjbMethodPattern<X> ejbMethod : this._methodList) {
            if (!ejbMethod.isMatch(method)) continue;
            return true;
        }
        return false;
    }

    public EjbMethodPattern<X> getMethodPattern(AnnotatedMethod<?> method, String intf) {
        EjbMethodPattern<X> bestMethod = null;
        int bestCost = -1;
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern<X> ejbMethod = this._methodList.get(i);
            MethodSignature sig = ejbMethod.getSignature();
            if (!sig.isMatch(method, intf) || bestCost >= sig.getCost()) continue;
            bestMethod = ejbMethod;
            bestCost = sig.getCost();
        }
        return bestMethod;
    }

    public ArrayList<EjbMethodPattern<X>> getMethodList() {
        return this._methodList;
    }

    public void setTransactionTimeout(Period timeout) {
        this._transactionTimeout = timeout.getPeriod();
    }

    public void addBusinessLocal(Class localApi) {
        this.addLocal(localApi);
    }

    public void addBusinessRemote(Class<?> remoteApi) {
        this.addRemote(remoteApi);
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public MessageDestinationRef createMessageDestinationRef() {
        return new MessageDestinationRef(Vfs.lookup(this._ejbModuleName));
    }

    public void setSecurityIdentity(EjbSecurityIdentity securityIdentity) {
    }

    public void addDependencyList(ArrayList<PersistentDependency> dependList) {
        for (int i = 0; dependList != null && i < dependList.size(); ++i) {
            this.addDependency(dependList.get(i));
        }
    }

    public void addDepend(Path path) {
        this.addDependency(new Depend(path));
    }

    @Override
    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    public void addDependency(Class<?> cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public ArrayList<PersistentDependency> getDependList() {
        return this._dependList;
    }

    public void addBeanDependency(String ejbName) {
        if (!this._beanDependList.contains(ejbName)) {
            this._beanDependList.add(ejbName);
        }
    }

    public ArrayList<String> getBeanDependList() {
        return this._beanDependList;
    }

    public void addInitProgram(ConfigProgram init) {
        if (this._initProgram == null) {
            this._initProgram = new ContainerProgram();
        }
        this._initProgram.addProgram(init);
    }

    public void addBuilderProgram(ConfigProgram init) {
        if (this._serverProgram == null) {
            this._serverProgram = new ContainerProgram();
        }
        this._serverProgram.addProgram(init);
    }

    public EnvEntry createEnvEntry() {
        EnvEntry env = new EnvEntry();
        env.setProgram(true);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        env.setJndiClassLoader(loader);
        this._resourceList.add(env);
        return env;
    }

    public EjbRef createEjbRef() {
        EjbRef ref = new EjbRef();
        ref.setProgram(true);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ref.setJndiClassLoader(loader);
        this._resourceList.add(ref);
        return ref;
    }

    public EjbLocalRef createEjbLocalRef() {
        EjbLocalRef ref = new EjbLocalRef();
        ref.setProgram(true);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ref.setJndiClassLoader(loader);
        this._resourceList.add(ref);
        return ref;
    }

    public ResourceRef createResourceRef() {
        ResourceRef ref = new ResourceRef();
        ref.setProgram(true);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ref.setJndiClassLoader(loader);
        this._resourceList.add(ref);
        return ref;
    }

    public ResourceEnvRef createResourceEnvRef() {
        ResourceEnvRef ref = new ResourceEnvRef();
        ref.setProgram(true);
        this._resourceList.add(ref);
        return ref;
    }

    public ArrayList<ResourceGroupConfig> getResourceList() {
        return this._resourceList;
    }

    public void setInit(ContainerProgram init) {
        if (this._initProgram == null) {
            this._initProgram = new ContainerProgram();
        }
        this._initProgram.addProgram(init);
    }

    public void addPostConstruct(PostConstructType postConstruct) {
        this._postConstructList.add(postConstruct.getProgram(this.getEJBClass()));
    }

    public ContainerProgram getInitProgram() {
        if (this._postConstructList != null) {
            if (this._initProgram == null) {
                this._initProgram = new ContainerProgram();
            }
            for (ConfigProgram program : this._postConstructList) {
                this._initProgram.addProgram(program);
            }
            this._postConstructList = null;
        }
        return this._initProgram;
    }

    public ContainerProgram getServerProgram() {
        return this._serverProgram;
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            if (this.getAnnotatedType() == null) {
                throw this.error(L.l("ejb-class is not defined for '{0}'", this.getEJBName()));
            }
            for (EjbMethodPattern<X> methodPattern : this._methodList) {
                for (AnnotatedType<? super X> annotatedType : this._localList) {
                    for (AnnotatedMethod apiMethod : annotatedType.getMethods()) {
                        methodPattern.configure(apiMethod);
                    }
                }
                for (AnnotatedType<? super X> annotatedType : this._remoteList) {
                    for (AnnotatedMethod apiMethod : annotatedType.getMethods()) {
                        methodPattern.configure(apiMethod);
                    }
                }
            }
            this.introspect();
            this.initIntrospect();
            this.addInterceptors();
        }
        catch (ConfigException e) {
            throw ConfigException.createLine(this._location, e);
        }
    }

    protected void introspect() {
    }

    protected BeanGenerator<X> createBeanGenerator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void initIntrospect() throws ConfigException {
        boolean isExcludeDefault = false;
        for (InterceptorBinding interceptor : this._ejbConfig.getInterceptorBinding(this.getEJBName(), isExcludeDefault)) {
            this.introspectInterceptor(interceptor);
        }
        this.configureAroundInvoke(this.getAnnotatedType());
        this.configureAsync(this.getAnnotatedType());
    }

    private void introspectInterceptor(InterceptorBinding binding) {
        ArrayList<String> interceptorClasses = new ArrayList<String>();
        if (binding.getMethodList().isEmpty()) {
            InterceptorOrder interceptorOrder;
            for (Class<?> clazz : binding.getInterceptors()) {
                interceptorClasses.add(clazz.getName());
            }
            if (interceptorClasses.isEmpty() && (interceptorOrder = binding.getInterceptorOrder()) != null) {
                interceptorClasses = interceptorOrder.getInterceptorClasses();
            }
            AnnotatedTypeImpl<X> typeImpl = this.getAnnotatedType();
            if (binding.isExcludeDefaultInterceptors()) {
                typeImpl.addAnnotation((Annotation)((Object)new ExcludeDefaultInterceptorsLiteral()));
            }
            if (binding.isExcludeClassInterceptors()) {
                typeImpl.addAnnotation((Annotation)((Object)new ExcludeClassInterceptorsLiteral()));
            }
        } else {
            for (AnnotatedMethod annotatedMethod : this.getAnnotatedType().getMethods()) {
                if (!binding.isMatch(annotatedMethod) || !(annotatedMethod instanceof AnnotatedMethodImpl)) continue;
                AnnotatedMethodImpl methodImpl = (AnnotatedMethodImpl)annotatedMethod;
                if (binding.getAnnotation() != null) {
                    methodImpl.addAnnotationIfAbsent((Annotation)((Object)binding.getAnnotation()));
                }
                if (!binding.isExcludeClassInterceptors()) continue;
                methodImpl.addAnnotationIfAbsent((Annotation)((Object)new ExcludeClassInterceptorsLiteral()));
            }
        }
        for (String string : interceptorClasses) {
            Interceptor interceptor = this._ejbConfig.getInterceptor(string);
            if (interceptor == null) continue;
            interceptor.init();
            this.addInterceptor(interceptor, binding.isDefault());
        }
    }

    private void addInterceptors() {
        if (this._defaultInterceptors.size() > 0) {
            this.addDefaultInterceptors(this.createInterceptors(this._defaultInterceptors));
        }
        if (this._classInterceptors.size() > 0) {
            this.addClassInterceptors(this.createInterceptors(this._classInterceptors));
        }
    }

    private Class<?>[] createInterceptors(ArrayList<Interceptor> interceptorList) {
        Class[] interceptors = new Class[interceptorList.size()];
        for (int i = 0; i < interceptorList.size(); ++i) {
            String className = interceptorList.get(i).getInterceptorClass();
            Class<?> cl = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                interceptors[i] = cl = Class.forName(className, false, loader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw ConfigException.create(e);
            }
        }
        return interceptors;
    }

    private void addClassInterceptors(Class<?>[] cl) {
        this._ejbClass.addAnnotation((Annotation)((Object)new InterceptorsLiteral(cl)));
    }

    private void addDefaultInterceptors(Class<?>[] cl) {
        this._ejbClass.addAnnotation(new InterceptorsDefaultLiteral(cl));
    }

    public AbstractEjbBeanManager<X> deployServer(EjbManager ejbContainer, EjbLazyGenerator<X> lazyGenerator) throws ClassNotFoundException, ConfigException {
        throw new UnsupportedOperationException();
    }

    protected <T> void validateLocal(AnnotatedType<T> objectType) throws ConfigException {
        this.validateRemote(objectType);
    }

    protected <T> void validateRemote(AnnotatedType<T> objectType) throws ConfigException {
        Class objectClass = objectType.getJavaClass();
        String objectName = objectClass.getName();
        if (!objectClass.isInterface()) {
            throw this.error(L.l("'{0}' must be an interface", objectName));
        }
        for (AnnotatedMethod method : objectType.getMethods()) {
            Method javaMethod = method.getJavaMember();
            String name = javaMethod.getName();
            Class<?>[] param = javaMethod.getParameterTypes();
            if (name.startsWith("ejb")) {
                throw this.error(L.l("'{0}' forbidden in {1}.  Local or remote interfaces may not define ejbXXX methods.", (Object)EjbBean.getFullMethodName(method), objectName));
            }
            AnnotatedMethod<X> implMethod = this.validateRemoteImplMethod(javaMethod.getName(), param, method, objectType);
            this.validateExceptions(method, implMethod.getJavaMember().getExceptionTypes());
        }
    }

    private <T> AnnotatedMethod<? super X> validateRemoteImplMethod(String methodName, Class<?>[] param, AnnotatedMethod<? super T> sourceMethod, AnnotatedType<T> sourceClass) throws ConfigException {
        AnnotatedMethod<X> method = null;
        AnnotatedTypeImpl<X> beanClass = this.getAnnotatedType();
        method = AnnotatedTypeUtil.findMethod(beanClass, methodName, param);
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: '{1}' needed on the implementation class to match {2}.{3}", beanClass.getJavaClass().getName(), EjbBean.getFullMethodName(methodName, param), sourceMethod.getJavaMember().getDeclaringClass().getSimpleName(), EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: '{1}' expected", (Object)beanClass.getJavaClass().getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        Method javaMethod = method.getJavaMember();
        int modifiers = javaMethod.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw this.error(L.l("{0}: '{1}' must be public", (Object)beanClass.getJavaClass().getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (method.isStatic()) {
            throw this.error(L.l("{0}: '{1}' must not be static", (Object)beanClass.getJavaClass().getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (Modifier.isFinal(modifiers)) {
            throw this.error(L.l("{0}: '{1}' must not be final.", beanClass.getJavaClass().getName(), EjbBean.getFullMethodName(methodName, param), beanClass.getJavaClass().getName()));
        }
        return method;
    }

    public String getSkeletonName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEJBClass().getName());
        sb.append("__");
        sb.append(this.getBeanType()).append("Proxy");
        return JavaClassGenerator.cleanClassName(sb.toString());
    }

    protected String getBeanType() {
        return "Bean";
    }

    protected AnnotatedMethod<? super X> getMethod(String methodName, Class<?>[] paramTypes) {
        return AnnotatedTypeUtil.findMethod(this.getAnnotatedType(), methodName, paramTypes);
    }

    public static <X, T> AnnotatedMethod<? super X> getMethod(AnnotatedType<X> cl, AnnotatedMethod<? extends T> sourceMethod) {
        Method method = sourceMethod.getJavaMember();
        return AnnotatedTypeUtil.findMethod(cl, method.getName(), method.getParameterTypes());
    }

    public static <X> AnnotatedMethod<? super X> getMethod(AnnotatedType<X> cl, String name, Class<?>[] param) {
        return AnnotatedTypeUtil.findMethod(cl, name, param);
    }

    public boolean isCMP() {
        return false;
    }

    public boolean isCMP1() {
        return false;
    }

    public static <Y> AnnotatedMethod<? super Y> findMethod(MethodSignature sig, AnnotatedType<Y> cl, String intf) {
        if (cl == null) {
            return null;
        }
        for (AnnotatedMethod method : cl.getMethods()) {
            if (!sig.isMatch(method, intf)) continue;
            return method;
        }
        return null;
    }

    public static String getClassName(Class<?> cl) {
        if (cl == null) {
            return "null";
        }
        if (cl.isArray()) {
            return EjbBean.getClassName(cl.getComponentType()) + "[]";
        }
        if (cl.getName().startsWith("java")) {
            int p = cl.getName().lastIndexOf(46);
            return cl.getName().substring(p + 1);
        }
        return cl.getName();
    }

    public static String getShortClassName(Class<?> cl) {
        if (cl.isArray()) {
            return EjbBean.getShortClassName(cl.getComponentType()) + "[]";
        }
        return cl.getSimpleName();
    }

    public boolean classHasMethod(AnnotatedType<?> cl, AnnotatedMethod<?> method) {
        return AnnotatedTypeUtil.findMethod(cl, method) != null;
    }

    public void validateException(AnnotatedMethod<?> method, Class<?> e) throws ConfigException {
        this.validateExceptions(method, new Class[]{e});
    }

    public void validateExceptions(AnnotatedMethod<?> method, Class<?>[] exn) throws ConfigException {
        Method javaMethod = method.getJavaMember();
        Class<?>[] methodExceptions = javaMethod.getExceptionTypes();
        block0: for (int i = 0; i < exn.length; ++i) {
            if (RuntimeException.class.isAssignableFrom(exn[i])) continue;
            for (int j = 0; j < methodExceptions.length; ++j) {
                if (methodExceptions[j].isAssignableFrom(exn[i])) continue block0;
            }
            throw new ConfigException(L.l("{2}: '{0}' must throw {1}.", EjbBean.getFullMethodName(method), exn[i].getName(), javaMethod.getDeclaringClass().getName()));
        }
    }

    public void validateExceptions(AnnotatedMethod<?> caller, AnnotatedMethod<? super X> callee) throws ConfigException {
        Method callerMethod = caller.getJavaMember();
        Method calleeMethod = callee.getJavaMember();
        Class<?>[] exn = calleeMethod.getExceptionTypes();
        Class<?> missing = this.findMissingException(caller, exn);
        if (missing != null) {
            throw this.error(L.l("{0}: '{1}' must throw {2}.", callerMethod.getDeclaringClass().getName(), EjbBean.getFullMethodName(caller), EjbBean.getShortClassName(missing), callerMethod.getDeclaringClass().getName()) + L.l(" {0} must throw all {1}.{2} exceptions.", callerMethod.getName(), calleeMethod.getDeclaringClass().getSimpleName(), calleeMethod.getName()));
        }
    }

    Class<?> findMissingException(AnnotatedMethod<?> method, Class<?>[] exn) {
        for (int i = 0; i < exn.length; ++i) {
            if (AnnotatedTypeUtil.hasException(method, exn[i]) || RuntimeException.class.isAssignableFrom(exn[i])) continue;
            return exn[i];
        }
        return null;
    }

    protected <T> AnnotatedMethod<? super T> findFirstCreateMethod(AnnotatedType<T> cl) {
        for (AnnotatedMethod method : cl.getMethods()) {
            if (!method.getJavaMember().getName().startsWith("create")) continue;
            return method;
        }
        return null;
    }

    protected void introspectBean(AnnotatedType<X> type, String defaultName) throws ConfigException {
        try {
            TransactionAttribute xa;
            Remote remote;
            this.setEJBClassWrapper(type);
            String name = this.getEJBName();
            if (name == null || name.equals("")) {
                name = defaultName;
            }
            if (name == null || name.equals("")) {
                name = type.getJavaClass().getSimpleName();
            }
            this.setEJBName(name);
            Local local = (Local)type.getAnnotation(Local.class);
            if (local != null) {
                for (Class localClass : local.value()) {
                    this.addLocal(localClass);
                }
            }
            if (type.isAnnotationPresent(LocalBean.class)) {
                this._localBean = type;
            }
            if (this._localList.size() == 0) {
                this._localBean = type;
            }
            if ((remote = (Remote)type.getAnnotation(Remote.class)) != null) {
                for (Class localClass : local.value()) {
                    this.addRemote(localClass);
                }
            }
            if ((xa = (TransactionAttribute)type.getAnnotation(TransactionAttribute.class)) != null) {
                MethodSignature sig = new MethodSignature();
                sig.setMethodName("*");
                EjbMethodPattern<X> pattern = this.createMethod(sig);
                this.setPatternTransaction(pattern, xa);
            }
            this.configureMethods(type);
            this.configureAroundInvoke(type);
            this.configureAsync(type);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.createLine(this._location, e);
        }
    }

    private <Y> void configureMethods(AnnotatedType<Y> type) throws ConfigException {
        this.configureMethods(type);
    }

    private <Y> void configureBeanMethods(AnnotatedType<Y> type) throws ConfigException {
        for (AnnotatedMethod method : type.getMethods()) {
            Annotation timeout;
            TransactionAttribute xa;
            AnnotatedMethodImpl methodImpl = null;
            if (method instanceof AnnotatedMethodImpl) {
                methodImpl = (AnnotatedMethodImpl)method;
            }
            if ((xa = (TransactionAttribute)method.getAnnotation(TransactionAttribute.class)) != null) {
                EjbMethodPattern<X> pattern = this.createMethod(this.getSignature(method));
                this.setPatternTransaction(pattern, xa);
            }
            if ((timeout = method.getAnnotation(Timeout.class)) == null) continue;
            this._timeoutMethodName = method.getJavaMember().getName();
        }
    }

    private void configureAroundInvoke(AnnotatedType<X> type) {
        AnnotatedTypeImpl typeImpl = (AnnotatedTypeImpl)type;
        for (AroundInvokeConfig aroundInvoke : this._aroundInvoke) {
            this.configureAroundInvoke(typeImpl, type.getJavaClass(), aroundInvoke);
        }
    }

    private void configureAroundInvoke(AnnotatedTypeImpl<X> type, Class<?> cl, AroundInvokeConfig aroundInvoke) {
        if (cl == null) {
            return;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!aroundInvoke.isMatch(method)) continue;
            AnnotatedMethod<X> annMethod = AnnotatedTypeUtil.findMethod(type, method);
            if (annMethod == null) {
                annMethod = type.createMethod(method);
            }
            AnnotatedMethodImpl methodImpl = (AnnotatedMethodImpl)annMethod;
            methodImpl.addAnnotation((Annotation)((Object)new AroundInvokeLiteral()));
            AnnotatedOverrideMap.putMethod(method, methodImpl);
            return;
        }
        this.configureAroundInvoke(type, cl.getSuperclass(), aroundInvoke);
    }

    private void configureAsync(AnnotatedType<X> type) {
        AnnotatedTypeImpl typeImpl = (AnnotatedTypeImpl)type;
        for (AsyncConfig async : this._asyncConfig) {
            this.configureAsync(typeImpl, type.getJavaClass(), async);
        }
    }

    private void configureAsync(AnnotatedTypeImpl<X> type, Class<?> cl, AsyncConfig async) {
        if (cl == null) {
            return;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!async.isMatch(method)) continue;
            AnnotatedMethod<X> annMethod = AnnotatedTypeUtil.findMethod(type, method);
            if (annMethod == null) {
                annMethod = type.createMethod(method);
            }
            AnnotatedMethodImpl methodImpl = (AnnotatedMethodImpl)annMethod;
            methodImpl.addAnnotation((Annotation)((Object)new AsynchronousLiteral()));
            AnnotatedOverrideMap.putMethod(method, methodImpl);
            return;
        }
        this.configureAsync(type, cl.getSuperclass(), async);
    }

    private void setPatternTransaction(EjbMethodPattern<X> pattern, TransactionAttribute xa) throws ConfigException {
        TransactionAttributeType xaType = xa.value();
        pattern.setTransaction(xaType);
    }

    private MethodSignature getSignature(AnnotatedMethod<?> annMethod) throws ConfigException {
        MethodSignature sig = new MethodSignature();
        Method method = annMethod.getJavaMember();
        sig.setMethodName(method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            sig.addParam(paramTypes[i].getName());
        }
        return sig;
    }

    public static String getFullMethodName(AnnotatedMethod<?> method) {
        Method javaMethod = method.getJavaMember();
        return EjbBean.getFullMethodName(javaMethod.getName(), javaMethod.getParameterTypes());
    }

    public static String getFullMethodName(String methodName, Class<?>[] params) {
        String name = methodName + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                name = name + ", ";
            }
            name = name + params[i].getSimpleName();
        }
        return name + ")";
    }

    public ConfigException error(String msg) {
        if (this._isInit && this._filename != null) {
            return new LineConfigException(this._filename, this._line, msg);
        }
        if (this._isInit && !"".equals(this._location)) {
            return new LineConfigException(this._location + msg);
        }
        return new ConfigException(msg);
    }

    public RuntimeException error(Exception e) {
        if (this._filename != null) {
            return LineConfigException.create(this._filename, this._line, (Throwable)e);
        }
        if (this._location != null) {
            return ConfigException.createLine(this._location, e);
        }
        return ConfigException.create(e);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ejbName + "]";
    }
}

