/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.gen.TransactionAttributeLiteral;
import com.caucho.config.gen.TransactionManagementLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.AnnotatedTypeImpl;
import com.caucho.config.types.JndiBuilder;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.cfg.JmsActivationConfig;
import com.caucho.ejb.cfg.SecurityIdentity;
import com.caucho.ejb.gen.MessageGenerator;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.message.JmsActivationSpec;
import com.caucho.ejb.message.JmsResourceAdapter;
import com.caucho.ejb.message.MessageManager;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.inject.Module;
import com.caucho.jca.cfg.MessageListenerConfig;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceArchiveManager;
import com.caucho.jms.JmsMessageListener;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.AroundInvoke;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class EjbMessageBean<X>
extends EjbBean<X> {
    private static final L10N L = new L10N(EjbMessageBean.class);
    private ConnectionFactory _connectionFactory;
    private ActivationSpec _activationSpec;
    private JmsActivationConfig _jmsActivationConfig = new JmsActivationConfig();
    private String _messageSelector;
    private int _acknowledgeMode = 1;
    private String _selector;
    private String _subscriptionName;
    private Class<?> _messagingType;
    private MessageGenerator<X> _messageBean;

    public EjbMessageBean(EjbConfig config, String ejbModuleName) {
        super(config, ejbModuleName);
    }

    public EjbMessageBean(EjbConfig ejbConfig, AnnotatedType<X> rawAnnType, AnnotatedType<X> annType, MessageDriven messageDriven) {
        super(ejbConfig, rawAnnType, annType, messageDriven.name());
    }

    public EjbMessageBean(EjbConfig ejbConfig, AnnotatedType<X> rawAnnType, AnnotatedType<X> annType, String ejbName) {
        super(ejbConfig, rawAnnType, annType, ejbName);
    }

    @Override
    public String getEJBKind() {
        return "message";
    }

    @Override
    public void setEJBClass(Class<X> ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (Modifier.isAbstract(ejbClass.getModifiers())) {
            throw this.error(L.l("'{0}' must not be abstract.  Every message-driven bean must be a fully-implemented class.", ejbClass.getName()));
        }
        if (this.getEJBName() == null) {
            this.setEJBName(ejbClass.getSimpleName());
        }
    }

    public MessageDrivenDestination createMessageDrivenDestination() {
        return new MessageDrivenDestination();
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this._activationSpec = activationSpec;
    }

    public void setDestination(Destination destination) throws ConfigException {
        this._jmsActivationConfig.setDestinationObject(destination);
    }

    public void setDestinationValue(Destination destination) {
        this._jmsActivationConfig.setDestinationObject(destination);
    }

    public void setMessagingType(Class<?> messagingType) {
        if (messagingType != Object.class) {
            this._messagingType = messagingType;
        }
    }

    public Destination getDestination() {
        return this._jmsActivationConfig.getDestinationObject();
    }

    @Override
    public void setMappedName(String mappedName) throws ConfigException {
    }

    public void setMessageDestinationType(String type) throws ConfigException, NamingException {
    }

    public void setMessageDestinationLink(String messageDestinationLink) throws ConfigException, NamingException {
    }

    public void setConnectionFactory(JndiBuilder factory) throws ConfigException, NamingException {
        if (!(factory.getObject() instanceof ConnectionFactory)) {
            throw new ConfigException(L.l("'{0}' needs to implement javax.jms.ConnectionFactory.", factory.getObject()));
        }
        this._connectionFactory = (ConnectionFactory)factory.getObject();
    }

    public void setConnectionFactoryValue(ConnectionFactory factory) {
        this._connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public int getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this._acknowledgeMode = acknowledgeMode;
    }

    public String getSelector() {
        return this._selector;
    }

    public void setSelector(String selector) {
        this._selector = selector;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this._subscriptionName = subscriptionName;
    }

    public void setTransactionType(String type) throws ConfigException {
        if (type.equals("Container")) {
            this.setContainerTransaction(true);
        } else if (type.equals("Bean")) {
            this.setContainerTransaction(false);
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown transaction-type.  transaction-type must be 'Bean' or 'Container'.", type));
        }
    }

    public void setSecurityIdentity(SecurityIdentity identity) {
    }

    public ActivationConfig createActivationConfig() {
        return new ActivationConfig();
    }

    public void setResourceAdapter(String name) {
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(name);
        if (ra == null) {
            throw new ConfigException(L.l("'{0}' is an unknown resource-adapter"));
        }
    }

    private void addActivationConfigProperty(String name, Object value) {
        if ("destination".equals(name)) {
            if (value instanceof Destination) {
                this.setDestination((Destination)value);
            } else {
                Config.setAttribute(this._jmsActivationConfig, "destinationName", value);
            }
        } else if ("messageSelector".equals(name)) {
            this._messageSelector = (String)value;
        } else {
            Config.setAttribute(this._jmsActivationConfig, name, value);
        }
    }

    public void setMessageConsumerMax(int consumerMax) throws ConfigException {
        this._jmsActivationConfig.setMaxPoolSize(consumerMax);
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        int modifiers;
        if (this._messagingType == null) {
            if (this._activationSpec != null) {
                String specName = this._activationSpec.getClass().getName();
                ResourceArchive ra = ResourceArchiveManager.findResourceArchive(specName);
                if (ra == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown activation-spec.  Make sure the JCA adapter is deployed in a .rar file", specName));
                }
                try {
                    this._activationSpec.validate();
                }
                catch (Exception e) {
                    throw this.error(e);
                }
                MessageListenerConfig listener = ra.getMessageListener(specName);
                this._messagingType = listener.getMessageListenerType();
            } else if (MessageListener.class.isAssignableFrom(this.getEJBClass())) {
                this._messagingType = MessageListener.class;
            } else {
                throw this.error(L.l("'{0}' must implement javax.jms.MessageListener or specify {1}.", (Object)this.getEJBClass().getName(), this.isAllowPOJO() ? "messaging-type" : "messageListenerInterface"));
            }
        }
        super.init();
        AnnotatedMethod ejbCreate = this.getMethod("ejbCreate", new Class[0]);
        if (ejbCreate != null && !Modifier.isPublic(modifiers = ejbCreate.getJavaMember().getModifiers()) && !Modifier.isProtected(modifiers)) {
            throw this.error(L.l("{0}: ejbCreate method must be public or protected.", this.getEJBClass().getName()));
        }
    }

    @Override
    protected void introspect() {
        JmsMessageListener listener;
        super.introspect();
        MessageDriven messageDriven = this.getAnnotatedType().getAnnotation(MessageDriven.class);
        if (messageDriven != null) {
            Class type;
            ActivationConfigProperty[] activationConfig = messageDriven.activationConfig();
            if (activationConfig != null) {
                for (ActivationConfigProperty prop : activationConfig) {
                    this.addActivationConfigProperty(prop.propertyName(), prop.propertyValue());
                }
            }
            if ((type = messageDriven.messageListenerInterface()) != null && !Object.class.equals((Object)type)) {
                this._messagingType = type;
            }
        }
        if ((listener = this.getAnnotatedType().getAnnotation(JmsMessageListener.class)) != null) {
            this.addActivationConfigProperty("destination", listener.destination());
            this.addActivationConfigProperty("consumer-max", String.valueOf(listener.consumerMax()));
        }
    }

    @Override
    public void initIntrospect() throws ConfigException {
        MessageDriven messageDriven;
        super.initIntrospect();
        AnnotatedTypeImpl type = this.getAnnotatedType();
        if (!(type.isAnnotationPresent(MessageDriven.class) || type.isAnnotationPresent(MessageDriven.class) || this.isAllowPOJO())) {
            return;
        }
        AnnotatedTypeImpl typeImpl = type;
        if (!type.isAnnotationPresent(TransactionAttribute.class)) {
            typeImpl.addAnnotation((Annotation)((Object)new TransactionAttributeLiteral(TransactionAttributeType.REQUIRED)));
        }
        if ((messageDriven = (MessageDriven)type.getAnnotation(MessageDriven.class)) != null) {
            TransactionManagement transaction;
            Class messageListenerInterface;
            ActivationConfigProperty[] properties = messageDriven.activationConfig();
            if (properties != null) {
                for (ActivationConfigProperty property : properties) {
                    this.addActivationConfigProperty(property.propertyName(), property.propertyValue());
                }
            }
            if ((messageListenerInterface = messageDriven.messageListenerInterface()) != null) {
                this.setMessagingType(messageListenerInterface);
            }
            if ((transaction = (TransactionManagement)type.getAnnotation(TransactionManagement.class)) == null) {
                this.setTransactionType("Container");
            } else if (TransactionManagementType.BEAN.equals((Object)transaction.value())) {
                this.setTransactionType("Bean");
            } else {
                this.setTransactionType("Container");
            }
            this.configureMethods(type);
        }
    }

    @Override
    protected BeanGenerator<X> createBeanGenerator() {
        AnnotatedTypeImpl ejbClass = this.getAnnotatedType();
        ejbClass = this.fillClassDefaults(ejbClass);
        this._messageBean = new MessageGenerator(this.getEJBName(), ejbClass);
        return this._messageBean;
    }

    private void configureMethods(AnnotatedType<X> type) throws ConfigException {
        for (AnnotatedMethod method : type.getMethods()) {
            AroundInvoke aroundInvoke = (AroundInvoke)method.getAnnotation(AroundInvoke.class);
        }
    }

    @Override
    public AbstractEjbBeanManager<X> deployServer(EjbManager ejbManager, EjbLazyGenerator<X> lazyGenerator) throws ClassNotFoundException {
        if (this._activationSpec != null) {
            return this.deployActivationSpecServer(ejbManager, lazyGenerator);
        }
        return this.deployJmsServer(ejbManager, lazyGenerator);
    }

    private AbstractEjbBeanManager<X> deployJmsServer(EjbManager ejbManager, EjbLazyGenerator<X> lazyGenerator) throws ClassNotFoundException {
        JmsResourceAdapter ra = new JmsResourceAdapter(this.getEJBName(), this._jmsActivationConfig);
        JmsActivationSpec spec = new JmsActivationSpec();
        ra.setAcknowledgeMode(this._acknowledgeMode);
        ra.setMessageSelector(this._messageSelector);
        ra.setSubscriptionName(this._subscriptionName);
        if (this._jmsActivationConfig.getMaxPoolSize() > 0) {
            ra.setConsumerMax(this._jmsActivationConfig.getMaxPoolSize());
        } else {
            ra.setConsumerMax(this.getEjbContainer().getMessageConsumerMax());
        }
        return this.deployMessageServer(ejbManager, this.getModuleName(), lazyGenerator, ra, spec);
    }

    public AbstractEjbBeanManager<X> deployActivationSpecServer(EjbManager ejbManager, EjbLazyGenerator<X> lazyGenerator) throws ClassNotFoundException {
        if (this._activationSpec == null) {
            throw new ConfigException(L.l("ActivationSpec is required for ActivationSpecServer"));
        }
        String specType = this._activationSpec.getClass().getName();
        ResourceArchive raCfg = ResourceArchiveManager.findResourceArchive(specType);
        if (raCfg == null) {
            throw this.error(L.l("'{0}' is an unknown activation-spec.  Make sure the .rar file for the driver is properly installed.", specType));
        }
        Class raClass = raCfg.getResourceAdapterClass();
        if (raClass == null) {
            throw this.error(L.l("resource-adapter class does not exist for activation-spec '{0}'.  Make sure the .rar file for the driver is properly installed.", this._activationSpec.getClass().getName()));
        }
        InjectManager webBeans = InjectManager.create();
        ResourceAdapter ra = (ResourceAdapter)webBeans.getReference(raClass, new Annotation[0]);
        if (ra == null) {
            throw this.error(L.l("resource-adapter '{0}' must be configured in a <connector> tag.", raClass.getName()));
        }
        return this.deployMessageServer(ejbManager, this.getModuleName(), lazyGenerator, ra, this._activationSpec);
    }

    private AnnotatedType<X> fillClassDefaults(AnnotatedType<X> ejbClass) {
        TransactionAttribute ann;
        AnnotatedTypeImpl<X> ejbClassImpl = AnnotatedTypeImpl.create(ejbClass);
        if (!this._isContainerTransaction) {
            ejbClassImpl.addAnnotation((Annotation)((Object)new TransactionManagementLiteral(TransactionManagementType.BEAN)));
        }
        if ((ann = (TransactionAttribute)ejbClass.getAnnotation(TransactionAttribute.class)) == null) {
            ejbClassImpl.addAnnotation((Annotation)((Object)new TransactionAttributeLiteral(TransactionAttributeType.REQUIRED)));
        }
        return ejbClassImpl;
    }

    public AbstractEjbBeanManager<X> deployMessageServer(EjbManager ejbManager, String moduleName, EjbLazyGenerator<X> lazyGenerator, ResourceAdapter ra, ActivationSpec spec) throws ClassNotFoundException {
        MessageManager manager;
        try {
            if (spec == null) {
                throw new ConfigException(L.l("ActivationSpec is required for MessageServer"));
            }
            if (ra == null) {
                throw new ConfigException(L.l("ResourceAdapter is required for ActivationSpecServer"));
            }
            manager = new MessageManager(ejbManager, moduleName, this.getRawAnnotatedType(), this.getAnnotatedType(), lazyGenerator);
            manager.setConfigLocation(this.getFilename(), this.getLine());
            manager.setEJBName(this.getEJBName());
            manager.setMappedName(this.getMappedName());
            manager.setId(this.getEJBModuleName() + "#" + this.getMappedName());
            manager.setContainerTransaction(this.isContainerTransaction());
            manager.setEjbClass(this.getEJBClass());
            manager.setActivationSpec(spec);
            manager.setResourceAdapter(ra);
        }
        catch (Exception e) {
            throw this.error(e);
        }
        return manager;
    }

    public class MessageDrivenDestination {
        public void setDestinationType(String value) throws ConfigException, NamingException {
            EjbMessageBean.this.setMessageDestinationType(value);
        }

        public void setSubscriptionDurability(String durability) {
        }

        public void setJndiName(JndiBuilder destination) throws ConfigException, NamingException {
            EjbMessageBean.this.setDestination((Destination)destination.getObject());
        }
    }

    public static class ActivationConfigPropertyConfig {
        String _name;
        String _value;

        public void setActivationConfigPropertyName(String name) {
            this._name = name;
        }

        public String getActivationConfigPropertyName() {
            return this._name;
        }

        public void setActivationConfigPropertyValue(String value) {
            this._value = value;
        }

        public String getActivationConfigPropertyValue() {
            return this._value;
        }
    }

    public class ActivationConfig {
        public void addActivationConfigProperty(ActivationConfigPropertyConfig prop) throws NamingException {
            String name = prop.getActivationConfigPropertyName();
            String value = prop.getActivationConfigPropertyValue();
            EjbMessageBean.this.addActivationConfigProperty(name, value);
        }
    }
}

