/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.MethodHeadGenerator;
import com.caucho.ejb.gen.StatefulMethodHeadFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class StatefulMethodHeadGenerator<X>
extends MethodHeadGenerator<X> {
    private boolean _isRemoveRetainIfException;

    public StatefulMethodHeadGenerator(StatefulMethodHeadFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        super(factory, method, next);
    }

    protected TransactionAttributeType getDefaultTransactionType() {
        return TransactionAttributeType.REQUIRED;
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        super.generatePreTry(out);
        String beanClassName = this.getJavaClass().getName();
        out.println(beanClassName + " bean = _bean;");
        out.println();
        out.println("if (bean == null)");
        out.println("  throw new javax.ejb.NoSuchEJBException(\"stateful instance " + this.getJavaClass().getSimpleName() + " is no longer valid\");");
        out.println();
        out.println("if (_isActive)");
        out.println("  throw new EJBException(\"session bean is not reentrant\");");
        out.println();
        out.println("boolean isValid = false;");
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        out.println("thread.setContextClassLoader(_manager.getClassLoader());");
        out.println("_isActive = true;");
        super.generatePreCall(out);
    }

    @Override
    public void generatePostCall(JavaWriter out) throws IOException {
        out.println("isValid = true;");
    }

    @Override
    public void generateApplicationException(JavaWriter out, Class<?> exn) throws IOException {
        super.generateApplicationException(out, exn);
        out.println("isValid = true;");
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        out.println();
        out.println("_isActive = false;");
        out.println();
        if (!this._isRemoveRetainIfException) {
            out.println("if (! isValid) {");
            out.pushDepth();
            out.println("_bean = null;");
            out.println();
            out.println("if (bean != null)");
            out.print("  _manager.destroyInstance(");
            out.print(this.getBeanFactory().getBeanInstance());
            out.println(");");
            out.popDepth();
            out.println("}");
        }
        out.println("thread.setContextClassLoader(oldLoader);");
        super.generateFinally(out);
    }
}

