/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.config.ConfigException;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.ServerLocalProxy;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.naming.Jndi;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.util.L10N;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbProtocolManager {
    private static final L10N L = new L10N(EjbProtocolManager.class);
    protected static final Logger log = Logger.getLogger(EjbProtocolManager.class.getName());
    private static ThreadLocal<String> _protocolLocal = new ThreadLocal();
    private static Hashtable<String, WeakReference<AbstractEjbBeanManager<?>>> _staticServerMap = new Hashtable();
    private final EjbManager _ejbContainer;
    private final ClassLoader _loader;
    private String _localJndiPrefix;
    private String _remoteJndiPrefix;
    private String _jndiPrefix;
    private HashMap<String, AbstractEjbBeanManager<?>> _serverMap = new HashMap();
    protected ProtocolContainer _protocolContainer;
    protected HashMap<String, ProtocolContainer> _protocolMap = new HashMap();

    public EjbProtocolManager(EjbManager ejbContainer) throws ConfigException {
        this._ejbContainer = ejbContainer;
        this._loader = this._ejbContainer.getClassLoader();
        EjbManager parent = ejbContainer.getParent();
        if (parent != null) {
            this._localJndiPrefix = parent.getProtocolManager().getLocalJndiPrefix();
            this._remoteJndiPrefix = parent.getProtocolManager().getRemoteJndiPrefix();
            this._jndiPrefix = parent.getProtocolManager().getJndiPrefix();
        }
    }

    public void setJndiPrefix(String name) {
        this._jndiPrefix = name;
    }

    public String getJndiPrefix() {
        return this._jndiPrefix;
    }

    public void setLocalJndiPrefix(String name) {
        this._localJndiPrefix = name;
    }

    public String getLocalJndiPrefix() {
        return this._localJndiPrefix;
    }

    public void setRemoteJndiPrefix(String name) {
        this._remoteJndiPrefix = name;
    }

    public String getRemoteJndiPrefix() {
        return this._remoteJndiPrefix;
    }

    public EjbManager getEjbContainer() {
        return this._ejbContainer;
    }

    public void init() throws NamingException {
    }

    public static String getThreadProtocol() {
        return _protocolLocal.get();
    }

    public static String setThreadProtocol(String protocol) {
        String oldProtocol = _protocolLocal.get();
        _protocolLocal.set(protocol);
        return oldProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolContainer(ProtocolContainer protocol) {
        this._protocolContainer = protocol;
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            this._protocolMap.put(protocol.getName(), protocol);
        }
        this.addProtocolServers(protocol);
    }

    public void addProtocolContainer(ProtocolContainer protocol) {
        if (this._protocolContainer == null) {
            this._protocolContainer = protocol;
        }
        this.addProtocolContainer(protocol.getName(), protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtocolContainer(ProtocolContainer protocol) {
        if (this._protocolContainer == protocol) {
            this._protocolContainer = null;
        }
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            this._protocolMap.remove(protocol.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtocolContainer(String name, ProtocolContainer protocol) {
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            if (this._protocolMap.get(name) == null) {
                this._protocolMap.put(name, protocol);
            }
        }
        this.addProtocolServers(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolContainer getProtocol(String name) {
        HashMap<String, ProtocolContainer> hashMap = this._protocolMap;
        synchronized (hashMap) {
            return this._protocolMap.get(name);
        }
    }

    private void addProtocolServers(ProtocolContainer protocol) {
        for (AbstractEjbBeanManager<?> server : this._serverMap.values()) {
            protocol.addServer(server);
        }
    }

    public static AbstractEjbBeanManager<?> getJVMServer(String serverId) {
        WeakReference<AbstractEjbBeanManager<?>> serverRef = _staticServerMap.get(serverId);
        return serverRef != null ? (AbstractEjbBeanManager)serverRef.get() : null;
    }

    public void addServer(AbstractEjbBeanManager<?> server) {
        this._serverMap.put(server.getProtocolId(), server);
        for (ProtocolContainer protocol : this._protocolMap.values()) {
            protocol.addServer(server);
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this._loader);
                this.bindDefaultJndi(this._jndiPrefix, server);
                this.bindPortableJndiApis(server);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            Object var6_4 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    private void bindDefaultJndi(String prefix, AbstractEjbBeanManager server) {
        try {
            Object localHome;
            EnterpriseApplication eApp = EnterpriseApplication.getCurrent();
            if (prefix == null) {
                prefix = "";
            } else if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            if (eApp != null && eApp.getName() != null) {
                prefix = prefix + eApp.getName() + "/";
            }
            prefix = prefix + server.getEJBName();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ArrayList apiList = server.getLocalApi();
            if (apiList != null && apiList.size() > 0) {
                String jndiName = prefix + "/local";
                Class localApi = apiList.get(0).getJavaClass();
                Jndi.bindDeep(jndiName, new ServerLocalProxy(server, localApi));
                log.finest(server + " local binding to '" + jndiName + "' " + loader);
            }
            if ((localHome = null) != null) {
                String jndiName = prefix + "/local-home";
                Jndi.bindDeep(jndiName, localHome);
                log.finest(server + " local-home binding to '" + jndiName + "' " + loader);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindPortableJndi(String appName, String moduleName, String suffix, ServerLocalProxy proxy) {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                String jndiName = null;
                jndiName = appName != null ? "java:global/" + appName + '/' + moduleName + '/' + suffix : "java:global/" + moduleName + '/' + suffix;
                thread.setContextClassLoader(this._ejbContainer.getGlobalClassLoader());
                Jndi.bindDeep(jndiName, proxy);
                log.finer(proxy + " global binding to '" + jndiName + "' " + this._loader);
                thread.setContextClassLoader(this._loader);
                jndiName = "java:app/" + moduleName + '/' + suffix;
                Jndi.bindDeep(jndiName, proxy);
                log.finest(proxy + " application binding to '" + jndiName + "' " + this._loader);
                jndiName = "java:module/" + suffix;
                Jndi.bindDeep(jndiName, proxy);
                log.finest(proxy + " module binding to '" + jndiName + "' " + this._loader);
                Object var9_9 = null;
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Thread.currentThread().setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private void bindPortableJndiApis(AbstractEjbBeanManager manager) {
        String moduleName;
        Object jndiName = null;
        String appName = null;
        EnterpriseApplication app = EnterpriseApplication.getCurrent();
        if (app != null) {
            appName = app.getName();
        }
        if ((moduleName = manager.getModuleName()) != null) {
            ArrayList apiList;
            ServerLocalProxy proxy = null;
            if (manager.getLocalBean() != null) {
                String suffix = manager.getEJBName();
                Class api = manager.getEjbClass();
                proxy = new ServerLocalProxy(manager, api);
                this.bindPortableJndi(appName, moduleName, suffix, proxy);
                suffix = suffix + '!' + manager.getEjbClass().getName();
                this.bindPortableJndi(appName, moduleName, suffix, proxy);
            }
            if ((apiList = manager.getLocalApi()).size() == 1) {
                String suffix = manager.getEJBName();
                Class api = apiList.get(0).getJavaClass();
                if (proxy == null) {
                    proxy = new ServerLocalProxy(manager, api);
                }
                if (manager.getLocalBean() == null) {
                    this.bindPortableJndi(appName, moduleName, suffix, proxy);
                }
                suffix = suffix + '!' + api.getName();
                this.bindPortableJndi(appName, moduleName, suffix, proxy);
            } else {
                for (AnnotatedType api : apiList) {
                    String suffix = manager.getEJBName() + '!' + api.getJavaClass().getName();
                    if (proxy == null) {
                        proxy = new ServerLocalProxy(manager, api.getJavaClass());
                    }
                    this.bindPortableJndi(appName, moduleName, suffix, proxy);
                }
            }
        }
    }

    public void removeServer(AbstractEjbBeanManager<?> server) throws NamingException {
        for (ProtocolContainer protocol : this._protocolMap.values()) {
            protocol.removeServer(server);
        }
    }

    public AbstractEjbBeanManager<?> getServerByEJBName(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        return this._serverMap.get(ejbName);
    }

    public AbstractEjbBeanManager<?> getServerByServerId(String protocolId) {
        for (AbstractEjbBeanManager<?> server : this._serverMap.values()) {
            if (!protocolId.equals(server.getProtocolId())) continue;
            return server;
        }
        return null;
    }

    public Iterator getLocalNames() {
        return this._serverMap.keySet().iterator();
    }

    public ArrayList<String> getLocalChildren(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        if (!ejbName.endsWith("/")) {
            ejbName = ejbName + "/";
        }
        ArrayList<String> children = new ArrayList<String>();
        for (String name : this._serverMap.keySet()) {
            int prefixLength;
            int p;
            AbstractEjbBeanManager<?> server = this._serverMap.get(name);
            if (server.getLocalProxy(null) == null || !name.startsWith(ejbName) || children.contains(name = (p = name.indexOf(47, prefixLength = ejbName.length())) > 0 ? name.substring(prefixLength, p) : name.substring(prefixLength))) continue;
            children.add(name);
        }
        return children;
    }

    public ArrayList<String> getRemoteChildren(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        ArrayList<String> children = new ArrayList<String>();
        for (String name : this._serverMap.keySet()) {
            AbstractEjbBeanManager<?> server = this._serverMap.get(name);
        }
        if (children.size() == 0) {
            return null;
        }
        return children;
    }

    public void destroy() {
    }
}

