/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.async.AsyncItem;
import com.caucho.config.gen.CandiEnhancedBean;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.session.AbstractSessionManager;
import com.caucho.ejb.session.SessionProxyFactory;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.xml.rpc.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionContext<X, T>
extends AbstractContext<X>
implements SessionContext {
    private static final Logger log = Logger.getLogger(AbstractSessionContext.class.getName());
    private static final L10N L = new L10N(AbstractSessionContext.class);
    private transient AbstractSessionManager<X> _manager;
    private transient InjectManager _injectManager;
    private transient ClassLoader _classLoader;
    private Class<T> _api;
    private SessionProxyFactory<T> _proxyFactory;

    protected AbstractSessionContext(AbstractSessionManager<X> manager, Class<T> api) {
        assert (manager != null);
        this._classLoader = Thread.currentThread().getContextClassLoader();
        this._manager = manager;
        this._api = api;
        this._injectManager = InjectManager.create();
    }

    @Override
    public AbstractSessionManager<X> getServer() {
        return this._manager;
    }

    public InjectManager getInjectManager() {
        return this._injectManager;
    }

    public InjectManager getModuleInjectManager() {
        return this._manager.getModuleInjectManager();
    }

    public Class<T> getApi() {
        return this._api;
    }

    @Override
    public Class<?> getInvokedBusinessInterface() {
        return this.getApi();
    }

    void bind() {
        if (this._proxyFactory == null) {
            this._proxyFactory = this._manager.createProxyFactory(this);
        }
    }

    public T createProxy(CreationalContextImpl<T> env) {
        if (this._proxyFactory == null) {
            this.bind();
        }
        return this._proxyFactory.__caucho_createProxy(env);
    }

    public void destroyProxy(T instance, CreationalContextImpl<T> env) {
        if (instance instanceof CandiEnhancedBean) {
            CandiEnhancedBean candiInstance = (CandiEnhancedBean)instance;
            candiInstance.__caucho_destroy(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X newInstance(CreationalContextImpl<X> env) {
        X x;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            X instance;
            thread.setContextClassLoader(this._classLoader);
            x = instance = this._manager.newInstance(env);
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        return x;
    }

    @Override
    public void destroy() throws Exception {
        if (this._proxyFactory != null) {
            this._proxyFactory.__caucho_destroy();
        }
        super.destroy();
    }

    @Override
    public EJBHome getEJBHome() {
        throw new EJBException(L.l("EJBHome does not exist for this class"));
    }

    @Override
    public EJBLocalHome getEJBLocalHome() {
        throw new EJBException(L.l("EJBLocalHome does not exist for this class"));
    }

    public MessageContext getMessageContext() {
        throw new IllegalStateException(this.getClass().getName());
    }

    public boolean wasCancelCalled() {
        return AsyncItem.isThreadCancelled();
    }

    public <Z> Z getBusinessObject(Class<Z> businessInterface) throws IllegalStateException {
        if (businessInterface == null) {
            throw new IllegalStateException(L.l("null is not a valid local interface or no-interface view for {0}", this.getServer().getEjbClass().getName()));
        }
        AbstractSessionContext context = ((AbstractSessionManager)this.getServer()).getSessionContext(businessInterface);
        if (context == null) {
            throw new IllegalStateException(L.l("{0} is not a valid local interface or no-interface view for {1}", (Object)businessInterface.getName(), this.getServer().getEjbClass().getName()));
        }
        return context.createProxy(null);
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._api.getName() + "]";
    }

    static interface CancelCalled {
        public boolean wasCancelCalled();
    }
}

